/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam;

import java.util.HashMap;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5498;
import net.minecraft.class_743;
import net.minecraft.class_744;
import net.xolt.freecam.config.ModBindings;
import net.xolt.freecam.config.ModConfig;
import net.xolt.freecam.util.FreeCamera;
import net.xolt.freecam.util.FreecamPosition;

public class Freecam {
    public static final class_310 MC = class_310.method_1551();
    public static final String MOD_ID = "freecam";
    private static boolean freecamEnabled = false;
    private static boolean tripodEnabled = false;
    private static boolean playerControlEnabled = false;
    private static boolean disableNextTick = false;
    private static Integer activeTripod = null;
    private static FreeCamera freeCamera;
    private static HashMap<Integer, FreecamPosition> overworld_tripods;
    private static HashMap<Integer, FreecamPosition> nether_tripods;
    private static HashMap<Integer, FreecamPosition> end_tripods;
    private static class_5498 rememberedF5;

    public static void preTick(class_310 mc) {
        if (Freecam.isEnabled()) {
            if (Freecam.disableNextTick()) {
                Freecam.toggle();
                disableNextTick = false;
            }
            if (mc.field_1724 != null && mc.field_1724.field_3913 instanceof class_743 && !Freecam.isPlayerControlEnabled()) {
                class_744 input = new class_744();
                input.field_3903 = mc.field_1724.field_3913.field_3903;
                mc.field_1724.field_3913 = input;
            }
            mc.field_1773.method_35768(ModConfig.INSTANCE.visual.showHand);
        }
    }

    public static void postTick(class_310 mc) {
        if (ModBindings.KEY_TRIPOD_RESET.isPressed()) {
            for (class_304 hotbarKey : mc.field_1690.field_1852) {
                while (hotbarKey.method_1436()) {
                    Freecam.resetCamera(hotbarKey.method_1429().method_1444());
                    while (ModBindings.KEY_TRIPOD_RESET.wasPressed()) {
                    }
                }
            }
        }
        if (ModBindings.KEY_TOGGLE.isPressed()) {
            for (class_304 hotbarKey : mc.field_1690.field_1852) {
                while (hotbarKey.method_1436()) {
                    Freecam.toggleTripod(hotbarKey.method_1429().method_1444());
                    while (ModBindings.KEY_TOGGLE.wasPressed()) {
                    }
                }
            }
        } else if (ModBindings.KEY_TOGGLE.wasPressed()) {
            Freecam.toggle();
            while (ModBindings.KEY_TOGGLE.wasPressed()) {
            }
        }
        while (ModBindings.KEY_PLAYER_CONTROL.wasPressed()) {
            Freecam.switchControls();
        }
        while (ModBindings.KEY_CONFIG_GUI.wasPressed()) {
            mc.method_1507((class_437)AutoConfig.getConfigScreen(ModConfig.class, (class_437)mc.field_1755).get());
        }
    }

    public static void onDisconnect() {
        if (Freecam.isEnabled()) {
            Freecam.toggle();
        }
        Freecam.clearTripods();
    }

    public static void toggle() {
        if (tripodEnabled) {
            Freecam.toggleTripod(activeTripod);
            return;
        }
        if (freecamEnabled) {
            Freecam.onDisableFreecam();
        } else {
            Freecam.onEnableFreecam();
        }
        boolean bl = freecamEnabled = !freecamEnabled;
        if (!freecamEnabled) {
            Freecam.onDisabled();
        }
    }

    private static void toggleTripod(Integer keyCode) {
        if (keyCode == null) {
            return;
        }
        if (tripodEnabled) {
            if (activeTripod.equals(keyCode)) {
                Freecam.onDisableTripod();
                tripodEnabled = false;
            } else {
                Freecam.onDisableTripod();
                Freecam.onEnableTripod(keyCode);
            }
        } else {
            if (freecamEnabled) {
                Freecam.toggle();
            }
            Freecam.onEnableTripod(keyCode);
            tripodEnabled = true;
        }
        if (!tripodEnabled) {
            Freecam.onDisabled();
        }
    }

    public static void switchControls() {
        if (!Freecam.isEnabled()) {
            return;
        }
        if (playerControlEnabled) {
            Freecam.freeCamera.field_3913 = new class_743(Freecam.MC.field_1690);
        } else {
            Freecam.MC.field_1724.field_3913 = new class_743(Freecam.MC.field_1690);
            Freecam.freeCamera.field_3913 = new class_744();
        }
        playerControlEnabled = !playerControlEnabled;
    }

    private static void onEnableTripod(int keyCode) {
        Freecam.onEnable();
        FreecamPosition position = Freecam.getTripodsForDimension().get(keyCode);
        boolean chunkLoaded = false;
        if (position != null) {
            class_1923 chunkPos = position.getChunkPos();
            chunkLoaded = Freecam.MC.field_1687.method_2935().method_12123(chunkPos.field_9181, chunkPos.field_9180);
        }
        if (!chunkLoaded) {
            Freecam.resetCamera(keyCode);
            position = null;
        }
        freeCamera = position == null ? new FreeCamera(-420 - keyCode % 48) : new FreeCamera(-420 - keyCode % 48, position);
        freeCamera.spawn();
        MC.method_1504((class_1297)freeCamera);
        activeTripod = keyCode;
        if (ModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.openTripod").method_27693("" + activeTripod % 48), true);
        }
    }

    private static void onDisableTripod() {
        Freecam.getTripodsForDimension().put(activeTripod, new FreecamPosition((class_1297)freeCamera));
        Freecam.onDisable();
        if (Freecam.MC.field_1724 != null && ModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.closeTripod").method_27693("" + activeTripod % 48), true);
        }
        activeTripod = null;
    }

    private static void onEnableFreecam() {
        Freecam.onEnable();
        freeCamera = new FreeCamera(-420);
        freeCamera.applyPerspective(ModConfig.INSTANCE.visual.perspective, ModConfig.INSTANCE.collision.alwaysCheck || !ModConfig.INSTANCE.collision.ignoreAll);
        freeCamera.spawn();
        MC.method_1504((class_1297)freeCamera);
        if (ModConfig.INSTANCE.notification.notifyFreecam) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.enable"), true);
        }
    }

    private static void onDisableFreecam() {
        Freecam.onDisable();
        if (Freecam.MC.field_1724 != null && ModConfig.INSTANCE.notification.notifyFreecam) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.disable"), true);
        }
    }

    private static void onEnable() {
        Freecam.MC.field_1730 = false;
        Freecam.MC.field_1773.method_35768(ModConfig.INSTANCE.visual.showHand);
        rememberedF5 = Freecam.MC.field_1690.method_31044();
        if (Freecam.MC.field_1773.method_19418().method_19333()) {
            Freecam.MC.field_1690.method_31043(class_5498.field_26664);
        }
    }

    private static void onDisable() {
        Freecam.MC.field_1730 = true;
        Freecam.MC.field_1773.method_35768(true);
        MC.method_1504((class_1297)Freecam.MC.field_1724);
        playerControlEnabled = false;
        freeCamera.despawn();
        Freecam.freeCamera.field_3913 = new class_744();
        freeCamera = null;
        if (Freecam.MC.field_1724 != null) {
            Freecam.MC.field_1724.field_3913 = new class_743(Freecam.MC.field_1690);
        }
    }

    private static void onDisabled() {
        if (rememberedF5 != null) {
            Freecam.MC.field_1690.method_31043(rememberedF5);
        }
    }

    private static void resetCamera(int keyCode) {
        if (tripodEnabled && activeTripod != null && activeTripod == keyCode && freeCamera != null) {
            freeCamera.method_5719((class_1297)Freecam.MC.field_1724);
        } else {
            Freecam.getTripodsForDimension().put(keyCode, null);
        }
        if (ModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.tripodReset").method_27693("" + keyCode % 48), true);
        }
    }

    public static void clearTripods() {
        overworld_tripods = new HashMap();
        nether_tripods = new HashMap();
        end_tripods = new HashMap();
    }

    public static FreeCamera getFreeCamera() {
        return freeCamera;
    }

    public static HashMap<Integer, FreecamPosition> getTripodsForDimension() {
        return switch (Freecam.MC.field_1687.method_44013().method_29177().method_12832()) {
            case "the_nether" -> nether_tripods;
            case "the_end" -> end_tripods;
            default -> overworld_tripods;
        };
    }

    public static boolean disableNextTick() {
        return disableNextTick;
    }

    public static void setDisableNextTick(boolean damage) {
        disableNextTick = damage;
    }

    public static boolean isEnabled() {
        return freecamEnabled || tripodEnabled;
    }

    public static boolean isPlayerControlEnabled() {
        return playerControlEnabled;
    }

    static {
        overworld_tripods = new HashMap();
        nether_tripods = new HashMap();
        end_tripods = new HashMap();
        rememberedF5 = null;
    }
}

