/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import squeek.appleskin.ModConfig;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.event.TooltipOverlayEvent;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.api.handler.EventHandler;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.KeyHelper;
import squeek.appleskin.helpers.TextureHelper;

public class TooltipOverlayHandler {
    public static TooltipOverlayHandler INSTANCE;

    public static void init() {
        INSTANCE = new TooltipOverlayHandler();
    }

    public void onItemTooltip(class_1799 hoveredStack, class_1657 player, class_1836 context, List tooltip) {
        if (hoveredStack == null || tooltip == null || ModConfig.INSTANCE == null) {
            return;
        }
        if (!this.shouldShowTooltip(hoveredStack)) {
            return;
        }
        FoodValues defaultFood = FoodHelper.getDefaultFoodValues(hoveredStack);
        FoodValues modifiedFood = FoodHelper.getModifiedFoodValues(hoveredStack, player);
        FoodValuesEvent foodValuesEvent = new FoodValuesEvent(player, hoveredStack, defaultFood, modifiedFood);
        ((EventHandler)FoodValuesEvent.EVENT.invoker()).interact(foodValuesEvent);
        defaultFood = foodValuesEvent.defaultFoodValues;
        modifiedFood = foodValuesEvent.modifiedFoodValues;
        TooltipOverlayEvent.Pre prerenderEvent = new TooltipOverlayEvent.Pre(hoveredStack, defaultFood, modifiedFood);
        ((EventHandler)TooltipOverlayEvent.Pre.EVENT.invoker()).interact(prerenderEvent);
        if (prerenderEvent.isCanceled) {
            return;
        }
        FoodOverlay foodOverlay = new FoodOverlay(prerenderEvent.itemStack, defaultFood, modifiedFood, player);
        if (foodOverlay.shouldRenderHungerBars()) {
            tooltip.add(new FoodOverlayTextComponent(foodOverlay));
        }
    }

    public void onRenderTooltip(class_332 context, FoodOverlay foodOverlay, int toolTipX, int toolTipY, int tooltipZ, class_327 textRenderer) {
        if (context == null || ModConfig.INSTANCE == null) {
            return;
        }
        if (foodOverlay == null) {
            return;
        }
        class_1799 itemStack = foodOverlay.itemStack;
        FoodValues defaultFood = foodOverlay.defaultFood;
        FoodValues modifiedFood = foodOverlay.modifiedFood;
        int x = toolTipX;
        int y = toolTipY;
        TooltipOverlayEvent.Render renderEvent = new TooltipOverlayEvent.Render(itemStack, x, y, context, defaultFood, modifiedFood);
        ((EventHandler)TooltipOverlayEvent.Render.EVENT.invoker()).interact(renderEvent);
        if (renderEvent.isCanceled) {
            return;
        }
        x = renderEvent.x;
        y = renderEvent.y;
        context = renderEvent.context;
        itemStack = renderEvent.itemStack;
        class_4587 matrixStack = context.method_51448();
        int defaultFoodHunger = defaultFood.hunger;
        int modifiedFoodHunger = modifiedFood.hunger;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        x += (foodOverlay.hungerBars - 1) * 9;
        boolean isRotten = FoodHelper.isRotten(itemStack);
        for (int i = 0; i < foodOverlay.hungerBars * 2; i += 2) {
            context.method_52706(TextureHelper.FOOD_EMPTY_TEXTURE, x, y, 9, 9);
            FoodOutline outline = FoodOutline.get(modifiedFoodHunger, defaultFoodHunger, i);
            if (outline != FoodOutline.NORMAL) {
                outline.setShaderColor(context);
                context.method_52706(TextureHelper.HUNGER_OUTLINE_SPRITE, x, y, 9, 9);
            }
            context.method_51422(1.0f, 1.0f, 1.0f, 0.25f);
            boolean isDefaultHalf = defaultFoodHunger - 1 == i;
            class_2960 defaultFoodIcon = TextureHelper.getFoodTexture(isRotten, isDefaultHalf ? TextureHelper.FoodType.HALF : TextureHelper.FoodType.FULL);
            context.method_52706(defaultFoodIcon, x, y, 9, 9);
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            if (modifiedFoodHunger > i) {
                boolean isModifiedHalf = modifiedFoodHunger - 1 == i;
                class_2960 modifiedFoodIcon = TextureHelper.getFoodTexture(isRotten, isModifiedHalf ? TextureHelper.FoodType.HALF : TextureHelper.FoodType.FULL);
                context.method_52706(modifiedFoodIcon, x, y, 9, 9);
            }
            x -= 9;
        }
        if (foodOverlay.hungerBarsText != null) {
            matrixStack.method_22903();
            matrixStack.method_46416((float)(x += 18), (float)y, (float)tooltipZ);
            matrixStack.method_22905(0.75f, 0.75f, 0.75f);
            context.method_25303(textRenderer, foodOverlay.hungerBarsText, 2, 2, -5592406);
            matrixStack.method_22909();
        }
        x = toolTipX;
        y += 10;
        float modifiedSaturationIncrement = modifiedFood.getSaturationIncrement();
        float absModifiedSaturationIncrement = Math.abs(modifiedSaturationIncrement);
        x += (foodOverlay.saturationBars - 1) * 7;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < foodOverlay.saturationBars * 2; i += 2) {
            boolean shouldBeFaded;
            float effectiveSaturationOfBar = (absModifiedSaturationIncrement - (float)i) / 2.0f;
            boolean bl = shouldBeFaded = absModifiedSaturationIncrement <= (float)i;
            if (shouldBeFaded) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }
            context.method_25291(TextureHelper.MOD_ICONS, x, y, tooltipZ, effectiveSaturationOfBar >= 1.0f ? 21.0f : ((double)effectiveSaturationOfBar > 0.5 ? 14.0f : ((double)effectiveSaturationOfBar > 0.25 ? 7.0f : (effectiveSaturationOfBar > 0.0f ? 0.0f : 28.0f))), modifiedSaturationIncrement >= 0.0f ? 27.0f : 34.0f, 7, 7, 256, 256);
            if (shouldBeFaded) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            x -= 7;
        }
        if (foodOverlay.saturationBarsText != null) {
            matrixStack.method_22903();
            matrixStack.method_46416((float)(x += 14), (float)y, (float)tooltipZ);
            matrixStack.method_22905(0.75f, 0.75f, 0.75f);
            context.method_25303(textRenderer, foodOverlay.saturationBarsText, 2, 1, -5592406);
            matrixStack.method_22909();
        }
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
    }

    private boolean shouldShowTooltip(class_1799 hoveredStack) {
        boolean shouldShowTooltip;
        if (hoveredStack.method_7960()) {
            return false;
        }
        boolean bl = shouldShowTooltip = ModConfig.INSTANCE.showFoodValuesInTooltip && KeyHelper.isShiftKeyDown() || ModConfig.INSTANCE.showFoodValuesInTooltipAlways;
        if (!shouldShowTooltip) {
            return false;
        }
        return FoodHelper.isFood(hoveredStack);
    }

    public static class FoodOverlay
    implements class_5684,
    class_5632 {
        private FoodValues defaultFood;
        private FoodValues modifiedFood;
        private int biggestHunger;
        private float biggestSaturationIncrement;
        private int hungerBars;
        private String hungerBarsText;
        private int saturationBars;
        private String saturationBarsText;
        private class_1799 itemStack;

        FoodOverlay(class_1799 itemStack, FoodValues defaultFood, FoodValues modifiedFood, class_1657 player) {
            this.itemStack = itemStack;
            this.defaultFood = defaultFood;
            this.modifiedFood = modifiedFood;
            this.biggestHunger = Math.max(defaultFood.hunger, modifiedFood.hunger);
            this.biggestSaturationIncrement = Math.max(defaultFood.getSaturationIncrement(), modifiedFood.getSaturationIncrement());
            this.hungerBars = (int)Math.ceil((float)Math.abs(this.biggestHunger) / 2.0f);
            if (this.hungerBars > 10) {
                this.hungerBarsText = "x" + (this.biggestHunger < 0 ? -1 : 1) * this.hungerBars;
                this.hungerBars = 1;
            }
            this.saturationBars = (int)Math.ceil(Math.abs(this.biggestSaturationIncrement) / 2.0f);
            if (this.saturationBars > 10 || this.saturationBars == 0) {
                this.saturationBarsText = "x" + (this.biggestSaturationIncrement < 0.0f ? -1 : 1) * this.saturationBars;
                this.saturationBars = 1;
            }
        }

        boolean shouldRenderHungerBars() {
            return this.hungerBars > 0;
        }

        public int method_32661() {
            return 20;
        }

        public int method_32664(class_327 textRenderer) {
            int hungerBarLength = this.hungerBars * 9;
            if (this.hungerBarsText != null) {
                hungerBarLength += textRenderer.method_1727(this.hungerBarsText);
            }
            int saturationBarLength = this.saturationBars * 7;
            if (this.saturationBarsText != null) {
                saturationBarLength += textRenderer.method_1727(this.saturationBarsText);
            }
            return Math.max(hungerBarLength, saturationBarLength);
        }

        public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
            if (INSTANCE != null) {
                INSTANCE.onRenderTooltip(context, this, x, y, 0, textRenderer);
            }
        }
    }

    public static class FoodOverlayTextComponent
    extends EmptyText
    implements class_5481 {
        public FoodOverlay foodOverlay;

        FoodOverlayTextComponent(FoodOverlay foodOverlay) {
            this.foodOverlay = foodOverlay;
        }

        public class_5481 method_30937() {
            return this;
        }

        public boolean accept(class_5224 visitor) {
            return class_5223.method_27476((class_5348)this, (class_2583)this.method_10866(), (class_5224)visitor);
        }
    }

    static enum FoodOutline {
        NEGATIVE,
        EXTRA,
        NORMAL,
        PARTIAL,
        MISSING;


        public void setShaderColor(class_332 context) {
            switch (this) {
                case NEGATIVE: {
                    context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case EXTRA: {
                    context.method_51422(0.06f, 0.32f, 0.02f, 1.0f);
                    break;
                }
                case NORMAL: {
                    context.method_51422(0.0f, 0.0f, 0.0f, 1.0f);
                    break;
                }
                case PARTIAL: {
                    context.method_51422(0.53f, 0.21f, 0.08f, 1.0f);
                    break;
                }
                case MISSING: {
                    context.method_51422(0.62f, 0.0f, 0.0f, 0.5f);
                }
            }
        }

        public static FoodOutline get(int modifiedFoodHunger, int defaultFoodHunger, int i) {
            if (modifiedFoodHunger < 0) {
                return NEGATIVE;
            }
            if (modifiedFoodHunger > defaultFoodHunger && defaultFoodHunger <= i) {
                return EXTRA;
            }
            if (modifiedFoodHunger > i + 1 || defaultFoodHunger == modifiedFoodHunger) {
                return NORMAL;
            }
            if (modifiedFoodHunger == i + 1) {
                return PARTIAL;
            }
            return MISSING;
        }
    }

    static abstract class EmptyText
    implements class_2561 {
        static List<class_2561> emptySiblings = new ArrayList<class_2561>();

        EmptyText() {
        }

        public class_2583 method_10866() {
            return class_2583.field_24360;
        }

        public class_7417 method_10851() {
            return class_8828.field_46625;
        }

        public List<class_2561> method_10855() {
            return emptySiblings;
        }
    }
}

