/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.tabs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.api.client.gui.util.StatsTabUtils;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.client.gui.widget.CreditsTabPersonWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.config.TConfigPanelBuilder;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.util.io.TheCSDevSponsorsAPI;
import java.awt.Rectangle;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_1255;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public final class BSCreditsTab
extends StatsTab {
    private static final class_2561 TEXT_TITLE = TextUtils.translatable((String)"credits_and_attribution.button.credits", (Object[])new Object[0]);
    private static final class_2561 TEXT_CONTRIBUTORS = TextUtils.translatable((String)"betterstats.contributors.title", (Object[])new Object[0]);
    private static final class_2561 TEXT_SPONSORS = TextUtils.translatable((String)"tcdcommons.github.sponsors", (Object[])new Object[0]);
    private static final class_2561 TEXT_SPECIAL_THANKS = TextUtils.translatable((String)"tcdcommons.special_thanks", (Object[])new Object[0]);
    private static final class_2561 TEXT_FEATURED = TextUtils.translatable((String)"tcdcommons.featured", (Object[])new Object[0]);
    private static final class_2561 TEXT_FEATURED_NOONE = TextUtils.translatable((String)"tcdcommons.featured.no_one", (Object[])new Object[0]);
    private static final class_2561 TEXT_FETCH_FAIL = TextUtils.translatable((String)"tcdcommons.fetch_fail", (Object[])new Object[0]);

    @Override
    public final class_2561 getName() {
        return TEXT_TITLE;
    }

    @Override
    public final boolean isAvailable() {
        return false;
    }

    @Override
    public final void initFilters(StatsTab.FiltersInitContext initContext) {
        StatsTabUtils.initDefaultFilters(initContext);
    }

    @Override
    public final void initStats(StatsTab.StatsInitContext initContext) {
        TPanelElement panel = initContext.getStatsPanel();
        TLabelElement lbl_title = StatsTabUtils.initGroupLabel(panel, TEXT_TITLE);
        lbl_title.setSize(lbl_title.getWidth(), lbl_title.getHeight() * 2);
        lbl_title.setTextColor(0xFFFFFF);
        lbl_title.setTextScale(1.8f);
        lbl_title.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
        BSCreditsTab.initGroupLabel(panel, TEXT_CONTRIBUTORS);
        Person[] contributors = BSCreditsTab.getContributors();
        boolean highlight = true;
        int iteration = 1;
        for (Person contributor : contributors) {
            highlight = !highlight;
            Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect((TPanelElement)panel);
            CreditsTabPersonWidget ctpw = new CreditsTabPersonWidget(n1.x, n1.y, n1.width, contributor, ++iteration <= 10);
            ctpw.setBackgroundColor(highlight ? 0x44000000 : 0x22000000);
            panel.addChild((TElement)ctpw, false);
        }
        this.initSponsorSegment(initContext);
    }

    private final void initSponsorSegment(StatsTab.StatsInitContext initContext) {
        TPanelElement panel = initContext.getStatsPanel();
        BSCreditsTab.initGroupLabel(panel, (class_2561)TextUtils.literal((String)"").method_10852(TEXT_SPONSORS).method_27693(" (").method_10852(TEXT_FEATURED).method_27693(")"));
        TheCSDevSponsorsAPI.getFeaturedSponsorsAsync((class_1255)BetterStatsClient.MC_CLIENT, jsonArr -> {
            boolean highlight = true;
            int iteration = 1;
            if (jsonArr.isEmpty()) {
                Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect((TPanelElement)panel);
                TLabelElement lbl = new TLabelElement(n1.x, n1.y, n1.width, 20, TEXT_FEATURED_NOONE);
                lbl.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
                panel.addChild((TElement)lbl, false);
            } else {
                for (JsonElement personJson : jsonArr) {
                    if (!personJson.isJsonObject()) {
                        return;
                    }
                    Person person = BSCreditsTab.jsonToPerson(personJson.getAsJsonObject());
                    if (person == null) {
                        return;
                    }
                    highlight = !highlight;
                    Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect((TPanelElement)panel);
                    CreditsTabPersonWidget ctpw = new CreditsTabPersonWidget(n1.x, n1.y, n1.width, person, ++iteration <= 10);
                    ctpw.setBackgroundColor(highlight ? 0x44000000 : 0x22000000);
                    panel.addChild((TElement)ctpw, false);
                }
            }
            this.initSpecialThanksSegment(initContext);
        }, err -> {
            Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect((TPanelElement)panel);
            TLabelElement lbl = new TLabelElement(n1.x, n1.y, n1.width, 20, TEXT_FETCH_FAIL);
            lbl.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
            panel.addChild((TElement)lbl, false);
            this.initSpecialThanksSegment(initContext);
        });
    }

    private final void initSpecialThanksSegment(StatsTab.StatsInitContext initContext) {
        TPanelElement panel = initContext.getStatsPanel();
        BSCreditsTab.initGroupLabel(panel, TEXT_SPECIAL_THANKS);
        TheCSDevSponsorsAPI.getSpecialThanksAsync((class_1255)BetterStatsClient.MC_CLIENT, jsonArr -> {
            boolean highlight = true;
            int iteration = 1;
            if (jsonArr.isEmpty()) {
                Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect((TPanelElement)panel);
                TLabelElement lbl = new TLabelElement(n1.x, n1.y, n1.width, 20, TEXT_FEATURED_NOONE);
                lbl.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
                panel.addChild((TElement)lbl, false);
            } else {
                for (JsonElement personJson : jsonArr) {
                    if (!personJson.isJsonObject()) {
                        return;
                    }
                    Person person = BSCreditsTab.jsonToPerson(personJson.getAsJsonObject());
                    if (person == null) {
                        return;
                    }
                    highlight = !highlight;
                    Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect((TPanelElement)panel);
                    CreditsTabPersonWidget ctpw = new CreditsTabPersonWidget(n1.x, n1.y, n1.width, person, ++iteration <= 10);
                    ctpw.setBackgroundColor(highlight ? 0x44000000 : 0x22000000);
                    panel.addChild((TElement)ctpw, false);
                }
            }
        }, err -> {
            Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect((TPanelElement)panel);
            TLabelElement lbl = new TLabelElement(n1.x, n1.y, n1.width, 20, TEXT_FETCH_FAIL);
            lbl.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
            panel.addChild((TElement)lbl, false);
        });
    }

    private static final void initGroupLabel(TPanelElement panel, class_2561 text) {
        Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect((TPanelElement)panel);
        TPanelElement panel_tGroup = new TPanelElement(n1.x, n1.y, n1.width, 20);
        panel_tGroup.setBackgroundColor(-13290187);
        panel_tGroup.setOutlineColor(-16777216);
        panel.addChild((TElement)panel_tGroup, false);
        TLabelElement lbl = new TLabelElement(panel_tGroup.getHeight() + 5, 0, panel_tGroup.getWidth(), panel_tGroup.getHeight(), text);
        lbl.setTextHorizontalAlignment(HorizontalAlignment.LEFT);
        lbl.setTextColor(-256);
        lbl.setTextScale(0.8f);
        panel_tGroup.addChild((TElement)lbl);
    }

    public static final Person[] getContributors() {
        return (Person[])((ModContainer)FabricLoader.getInstance().getModContainer(BetterStats.getModID()).get()).getMetadata().getContributors().stream().sorted((p1, p2) -> p1.getName().compareTo(p2.getName())).toArray(Person[]::new);
    }

    @Nullable
    private static final Person jsonToPerson(JsonObject json) throws NullPointerException {
        try {
            final String name = json.get("name").getAsString();
            JsonObject contact = json.get("contact").getAsJsonObject();
            final Map<String, String> contactMap = contact.entrySet().stream().filter(entry -> ((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JsonElement)entry.getValue()).getAsString()));
            return new Person(){

                public String getName() {
                    return name;
                }

                public ContactInformation getContact() {
                    return new ContactInformation(){

                        public Optional<String> get(String key) {
                            return Optional.ofNullable((String)contactMap.get(key));
                        }

                        public Map<String, String> asMap() {
                            return contactMap;
                        }
                    };
                }
            };
        }
        catch (Exception e) {
            return null;
        }
    }
}

