/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.client.gui.stats.widget;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.BetterStatsConfig;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.AbstractStatWidget;
import io.github.thecsdev.betterstats.api.registry.BSRegistries;
import io.github.thecsdev.betterstats.api.util.enumerations.MobStatType;
import io.github.thecsdev.betterstats.api.util.stats.SUMobStat;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TEntityRendererElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_3448;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_7923;

@Virtual
public class MobStatWidget
extends AbstractStatWidget<SUMobStat> {
    private static final BetterStatsConfig BSS_CONFIG = BetterStats.getInstance().getConfig();
    public static final int SIZE = 55;
    public static final class_2561 TEXT_STAT_KILLS = MobStatType.KILLED.getText();
    public static final class_2561 TEXT_STAT_DEATHS = MobStatType.KILLED_BY.getText();
    protected final class_1299<?> entityType;
    protected final TEntityRendererElement entityRenderer;
    protected final class_7919 defaultTooltip;

    public MobStatWidget(int x, int y, SUMobStat stat) throws NullPointerException {
        this(x, y, 55, stat);
    }

    public MobStatWidget(int x, int y, int size, SUMobStat stat) throws NullPointerException {
        super(x, y, size, size, stat);
        this.entityType = stat.getEntityType();
        class_5250 ttt = TextUtils.literal((String)"").method_10852((class_2561)TextUtils.literal((String)"").method_10852(stat.getStatLabel()).method_27692(class_124.field_1054)).method_27693("\n\u00a77" + stat.getStatID()).method_27693("\n\u00a7r");
        for (class_3448 st : class_7923.field_41193) {
            Function<SUMobStat, class_2561> textFormatter;
            if (st.method_14959() != class_7923.field_41177 || (textFormatter = BSRegistries.ENTITY_STAT_TEXT_FORMATTER.get(st)) == null) continue;
            ttt.method_27693("\n\u00a7e-\u00a7r ").method_10852(textFormatter.apply(stat));
        }
        this.defaultTooltip = class_7919.method_47407((class_2561)ttt);
        this.setTooltip(this.defaultTooltip);
        this.entityRenderer = new TEntityRendererElement(x, y, size, size, this.entityType);
        this.entityRenderer.setFollowsCursor(MobStatWidget.BSS_CONFIG.guiMobsFollowCursor);
        this.addChild((TElement)this.entityRenderer, false);
    }

    @Virtual
    public void setSize(int width, int height, int flags) {
        super.setSize(width, height, flags);
        this.entityRenderer.setSize(width, height, flags);
    }

    @Override
    @Virtual
    public boolean input(TInputContext inputContext) {
        String url;
        if (inputContext.getInputType() != TInputContext.InputType.MOUSE_PRESS) {
            return false;
        }
        int btn = inputContext.getMouseButton();
        if (btn == 2 && (url = BSRegistries.getMobWikiURL(((SUMobStat)this.stat).getStatID())) != null) {
            GuiUtils.showUrlPrompt((String)url, (boolean)false);
            return false;
        }
        return super.input(inputContext);
    }
}

