/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.client.gui.screen;

import io.github.thecsdev.betterstats.api.client.gui.screen.BetterStatsScreenWrapper;
import io.github.thecsdev.betterstats.api.client.registry.BSStatsTabs;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.api.client.util.StatFilterSettings;
import io.github.thecsdev.betterstats.api.client.util.io.LocalPlayerStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IEditableStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.StatsProviderIO;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.client.gui.stats.panel.StatsTabPanel;
import io.github.thecsdev.betterstats.client.gui.stats.panel.impl.BetterStatsPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreenPlus;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreenWrapper;
import io.github.thecsdev.tcdcommons.api.client.util.interfaces.IParentScreenProvider;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2799;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_7225;
import net.minecraft.class_7696;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7706;
import org.jetbrains.annotations.Nullable;

public final class BetterStatsScreen
extends TScreenPlus
implements IParentScreenProvider {
    @Nullable
    private final class_437 parent;
    private final IStatsProvider statsProvider;
    @Nullable
    private StatsTab selectedStatsTab = BSStatsTabs.GENERAL;
    private final StatFilterSettings filterSettings = new StatFilterSettings();
    @Nullable
    private BetterStatsPanel bsPanel;

    public BetterStatsScreen(@Nullable class_437 parent) throws NullPointerException {
        this(parent, LocalPlayerStatsProvider.getInstance());
    }

    public BetterStatsScreen(@Nullable class_437 parent, IStatsProvider statsProvider) throws NullPointerException {
        super((class_2561)TextUtils.translatable((String)"gui.stats", (Object[])new Object[0]));
        this.parent = parent;
        this.statsProvider = Objects.requireNonNull(statsProvider);
    }

    protected final TScreenWrapper<?> createScreenWrapper() {
        return new BetterStatsScreenWrapper(this);
    }

    public final class_437 getParentScreen() {
        return this.parent;
    }

    public final boolean shouldPause() {
        return true;
    }

    public final boolean shouldRenderInGameHud() {
        return false;
    }

    public final void close() {
        if (!(this.parent instanceof class_433)) {
            this.getClient().method_1507(this.parent);
        } else {
            super.close();
        }
    }

    protected final void onOpened() {
        if (BetterStatsClient.MC_CLIENT.field_1687 != null) {
            class_7706.method_47330((class_7699)class_7699.method_45398((class_7696)class_7701.field_40177), (boolean)true, (class_7225.class_7874)BetterStatsClient.MC_CLIENT.field_1687.method_30349());
        }
        if (this.statsProvider != LocalPlayerStatsProvider.getInstance()) {
            return;
        }
        this.client.method_1562().method_52787((class_2596)new class_2799(class_2799.class_2800.field_12775));
    }

    protected final void onClosed() {
        double val = this.bsPanel.getStatsTabVerticalScrollAmount();
        this.filterSettings.setProperty(StatsTabPanel.FILTER_ID_SCROLL_CACHE, new Double[]{val});
    }

    public final IStatsProvider getStatsProvider() {
        return this.statsProvider;
    }

    @Nullable
    public final StatsTab getStatsTab() {
        return this.selectedStatsTab;
    }

    public final void setStatsTab(@Nullable StatsTab statsTab) {
        this.selectedStatsTab = statsTab;
        this.refresh();
    }

    public final void refresh() {
        if (!this.isOpen()) {
            return;
        }
        this.clearChildren();
        this.init();
    }

    protected final void init() {
        this.bsPanel = new BetterStatsPanel(0, 0, this.getWidth(), this.getHeight(), new BetterStatsPanel.BetterStatsPanelProxy(){

            @Override
            public IStatsProvider getStatsProvider() {
                return BetterStatsScreen.this.statsProvider;
            }

            @Override
            public StatsTab getSelectedStatsTab() {
                return BetterStatsScreen.this.selectedStatsTab;
            }

            @Override
            public void setSelectedStatsTab(StatsTab statsTab) {
                BetterStatsScreen.this.setStatsTab(statsTab);
            }

            @Override
            public final StatFilterSettings getFilterSettings() {
                return BetterStatsScreen.this.filterSettings;
            }
        });
        this.addChild((TElement)this.bsPanel, false);
    }

    public final boolean filesDragged(Collection<Path> files) {
        if (files.size() != 1) {
            return false;
        }
        Path file = files.iterator().next();
        if (!file.toString().endsWith("." + "mcbs".toLowerCase())) {
            return false;
        }
        try {
            IEditableStatsProvider stats = StatsProviderIO.loadFromFile(file.toFile());
            class_437 screen = new BetterStatsScreen(this.parent, stats).getAsScreen();
            BetterStatsClient.MC_CLIENT.method_1507(screen);
        }
        catch (IOException exc) {
            return false;
        }
        return true;
    }
}

