/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.compat.ContraptionCollidable;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.util.PlayerUtil;
import eu.ha3.presencefootsteps.world.Association;
import eu.ha3.presencefootsteps.world.Emitter;
import eu.ha3.presencefootsteps.world.Solver;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_745;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PFSolver
implements Solver {
    private static final Logger LOGGER = LogManager.getLogger((String)"PFSolver");
    private static final double TRAP_DOOR_OFFSET = 0.1;
    private final SoundEngine engine;

    public PFSolver(SoundEngine engine) {
        this.engine = engine;
    }

    @Override
    public boolean playAssociation(class_1309 ply, Association assos, State eventType) {
        if (!assos.isResult()) {
            return false;
        }
        if (!assos.isNotEmitter()) {
            if ((assos = assos.at(ply)).hasAssociation()) {
                this.engine.getIsolator().acoustics().playAcoustic(assos, eventType, Options.EMPTY);
            } else {
                this.engine.getIsolator().stepPlayer().playStep(assos);
            }
        }
        return true;
    }

    @Override
    public Association findAssociation(class_1309 ply, double verticalOffsetAsMinus, boolean isRightFoot) {
        double rot = Math.toRadians(class_3532.method_15393((float)ply.method_36454()));
        class_243 pos = ply.method_19538();
        float feetDistanceToCenter = 0.2f * (float)(isRightFoot ? -1 : 1) * PlayerUtil.getScale(ply);
        class_2338 footPos = class_2338.method_49637((double)(pos.field_1352 + Math.cos(rot) * (double)feetDistanceToCenter), (double)(ply.method_5829().method_1001(class_2350.class_2351.field_11052) - 0.1 - verticalOffsetAsMinus), (double)(pos.field_1350 + Math.sin(rot) * (double)feetDistanceToCenter));
        if (feetDistanceToCenter > 1.0f) {
            for (class_2338 underfootPos : class_2338.method_25996((class_2338)footPos, (int)((int)feetDistanceToCenter), (int)2, (int)((int)feetDistanceToCenter))) {
                Association assos = this.findAssociation((class_1297)ply, underfootPos);
                if (!assos.hasAssociation()) continue;
                return assos;
            }
        }
        return this.findAssociation((class_1297)ply, footPos);
    }

    private Association findAssociation(class_1297 player, class_2338 pos) {
        boolean isXdangMax;
        Association worked;
        class_243 vel;
        if (!(player instanceof class_745) && (vel = player.method_18798()).method_1027() != 0.0 && Math.abs(vel.field_1351) < 0.004) {
            return Association.NOT_EMITTER;
        }
        class_238 collider = player.method_5829();
        collider = collider.method_989(0.0, -(collider.field_1322 - Math.floor(collider.field_1322)), 0.0);
        double expansionRatio = 0.1;
        collider = collider.method_1014(expansionRatio);
        if (player.method_5624()) {
            collider = collider.method_1009(0.3, 0.5, 0.3);
        }
        if (!(worked = this.findAssociation(player, pos, collider)).isNull()) {
            return worked;
        }
        double xdang = (player.method_23317() - (double)pos.method_10263()) * 2.0 - 1.0;
        double zdang = (player.method_23321() - (double)pos.method_10260()) * 2.0 - 1.0;
        if (Math.max(Math.abs(xdang), Math.abs(zdang)) <= (double)0.2f) {
            return worked;
        }
        boolean bl = isXdangMax = Math.abs(xdang) > Math.abs(zdang);
        worked = isXdangMax ? this.findAssociation(player, pos.method_10089(xdang > 0.0 ? 1 : -1), collider) : this.findAssociation(player, pos.method_10077(zdang > 0.0 ? 1 : -1), collider);
        if (!worked.isNull()) {
            return worked;
        }
        if (isXdangMax) {
            return this.findAssociation(player, pos.method_10077(zdang > 0.0 ? 1 : -1), collider);
        }
        return this.findAssociation(player, pos.method_10089(xdang > 0.0 ? 1 : -1), collider);
    }

    private String findForGolem(class_1937 world, class_2338 pos, String substrate) {
        String golem;
        List golems = world.method_8390(class_1297.class, new class_238(pos).method_1009(0.5, 0.0, 0.5), e -> !(e instanceof class_1657));
        if (!golems.isEmpty() && Emitter.isEmitter(golem = this.engine.getIsolator().golems().getAssociation(((class_1297)golems.get(0)).method_5864(), substrate))) {
            LOGGER.debug("Golem detected: " + golem);
            return golem;
        }
        return "UNASSIGNED";
    }

    private class_2680 getBlockStateAt(class_1297 entity, class_2338 pos) {
        class_1937 world = entity.method_37908();
        class_2680 state = world.method_8320(pos);
        if (state.method_26215() && entity instanceof ContraptionCollidable) {
            ContraptionCollidable collidable = (ContraptionCollidable)entity;
            state = collidable.getCollidedStateAt(pos);
        }
        return state;
    }

    private Association findAssociation(class_1297 entity, class_2338 pos, class_238 collider) {
        String wet;
        class_2680 in = this.getBlockStateAt(entity, pos);
        class_2338 up = pos.method_10084();
        class_2680 above = this.getBlockStateAt(entity, up);
        Object association = this.findForGolem(entity.method_37908(), up, "carpet");
        boolean wasGolem = false;
        String wetAssociation = "NOT_EMITTER";
        if (!Emitter.isEmitter((String)association)) {
            association = this.engine.getIsolator().blocks().getAssociation(above, "carpet");
        } else {
            wasGolem = true;
        }
        if (Emitter.isEmitter((String)association)) {
            LOGGER.debug("Carpet detected: " + (String)association);
            pos = up;
            in = above;
        } else {
            String foliage;
            class_265 shape;
            if (in.method_26215() || in.method_26220((class_1922)entity.method_37908(), pos).method_1105(class_2350.class_2351.field_11052) < (double)0.3f) {
                class_2338 down = pos.method_10074();
                class_2680 below = this.getBlockStateAt(entity, down);
                association = this.engine.getIsolator().blocks().getAssociation(below, "bigger");
                if (Emitter.isResult((String)association)) {
                    LOGGER.debug("Fence detected: " + (String)association);
                    pos = down;
                    in = below;
                }
            }
            if ((shape = in.method_26220((class_1922)entity.method_37908(), pos)).method_1110()) {
                shape = in.method_26218((class_1922)entity.method_37908(), pos);
            }
            if (!shape.method_1110() && !shape.method_1107().method_996(pos).method_994(collider)) {
                LOGGER.debug("Skipping due to hitbox miss");
                return Association.NOT_EMITTER;
            }
            if (!Emitter.isResult((String)association)) {
                association = this.findForGolem(entity.method_37908(), pos, "");
                if (!Emitter.isEmitter((String)association)) {
                    association = this.engine.getIsolator().blocks().getAssociation(in, "");
                } else {
                    wasGolem = true;
                }
            }
            if (Emitter.isEmitter((String)association) && Emitter.isEmitter(foliage = this.engine.getIsolator().blocks().getAssociation(above, "foliage"))) {
                LOGGER.debug("Foliage detected: " + foliage);
                association = (String)association + "," + foliage;
            }
        }
        if (Emitter.isEmitter((String)association) && (entity.method_37908().method_8520(up) || !wasGolem && (in.method_26227().method_15767(class_3486.field_15517) || above.method_26227().method_15767(class_3486.field_15517))) && Emitter.isEmitter(wet = this.engine.getIsolator().blocks().getAssociation(in, "wet"))) {
            LOGGER.debug("Wet block detected: " + wet);
            wetAssociation = wet;
        }
        if (Emitter.isNonEmitter((String)association) && Emitter.isNonEmitter(wetAssociation)) {
            return Association.NOT_EMITTER;
        }
        if (Emitter.isResult((String)association)) {
            return new Association(in, pos).withDry((String)association).withWet(wetAssociation);
        }
        if (in.method_26215()) {
            return Association.NOT_EMITTER;
        }
        class_2498 sounds = in.method_26231();
        String substrate = String.format(Locale.ENGLISH, "%.2f_%.2f", Float.valueOf(sounds.field_11540), Float.valueOf(sounds.field_11539));
        String primitive = this.engine.getIsolator().primitives().getAssociation(sounds, substrate);
        if (Emitter.isResult(primitive)) {
            return new Association(in, pos).withDry(primitive).withWet(wetAssociation);
        }
        return Association.NOT_EMITTER;
    }

    @Override
    public Association findAssociation(class_1309 ply, class_2338 pos, String strategy) {
        if (!"find_messy_foliage".equals(strategy)) {
            return Association.NOT_EMITTER;
        }
        class_2680 above = this.getBlockStateAt((class_1297)ply, pos.method_10084());
        String foliage = this.engine.getIsolator().blocks().getAssociation(above, "foliage");
        if (!Emitter.isEmitter(foliage)) {
            return Association.NOT_EMITTER;
        }
        if ("MESSY_GROUND".equals(this.engine.getIsolator().blocks().getAssociation(above, "messy"))) {
            return new Association(above, pos.method_10084()).withDry(foliage);
        }
        return Association.NOT_EMITTER;
    }
}

