/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import eu.ha3.presencefootsteps.config.Variator;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.generator.Modifier;
import eu.ha3.presencefootsteps.sound.generator.TerrestrialStepSoundGenerator;
import eu.ha3.presencefootsteps.util.MathUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;

class WingedStepSoundGenerator
extends TerrestrialStepSoundGenerator {
    protected boolean isFalling = false;
    protected FlightState state = FlightState.IDLE;
    protected int flapMod = 0;
    private long lastTimeImmobile;
    protected long nextFlapTime;

    public WingedStepSoundGenerator(SoundEngine engine, Modifier<TerrestrialStepSoundGenerator> modifier) {
        super(engine, modifier);
    }

    @Override
    public boolean generateFootsteps(class_1309 ply) {
        this.lastTimeImmobile = this.timeImmobile;
        return super.generateFootsteps(ply);
    }

    @Override
    protected void simulateAirborne(class_1309 ply) {
        this.isFalling = this.motionTracker.getMotionY() < -0.3;
        super.simulateAirborne(ply);
        if (this.isAirborne) {
            this.simulateFlying(ply);
        }
    }

    @Override
    protected boolean updateImmobileState(class_1309 ply, float reference) {
        if (this.isAirborne) {
            class_243 vel = ply.method_18798();
            boolean stationary = vel.field_1352 != 0.0 && vel.field_1350 != 0.0;
            this.lastReference = reference;
            if (!this.isImmobile && stationary) {
                this.timeImmobile = System.currentTimeMillis();
                this.isImmobile = true;
            } else if (this.isImmobile && !stationary) {
                this.isImmobile = false;
                return System.currentTimeMillis() - this.timeImmobile > (long)this.engine.getIsolator().variator().IMMOBILE_DURATION;
            }
            return false;
        }
        return super.updateImmobileState(ply, reference);
    }

    protected int getWingSpeed() {
        Variator variator = this.engine.getIsolator().variator();
        return switch (this.state) {
            case FlightState.COASTING -> {
                if (this.flapMod == 0) {
                    yield variator.WING_SPEED_COAST;
                }
                yield variator.WING_SPEED_NORMAL * this.flapMod;
            }
            case FlightState.COASTING_STRAFING -> variator.WING_SPEED_NORMAL * (1 + this.flapMod);
            case FlightState.DASHING -> variator.WING_SPEED_RAPID;
            case FlightState.ASCENDING, FlightState.FLYING -> variator.WING_SPEED_NORMAL;
            default -> variator.WING_SPEED_IDLE;
        };
    }

    @Override
    protected void simulateJumpingLanding(class_1309 ply) {
        boolean speedingJumpStateChange;
        if (this.hasStoppingConditions((class_1297)ply)) {
            return;
        }
        long now = System.currentTimeMillis();
        float speed = (float)Math.sqrt(this.motionTracker.getHorizontalSpeed());
        Variator variator = this.engine.getIsolator().variator();
        if (this.isAirborne) {
            this.nextFlapTime = now + (long)variator.WING_JUMPING_REST_TIME;
        }
        boolean hugeLanding = !this.isAirborne && this.lastFallDistance > variator.HUGEFALL_LANDING_DISTANCE_MIN;
        boolean bl = speedingJumpStateChange = speed > variator.MIN_MOTION_HOR;
        if (hugeLanding || speedingJumpStateChange) {
            if (!this.isAirborne) {
                float volume = speedingJumpStateChange ? 2.0f : MathUtil.scalex(this.lastFallDistance, variator.HUGEFALL_LANDING_DISTANCE_MIN, variator.HUGEFALL_LANDING_DISTANCE_MAX);
                this.engine.getIsolator().acoustics().playAcoustic(ply, "_SWIFT", State.LAND, Options.singular("gliding_volume", volume));
            } else {
                this.engine.getIsolator().acoustics().playAcoustic(ply, "_SWIFT", State.JUMP, Options.EMPTY);
            }
        }
        if (this.isAirborne && this.isJumping(ply)) {
            this.simulateJumping(ply);
        } else if (!this.isAirborne && hugeLanding) {
            this.simulateLanding(ply);
        }
    }

    protected void simulateFlying(class_1309 ply) {
        long now = System.currentTimeMillis();
        Variator variator = this.engine.getIsolator().variator();
        if (this.updateState(this.motionTracker.getHorizontalSpeed(), this.motionTracker.getMotionY(), ply.field_6212)) {
            this.nextFlapTime = now + (long)variator.FLIGHT_TRANSITION_TIME;
        }
        if (!ply.method_5869() && !this.isFalling && now > this.nextFlapTime) {
            this.nextFlapTime = now + (long)this.getWingSpeed() + (long)(ply.method_37908().field_9229.method_43048(100) - 50);
            this.flapMod = (this.flapMod + 1) % (1 + ply.method_37908().field_9229.method_43048(4));
            float volume = 1.0f;
            long diffImmobile = now - this.lastTimeImmobile;
            if (diffImmobile > (long)variator.WING_IMMOBILE_FADE_START) {
                volume -= MathUtil.scalex(diffImmobile, variator.WING_IMMOBILE_FADE_START, variator.WING_IMMOBILE_FADE_START + variator.WING_IMMOBILE_FADE_DURATION);
            }
            this.engine.getIsolator().acoustics().playAcoustic(ply, "_WING", State.WALK, Options.singular("gliding_volume", volume));
        }
    }

    protected boolean updateState(double horSpeed, double verticalSpeed, double strafe) {
        float motionHor = (float)Math.sqrt(horSpeed);
        FlightState result = FlightState.IDLE;
        Variator variator = this.engine.getIsolator().variator();
        if (motionHor > variator.MIN_DASH_MOTION) {
            result = FlightState.DASHING;
        } else if (motionHor > variator.MIN_COAST_MOTION && (float)Math.abs(verticalSpeed) < variator.MIN_COAST_MOTION / 20.0f) {
            result = strafe > (double)variator.MIN_MOTION_Y ? FlightState.COASTING_STRAFING : FlightState.COASTING;
        } else if (motionHor > variator.MIN_MOTION_HOR) {
            result = FlightState.FLYING;
        } else if (verticalSpeed < 0.0) {
            result = FlightState.DESCENDING;
        } else if ((float)verticalSpeed > variator.MIN_MOTION_Y) {
            result = FlightState.ASCENDING;
        }
        boolean changed = result != this.state;
        this.state = result;
        return changed;
    }

    private static enum FlightState {
        DASHING,
        COASTING,
        COASTING_STRAFING,
        FLYING,
        IDLE,
        ASCENDING,
        DESCENDING;

    }
}

