/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.generator.MineLP;
import eu.ha3.presencefootsteps.sound.generator.Modifier;
import eu.ha3.presencefootsteps.sound.generator.QuadrupedModifier;
import eu.ha3.presencefootsteps.sound.generator.StepSoundGenerator;
import eu.ha3.presencefootsteps.sound.generator.TerrestrialStepSoundGenerator;
import eu.ha3.presencefootsteps.sound.generator.WingedStepSoundGenerator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_746;

public enum Locomotion {
    NONE,
    BIPED(engine -> new TerrestrialStepSoundGenerator((SoundEngine)engine, new Modifier<TerrestrialStepSoundGenerator>())),
    QUADRUPED(engine -> new TerrestrialStepSoundGenerator((SoundEngine)engine, new QuadrupedModifier())),
    FLYING(engine -> new WingedStepSoundGenerator((SoundEngine)engine, new QuadrupedModifier())),
    FLYING_BIPED(engine -> new WingedStepSoundGenerator((SoundEngine)engine, new Modifier<TerrestrialStepSoundGenerator>()));

    private static final Map<String, Locomotion> registry;
    private final Function<SoundEngine, Optional<StepSoundGenerator>> constructor;
    private static final String AUTO_TRANSLATION_KEY = "menu.pf.stance.auto";
    private final String translationKey = "menu.pf.stance." + this.name().toLowerCase();

    private Locomotion() {
        this.constructor = engine -> Optional.empty();
    }

    private Locomotion(Function<SoundEngine, StepSoundGenerator> gen) {
        this.constructor = engine -> Optional.of((StepSoundGenerator)gen.apply((SoundEngine)engine));
    }

    public Optional<StepSoundGenerator> supplyGenerator(SoundEngine engine) {
        return this.constructor.apply(engine);
    }

    public class_2561 getOptionName() {
        return class_2561.method_43469((String)"menu.pf.stance", (Object[])new Object[]{class_2561.method_43471((String)(this == NONE ? AUTO_TRANSLATION_KEY : this.translationKey))});
    }

    public class_2561 getOptionTooltip() {
        return class_2561.method_43471((String)(this.translationKey + ".tooltip"));
    }

    public String getDisplayName() {
        return class_1074.method_4662((String)"pf.stance", (Object[])new Object[]{class_1074.method_4662((String)this.translationKey, (Object[])new Object[0])});
    }

    public static Locomotion byName(String name) {
        return registry.getOrDefault(name, BIPED);
    }

    public static Locomotion forLiving(class_1297 entity, Locomotion fallback) {
        if (MineLP.hasPonies()) {
            return MineLP.getLocomotion(entity, fallback);
        }
        return fallback;
    }

    public static Locomotion forPlayer(class_1657 ply, Locomotion preference) {
        if (preference == NONE) {
            if (ply instanceof class_746 && MineLP.hasPonies()) {
                return MineLP.getLocomotion(ply);
            }
            return BIPED;
        }
        return preference;
    }

    static {
        registry = new Object2ObjectOpenHashMap();
        for (Locomotion i : Locomotion.values()) {
            registry.put(i.name(), i);
            registry.put(String.valueOf(i.ordinal()), i);
        }
    }
}

