/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.gson.JsonObject;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.util.Range;
import net.minecraft.class_1309;

record VaryingAcoustic(String soundName, Range volume, Range pitch) implements Acoustic
{
    static final Acoustic.Serializer FACTORY = (json, context) -> {
        if (json.isJsonPrimitive()) {
            return new VaryingAcoustic(context.getSoundName(json.getAsString()), context.defaultVolume(), context.defaultPitch());
        }
        JsonObject jso = json.getAsJsonObject();
        return new VaryingAcoustic(context.getSoundName(jso.get("name").getAsString()), context.defaultVolume().read("vol", jso), context.defaultPitch().read("pitch", jso));
    };

    @Override
    public void playSound(SoundPlayer player, class_1309 location, State event, Options inputOptions) {
        VaryingAcoustic.playSound(this.soundName, this.volume, this.pitch, Options.EMPTY, player, location, inputOptions);
    }

    static void playSound(String soundName, Range volume, Range pitch, Options options, SoundPlayer player, class_1309 location, Options inputOptions) {
        if (soundName.isEmpty()) {
            return;
        }
        float finalVolume = inputOptions.containsKey("gliding_volume") ? volume.on(inputOptions.get("gliding_volume")) : volume.random(player.getRNG());
        float finalPitch = inputOptions.containsKey("gliding_pitch") ? pitch.on(inputOptions.get("gliding_pitch")) : pitch.random(player.getRNG());
        player.playSound(location, soundName, finalVolume, finalPitch, options.and(inputOptions));
    }
}

