/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound;

import eu.ha3.presencefootsteps.config.Variator;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticLibrary;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsFile;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsPlayer;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import eu.ha3.presencefootsteps.sound.player.ImmediateSoundPlayer;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.sound.player.StepSoundPlayer;
import eu.ha3.presencefootsteps.util.BlockReport;
import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import eu.ha3.presencefootsteps.util.ResourceUtils;
import eu.ha3.presencefootsteps.world.GolemLookup;
import eu.ha3.presencefootsteps.world.Index;
import eu.ha3.presencefootsteps.world.LocomotionLookup;
import eu.ha3.presencefootsteps.world.Lookup;
import eu.ha3.presencefootsteps.world.PrimitiveLookup;
import eu.ha3.presencefootsteps.world.StateLookup;
import java.io.IOException;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public record Isolator(Variator variator, Index<class_1297, Locomotion> locomotions, Lookup<class_1299<?>> golems, Lookup<class_2680> blocks, Lookup<class_2498> primitives, SoundPlayer soundPlayer, StepSoundPlayer stepPlayer, AcousticLibrary acoustics) implements BlockReport.Reportable
{
    private static final class_2960 BLOCK_MAP = new class_2960("presencefootsteps", "config/blockmap.json");
    private static final class_2960 GOLEM_MAP = new class_2960("presencefootsteps", "config/golemmap.json");
    private static final class_2960 LOCOMOTION_MAP = new class_2960("presencefootsteps", "config/locomotionmap.json");
    private static final class_2960 PRIMITIVE_MAP = new class_2960("presencefootsteps", "config/primitivemap.json");
    private static final class_2960 ACOUSTICS = new class_2960("presencefootsteps", "config/acoustics.json");
    private static final class_2960 VARIATOR = new class_2960("presencefootsteps", "config/variator.json");

    public Isolator(SoundEngine engine) {
        this(engine, new ImmediateSoundPlayer(engine));
    }

    public Isolator(SoundEngine engine, SoundPlayer player) {
        this(engine, player, (StepSoundPlayer)((Object)player));
    }

    public Isolator(SoundEngine engine, SoundPlayer player, StepSoundPlayer stepPlayer) {
        this(new Variator(), new LocomotionLookup(engine), new GolemLookup(), new StateLookup(), new PrimitiveLookup(), player, stepPlayer, new AcousticsPlayer(player));
    }

    public boolean load(class_3300 manager) {
        boolean hasConfigurations = false;
        hasConfigurations |= ResourceUtils.forEachReverse(BLOCK_MAP, manager, this.blocks()::load);
        hasConfigurations |= ResourceUtils.forEach(GOLEM_MAP, manager, this.golems()::load);
        hasConfigurations |= ResourceUtils.forEach(PRIMITIVE_MAP, manager, this.primitives()::load);
        hasConfigurations |= ResourceUtils.forEach(LOCOMOTION_MAP, manager, this.locomotions()::load);
        hasConfigurations |= ResourceUtils.forEach(ACOUSTICS, manager, reader -> AcousticsFile.read(reader, this.acoustics()::addAcoustic));
        return hasConfigurations |= ResourceUtils.forEach(VARIATOR, manager, this.variator()::load);
    }

    @Override
    public void writeToReport(boolean full, JsonObjectWriter writer, Map<String, class_2498> groups) throws IOException {
        writer.object(() -> {
            writer.object("blocks", () -> this.blocks().writeToReport(full, writer, groups));
            writer.object("entities", () -> this.locomotions().writeToReport(full, writer, groups));
            writer.object("primitives", () -> this.primitives().writeToReport(full, writer, groups));
        });
    }
}

