/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.TextureCache;
import journeymap.common.Journeymap;
import net.minecraft.class_1011;
import net.minecraft.class_1068;
import net.minecraft.class_156;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class IgnSkin {
    private static String ID_LOOKUP_URL = "https://api.mojang.com/users/profiles/minecraft/%s?at=%s";
    private static String PROFILE_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s";
    private static Map<UUID, class_1011> faceImageCache = Maps.newHashMap();
    private static final Map<URL, CompletableFuture<class_1011>> imageRequests = Maps.newConcurrentMap();

    public static class_1011 getFaceImage(UUID playerId, String username) {
        boolean firstPass;
        boolean bl = firstPass = !faceImageCache.containsKey(playerId);
        if (firstPass) {
            faceImageCache.put(playerId, null);
            class_2631.method_52580((String)username).thenAccept(optional -> {
                GameProfile gameProfile = optional.orElse(new GameProfile(class_156.field_25140, username));
                try {
                    MinecraftSessionService mss = class_310.method_1551().method_1495();
                    MinecraftProfileTextures textures = mss.getTextures(gameProfile);
                    if (textures != null) {
                        Journeymap.getLogger().debug("Retrieved skin for {} : {}", (Object)playerId, (Object)username);
                        MinecraftProfileTexture mpt = textures.skin();
                        IgnSkin.getImageFromUrl(new URL(mpt.getUrl()), image -> faceImageCache.put(playerId, IgnSkin.cropToFace(image)));
                    } else {
                        Journeymap.getLogger().debug("Unable to retrieve skin for {} : {}", (Object)playerId, (Object)username);
                        class_2960 resourceLocation = class_1068.method_4648((UUID)playerId).comp_1626();
                        class_1011 skinImage = TextureCache.getTexture(resourceLocation).getNativeImage();
                        faceImageCache.put(playerId, IgnSkin.cropToFace(skinImage));
                    }
                }
                catch (Throwable e) {
                    Journeymap.getLogger().warn("Error getting face image for " + username + ": " + e.getMessage());
                }
            });
        }
        return faceImageCache.get(playerId);
    }

    private static void getImageFromUrl(URL imageURL, Consumer<class_1011> imageConsumer) {
        CompletableFuture<class_1011> future = imageRequests.get(imageURL);
        if (future != null) {
            imageRequests.put(imageURL, (CompletableFuture<class_1011>)future.whenCompleteAsync((image, throwable) -> imageConsumer.accept((class_1011)image), (Executor)class_156.method_18349()));
        } else {
            imageRequests.put(imageURL, (CompletableFuture<class_1011>)CompletableFuture.supplyAsync(() -> IgnSkin.downloadImage(imageURL), class_156.method_18349()).whenCompleteAsync((image, throwable) -> imageConsumer.accept((class_1011)image), (Executor)class_156.method_18349()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static class_1011 downloadImage(URL imageURL) {
        class_1011 img = null;
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)imageURL.openConnection(class_310.method_1551().method_1487());
            HttpURLConnection.setFollowRedirects(true);
            conn.setInstanceFollowRedirects(true);
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.connect();
            if (conn.getResponseCode() / 100 == 2) {
                img = class_1011.method_4309((InputStream)conn.getInputStream());
            } else {
                Journeymap.getLogger().debug("Bad Response getting image: " + imageURL + " : " + conn.getResponseCode());
            }
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error getting skin image: " + imageURL + " : " + e.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        Journeymap.getLogger().debug("Getting Skin for URL: {}", (Object)imageURL);
        return img;
    }

    private static class_1011 cropToFace(class_1011 playerSkin) {
        if (playerSkin != null) {
            if (playerSkin.method_4318().method_4329()) {
                class_1011 hat = ImageUtil.getSubImage(40, 8, 8, 8, playerSkin, false);
                for (int x = 0; x < 8; ++x) {
                    for (int y = 0; y < 8; ++y) {
                        int hatPixel = hat.method_4315(x, y);
                        playerSkin.method_35624(x + 8, y + 8, hatPixel);
                    }
                }
                hat.close();
            }
            class_1011 sub = ImageUtil.getSubImage(8, 8, 8, 8, playerSkin, true);
            return ImageUtil.getSizedImage(24, 24, sub, true);
        }
        return new class_1011(24, 24, false);
    }
}

