/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.entity;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.ambientsounds.AmbientCondition;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.env.AmbientEnvironment;

public class AmbientEntityCondition {
    public AmbientCondition.AmbientMinMaxFadeCondition distance;
    @SerializedName(value="distance-x")
    public AmbientCondition.AmbientMinMaxFadeCondition distanceX;
    @SerializedName(value="distance-y")
    public AmbientCondition.AmbientMinMaxFadeCondition distanceY;
    @SerializedName(value="distance-z")
    public AmbientCondition.AmbientMinMaxFadeCondition distanceZ;
    public AmbientCondition.AmbientMinMaxFadeCondition count;
    @JsonAdapter(value=StringJson.class)
    public String[] name;
    @SerializedName(value="bad-name")
    @JsonAdapter(value=StringJson.class)
    public String[] badName;
    @JsonAdapter(value=StringJson.class)
    public String[] type;
    @SerializedName(value="bad-type")
    @JsonAdapter(value=StringJson.class)
    public String[] badType;
    private transient List<class_1299> parsedType;
    private transient List<class_1299> parsedBadType;
    public Map<String, String> scores;
    @JsonAdapter(value=StringJson.class)
    public String[] tag;
    @SerializedName(value="bad-tag")
    @JsonAdapter(value=StringJson.class)
    public String[] badTag;
    @JsonAdapter(value=StringJson.class)
    public String[] team;
    @SerializedName(value="bad-team")
    @JsonAdapter(value=StringJson.class)
    public String[] badTeam;
    @JsonAdapter(value=StringJson.class)
    public String[] nbt;
    @SerializedName(value="bad-nbt")
    @JsonAdapter(value=StringJson.class)
    public String[] badNbt;
    private transient List<class_2487> parsedNbt;
    private transient List<class_2487> parsedBadNbt;
    public AmbientCondition.AmbientMinMaxFadeCondition level;
    public AmbientCondition.AmbientMinMaxFadeCondition x_rotation;
    public AmbientCondition.AmbientMinMaxFadeCondition y_rotation;

    public void init(AmbientEngine engine) {
        Optional result;
        class_2960 location;
        if (this.type != null) {
            this.parsedType = new ArrayList<class_1299>();
            for (String entityType : this.type) {
                location = new class_2960(entityType);
                result = class_7923.field_41177.method_17966(location);
                if (!result.isPresent()) continue;
                this.parsedType.add((class_1299)result.get());
            }
        }
        if (this.badType != null) {
            this.parsedBadType = new ArrayList<class_1299>();
            for (String entityType : this.badType) {
                location = new class_2960(entityType);
                result = class_7923.field_41177.method_17966(location);
                if (!result.isPresent()) continue;
                this.parsedBadType.add((class_1299)result.get());
            }
        }
        if (this.nbt != null) {
            this.parsedNbt = new ArrayList<class_2487>();
            for (String tag : this.nbt) {
                try {
                    this.parsedNbt.add(class_2522.method_10718((String)tag));
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.badNbt != null) {
            this.parsedBadNbt = new ArrayList<class_2487>();
            for (String tag : this.badNbt) {
                try {
                    this.parsedBadNbt.add(class_2522.method_10718((String)tag));
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public double value(AmbientEnvironment env) {
        double highest = 0.0;
        int counted = 0;
        for (class_1297 entity : env.entity.all()) {
            if (this.name != null && !this.checkEntityName(this.name, entity) || this.badName != null && this.checkEntityName(this.badName, entity) || this.parsedType != null && !this.parsedType.contains(entity.method_5864()) || this.parsedBadType != null && this.parsedBadType.contains(entity.method_5864()) || this.tag != null && !this.containsTag(this.tag, entity) || this.badTag != null && this.containsTag(this.badTag, entity) || this.team != null && !this.isTeam(this.team, entity) || this.badTeam != null && this.isTeam(this.badTeam, entity) || this.parsedNbt != null && !this.hasNbt(this.parsedNbt, entity) || this.parsedBadNbt != null && this.hasNbt(this.parsedBadNbt, entity)) continue;
            double current = 1.0;
            if (this.distance != null) {
                current *= this.distance.volume(Math.sqrt(env.entity.squaredDistance(entity)));
            }
            if (this.distanceX != null) {
                current *= this.distanceX.volume(entity.method_19538().field_1352 - env.entity.x());
            }
            if (this.distanceY != null) {
                current *= this.distanceY.volume(entity.method_19538().field_1351 - env.entity.y());
            }
            if (this.distanceZ != null) {
                current *= this.distanceZ.volume(entity.method_19538().field_1350 - env.entity.z());
            }
            if (this.x_rotation != null) {
                current *= this.x_rotation.volume(entity.method_36455());
            }
            if (this.y_rotation != null) {
                current *= this.y_rotation.volume(entity.method_36454());
            }
            ++counted;
            if (current == 1.0 && this.count == null) {
                return 1.0;
            }
            highest = Math.max(current, highest);
        }
        if (this.count != null) {
            highest *= this.count.volume(counted);
        }
        return highest;
    }

    private boolean hasNbt(List<class_2487> nbt, class_1297 entity) {
        class_2487 tag = entity.method_5647(new class_2487());
        for (class_2487 check : nbt) {
            if (!class_2512.method_10687((class_2520)check, (class_2520)tag, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    private boolean isTeam(String[] team, class_1297 entity) {
        if (!(entity instanceof class_1309)) {
            return false;
        }
        return ArrayUtils.contains((Object[])team, (Object)(entity.method_5781() == null ? "" : entity.method_5781().method_1197()));
    }

    private boolean containsTag(String[] tag, class_1297 entity) {
        Set tags = entity.method_5752();
        for (int i = 0; i < tag.length; ++i) {
            if (!tags.contains(tag[i])) continue;
            return true;
        }
        return false;
    }

    private boolean checkEntityName(String[] name, class_1297 entity) {
        class_1657 p;
        if (entity instanceof class_1657 && ArrayUtils.contains((Object[])name, (Object)(p = (class_1657)entity).method_7334().getName())) {
            return true;
        }
        if (ArrayUtils.contains((Object[])name, (Object)entity.method_5845())) {
            return true;
        }
        return entity.method_16914() && ArrayUtils.contains((Object[])name, (Object)entity.method_5797().getString());
    }

    public static class StringJson
    extends TypeAdapter<String[]> {
        public void write(JsonWriter out, String[] value) throws IOException {
            if (value.length > 1) {
                out.beginArray();
                for (String string : value) {
                    out.value(string);
                }
                out.endArray();
            } else {
                out.value(value.length == 0 ? "" : value[0]);
            }
        }

        public String[] read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            if (token == JsonToken.STRING) {
                String value = in.nextString();
                if (value.isEmpty()) {
                    return new String[0];
                }
                return new String[]{value};
            }
            ArrayList<String> list = new ArrayList<String>();
            in.beginArray();
            while (in.hasNext()) {
                list.add(in.nextString());
            }
            in.endArray();
            return list.toArray(new String[list.size()]);
        }
    }
}

