/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1493;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5601;
import net.minecraft.class_624;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.EMFVersionDifferenceManager;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.EMFModelPart;
import traben.entity_model_features.models.EMFModelPartRoot;
import traben.entity_model_features.models.EMFModelPartVanilla;
import traben.entity_model_features.models.IEMFModelNameContainer;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationHelper;
import traben.entity_model_features.models.animation.EMFModelOrRenderVariable;
import traben.entity_model_features.models.jem_objects.EMFJemData;
import traben.entity_model_features.utils.EMFOptiFinePartNameMappings;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.OptifineMobNameForFileAndEMFMapId;

public class EMFManager {
    public static class_624<class_1493> wolfCollarModel = null;
    public static EMFModelPartRoot lastCreatedRootModelPart = null;
    private static EMFManager self = null;
    public UUID entityForDebugPrint = null;
    public final boolean IS_PHYSICS_MOD_INSTALLED;
    public final boolean IS_IRIS_INSTALLED;
    private final Object2ObjectOpenHashMap<String, EMFJemData> cache_JemDataByFileName = new Object2ObjectOpenHashMap();
    public final Object2ObjectLinkedOpenHashMap<String, Set<EMFModelPartRoot>> rootPartsPerEntityTypeForDebug = new Object2ObjectLinkedOpenHashMap<String, Set<EMFModelPartRoot>>(){
        {
            this.defaultReturnValue(null);
        }
    };
    public final ObjectSet<OptifineMobNameForFileAndEMFMapId> modelsAnnounced = new ObjectOpenHashSet();
    public long entityRenderCount = 0L;
    public boolean isAnimationValidationPhase = false;
    public String currentSpecifiedModelLoading = "";
    public Object2ObjectLinkedOpenHashMap<String, Set<Runnable>> rootPartsPerEntityTypeForVariation = new Object2ObjectLinkedOpenHashMap<String, Set<Runnable>>(){
        {
            this.defaultReturnValue(null);
        }
    };
    private boolean traderLlamaHappened = false;
    private final Object2IntOpenHashMap<class_5601> amountOfLayerAttempts = new Object2IntOpenHashMap<class_5601>(){
        {
            this.defaultReturnValue(0);
        }
    };

    private EMFManager() {
        EMFAnimationHelper.reset();
        this.IS_PHYSICS_MOD_INSTALLED = EMFVersionDifferenceManager.isThisModLoaded("physicsmod");
        this.IS_IRIS_INSTALLED = EMFVersionDifferenceManager.isThisModLoaded("iris") || EMFVersionDifferenceManager.isThisModLoaded("oculus");
    }

    public static EMFManager getInstance() {
        if (self == null) {
            self = new EMFManager();
        }
        return self;
    }

    public static void resetInstance() {
        EMFUtils.log("Clearing EMF data.");
        EMFOptiFinePartNameMappings.UNKNOWN_MODEL_MAP_CACHE.clear();
        self = new EMFManager();
    }

    @Nullable
    public static EMFJemData getJemData(String jemFileName, OptifineMobNameForFileAndEMFMapId mobModelIDInfo) {
        EMFJemData emfJemData = EMFManager.getJemDataWithDirectory("emf/cem/" + jemFileName, mobModelIDInfo);
        if (emfJemData != null) {
            return emfJemData;
        }
        emfJemData = EMFManager.getJemDataWithDirectory("emf/cem/" + mobModelIDInfo + "/" + jemFileName, mobModelIDInfo);
        if (emfJemData != null) {
            return emfJemData;
        }
        emfJemData = EMFManager.getJemDataWithDirectory("optifine/cem/" + jemFileName, mobModelIDInfo);
        if (emfJemData != null) {
            return emfJemData;
        }
        emfJemData = EMFManager.getJemDataWithDirectory("optifine/cem/" + mobModelIDInfo + "/" + jemFileName, mobModelIDInfo);
        return emfJemData;
    }

    @Nullable
    public static CemDirectoryApplier getResourceCemDirectoryApplierOrNull(String inCemPathResource, String rawMobName) {
        class_3300 resources = class_310.method_1551().method_1478();
        if (resources.method_14486(new class_2960("emf/cem/" + inCemPathResource)).isPresent()) {
            return CemDirectoryApplier.getEMF();
        }
        if (resources.method_14486(new class_2960("emf/cem/" + rawMobName + "/" + inCemPathResource)).isPresent()) {
            return CemDirectoryApplier.getEMF_Mob(rawMobName);
        }
        if (resources.method_14486(new class_2960("optifine/cem/" + inCemPathResource)).isPresent()) {
            return CemDirectoryApplier.getCEM();
        }
        if (resources.method_14486(new class_2960("optifine/cem/" + rawMobName + "/" + inCemPathResource)).isPresent()) {
            return CemDirectoryApplier.getCem_Mob(rawMobName);
        }
        return null;
    }

    @Nullable
    public static EMFJemData getJemDataWithDirectory(String pathOfJem, OptifineMobNameForFileAndEMFMapId mobModelIDInfo) {
        if (EMFManager.getInstance().cache_JemDataByFileName.containsKey((Object)pathOfJem)) {
            return (EMFJemData)EMFManager.getInstance().cache_JemDataByFileName.get((Object)pathOfJem);
        }
        try {
            Optional res = class_310.method_1551().method_1478().method_14486(new class_2960(pathOfJem));
            if (res.isEmpty()) {
                if (EMFConfig.getConfig().logModelCreationData) {
                    EMFUtils.log(".jem read failed " + pathOfJem + " does not exist", false);
                }
                return null;
            }
            if (EMFConfig.getConfig().logModelCreationData) {
                EMFUtils.log(".jem read success " + pathOfJem + " exists", false);
            }
            class_3298 jemResource = (class_3298)res.get();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            BufferedReader reader = new BufferedReader(new InputStreamReader(jemResource.method_14482()));
            EMFJemData jem = (EMFJemData)gson.fromJson((Reader)reader, EMFJemData.class);
            reader.close();
            jem.prepare(pathOfJem, mobModelIDInfo);
            if (mobModelIDInfo.areBothSame()) {
                EMFManager.getInstance().cache_JemDataByFileName.put((Object)pathOfJem, (Object)jem);
            }
            return jem;
        }
        catch (FileNotFoundException | class_151 e) {
            if (EMFConfig.getConfig().logModelCreationData) {
                EMFUtils.log(".jem failed to load " + (Exception)e, false);
            }
        }
        catch (Exception e) {
            EMFUtils.log(".jem failed to load " + e, false);
            e.printStackTrace();
        }
        return null;
    }

    public static EMFModelPart getModelFromHierarchichalId(String hierarchId, Map<String, EMFModelPart> map) {
        if (hierarchId == null || hierarchId.isBlank()) {
            return null;
        }
        if (!hierarchId.contains(":")) {
            EMFModelPart part = map.get(hierarchId);
            if (part == null) {
                return map.get("EMF_" + hierarchId);
            }
            return part;
        }
        for (Map.Entry<String, EMFModelPart> entry : map.entrySet()) {
            if (entry.getKey().equals(hierarchId) || entry.getKey().equals("EMF_" + hierarchId) || entry.getKey().endsWith(":" + hierarchId) || entry.getKey().endsWith(":EMF_" + hierarchId)) {
                return entry.getValue();
            }
            boolean anyMissing = false;
            String last = "";
            String[] stringArray = hierarchId.split(":");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String str;
                last = str = stringArray[i];
                if (entry.getKey().contains(str) || entry.getKey().contains("EMF_" + str)) continue;
                anyMissing = true;
                break;
            }
            if (anyMissing || !entry.getKey().endsWith(last)) continue;
            return entry.getValue();
        }
        System.out.println("NULL animation hierachy id result of: " + hierarchId + "\n in " + map);
        return null;
    }

    public class_630 injectIntoModelRootGetter(class_5601 layer, class_630 root) {
        int creationsOfLayer = this.amountOfLayerAttempts.put((Object)layer, this.amountOfLayerAttempts.getInt((Object)layer) + 1);
        if (creationsOfLayer > 500) {
            if (creationsOfLayer == 501) {
                EMFUtils.logWarn("model attempted creation more than 500 times {" + layer.toString() + "]. EMF is now ignoring this model.");
            }
            return root;
        }
        OptifineMobNameForFileAndEMFMapId mobNameForFileAndMap = new OptifineMobNameForFileAndEMFMapId(layer.method_35743().method_12832());
        try {
            EMFJemData jemData;
            lastCreatedRootModelPart = null;
            boolean printing = EMFConfig.getConfig().logModelCreationData;
            if (!"main".equals(layer.method_35744())) {
                mobNameForFileAndMap.setBoth(mobNameForFileAndMap.getfileName() + "_" + layer.method_35744());
            }
            if (!"minecraft".equals(layer.method_35743().method_12836())) {
                mobNameForFileAndMap.setBoth(("modded/" + layer.method_35743().method_12836() + "/" + mobNameForFileAndMap).toLowerCase().replaceAll("[^a-z0-9/._-]", "_"));
            } else {
                if (mobNameForFileAndMap.getfileName().contains("pufferfish")) {
                    mobNameForFileAndMap.setBoth(mobNameForFileAndMap.getfileName().replace("pufferfish", "puffer_fish"));
                }
                switch (mobNameForFileAndMap.getfileName()) {
                    case "tropical_fish_large": {
                        mobNameForFileAndMap.setBoth("tropical_fish_b");
                        break;
                    }
                    case "tropical_fish_small": {
                        mobNameForFileAndMap.setBoth("tropical_fish_a");
                        break;
                    }
                    case "tropical_fish_large_pattern": {
                        mobNameForFileAndMap.setBoth("tropical_fish_pattern_b");
                        break;
                    }
                    case "tropical_fish_small_pattern": {
                        mobNameForFileAndMap.setBoth("tropical_fish_pattern_a");
                        break;
                    }
                    case "leash_knot": {
                        mobNameForFileAndMap.setBoth("lead_knot");
                        break;
                    }
                    case "trader_llama": {
                        this.traderLlamaHappened = true;
                        break;
                    }
                    case "llama": {
                        this.traderLlamaHappened = false;
                        break;
                    }
                    case "llama_decor": {
                        mobNameForFileAndMap.setBoth(this.traderLlamaHappened ? "trader_llama_decor" : "llama_decor");
                        break;
                    }
                    case "ender_dragon": {
                        mobNameForFileAndMap.setBoth("dragon");
                        break;
                    }
                    case "dragon_skull": {
                        mobNameForFileAndMap.setBoth("head_dragon");
                        break;
                    }
                    case "player_head": {
                        mobNameForFileAndMap.setBoth("head_player");
                        break;
                    }
                    case "skeleton_skull": {
                        mobNameForFileAndMap.setBoth("head_skeleton");
                        break;
                    }
                    case "wither_skeleton_skull": {
                        mobNameForFileAndMap.setBoth("head_wither_skeleton");
                        break;
                    }
                    case "zombie_head": {
                        mobNameForFileAndMap.setBoth("head_zombie");
                        break;
                    }
                    case "creeper_head": {
                        mobNameForFileAndMap.setBoth("head_creeper");
                        break;
                    }
                    case "piglin_head": {
                        mobNameForFileAndMap.setBoth("head_piglin");
                        break;
                    }
                    case "creeper_armor": {
                        mobNameForFileAndMap.setBoth("creeper_charge");
                        break;
                    }
                    case "sheep_fur": {
                        mobNameForFileAndMap.setBoth("sheep_wool");
                        break;
                    }
                    case "bed_head": {
                        mobNameForFileAndMap.setBoth("bed", "bed_head");
                        break;
                    }
                    case "bed_foot": {
                        mobNameForFileAndMap.setBoth("bed", "bed_foot");
                        break;
                    }
                    case "conduit_cage": {
                        mobNameForFileAndMap.setBoth("conduit", "conduit_cage");
                        break;
                    }
                    case "conduit_eye": {
                        mobNameForFileAndMap.setBoth("conduit", "conduit_eye");
                        break;
                    }
                    case "conduit_shell": {
                        mobNameForFileAndMap.setBoth("conduit", "conduit_shell");
                        break;
                    }
                    case "conduit_wind": {
                        mobNameForFileAndMap.setBoth("conduit", "conduit_wind");
                        break;
                    }
                    case "decorated_pot_base": {
                        mobNameForFileAndMap.setBoth("decorated_pot", "decorated_pot_base");
                        break;
                    }
                    case "decorated_pot_sides": {
                        mobNameForFileAndMap.setBoth("decorated_pot", "decorated_pot_sides");
                        break;
                    }
                    case "book": {
                        if (this.currentSpecifiedModelLoading.equals("enchanting_book")) {
                            mobNameForFileAndMap.setBoth("enchanting_book", "book");
                            break;
                        }
                        mobNameForFileAndMap.setBoth("lectern_book", "book");
                        break;
                    }
                    case "chest": {
                        if (this.currentSpecifiedModelLoading.equals("ender_chest")) {
                            mobNameForFileAndMap.setBoth("ender_chest", "chest");
                            break;
                        }
                        if (this.currentSpecifiedModelLoading.equals("trapped_chest")) {
                            mobNameForFileAndMap.setBoth("trapped_chest", "chest");
                            break;
                        }
                        mobNameForFileAndMap.setBoth("chest", "chest");
                        break;
                    }
                    case "double_chest_left": {
                        if (this.currentSpecifiedModelLoading.equals("trapped_chest")) {
                            mobNameForFileAndMap.setBoth("trapped_chest_large", "double_chest_left");
                            break;
                        }
                        mobNameForFileAndMap.setBoth("chest_large", "double_chest_left");
                        break;
                    }
                    case "double_chest_right": {
                        if (this.currentSpecifiedModelLoading.equals("trapped_chest")) {
                            mobNameForFileAndMap.setBoth("trapped_chest_large", "double_chest_right");
                            break;
                        }
                        mobNameForFileAndMap.setBoth("chest_large", "double_chest_right");
                        break;
                    }
                    case "shulker": {
                        if (this.currentSpecifiedModelLoading.equals("shulker_box")) {
                            mobNameForFileAndMap.setBoth("shulker_box");
                            this.currentSpecifiedModelLoading = "";
                            break;
                        }
                        mobNameForFileAndMap.setBoth("shulker");
                        break;
                    }
                    default: {
                        if (!mobNameForFileAndMap.getfileName().contains("/") || !layer.method_35744().equals("main")) break;
                        if (mobNameForFileAndMap.getfileName().startsWith("hanging_sign/")) {
                            mobNameForFileAndMap.setBoth("hanging_sign");
                            break;
                        }
                        if (mobNameForFileAndMap.getfileName().startsWith("sign/")) {
                            mobNameForFileAndMap.setBoth("sign");
                            break;
                        }
                        if (mobNameForFileAndMap.getfileName().startsWith("chest_boat/")) {
                            if (mobNameForFileAndMap.getfileName().startsWith("chest_boat/bamboo")) {
                                mobNameForFileAndMap.setBoth("chest_raft");
                                break;
                            }
                            mobNameForFileAndMap.setBoth("chest_boat");
                            break;
                        }
                        if (!mobNameForFileAndMap.getfileName().startsWith("boat/")) break;
                        if (mobNameForFileAndMap.getfileName().startsWith("boat/bamboo")) {
                            mobNameForFileAndMap.setBoth("raft");
                            break;
                        }
                        mobNameForFileAndMap.setBoth("boat");
                    }
                }
            }
            if (!class_2960.method_20208((String)(mobNameForFileAndMap.getfileName() + ".jem"))) {
                String newValidPath = mobNameForFileAndMap.getfileName().replaceAll("[^a-z0-9/_.-]", "_");
                mobNameForFileAndMap.setBoth(newValidPath, mobNameForFileAndMap.getMapId());
            }
            if (printing) {
                System.out.println(" > EMF try to find a model for: " + mobNameForFileAndMap);
            }
            Map<String, String> optifinePartNameMap = EMFOptiFinePartNameMappings.getMapOf(mobNameForFileAndMap.getMapId(), root);
            if (printing) {
                System.out.println(" >> EMF trying to find: optifine/cem/" + mobNameForFileAndMap + ".jem");
            }
            String jemName = mobNameForFileAndMap + ".jem";
            CemDirectoryApplier hasVariantsAndCanApplyThisDirectory = EMFManager.getResourceCemDirectoryApplierOrNull(mobNameForFileAndMap + ".properties", mobNameForFileAndMap.getfileName());
            if (hasVariantsAndCanApplyThisDirectory == null) {
                hasVariantsAndCanApplyThisDirectory = EMFManager.getResourceCemDirectoryApplierOrNull(mobNameForFileAndMap + "2.jem", mobNameForFileAndMap.getfileName());
            }
            if ((jemData = EMFManager.getJemData(jemName, mobNameForFileAndMap)) != null || hasVariantsAndCanApplyThisDirectory != null) {
                HashSet<String> optifinePartNames = new HashSet<String>();
                optifinePartNameMap.forEach((optifine, vanilla) -> {
                    if (!optifine.equals("EMPTY")) {
                        optifinePartNames.add((String)vanilla);
                    }
                });
                EMFModelPartRoot emfRoot = new EMFModelPartRoot(mobNameForFileAndMap, hasVariantsAndCanApplyThisDirectory, root, optifinePartNames, new HashMap<String, EMFModelPartVanilla>());
                if (jemData != null) {
                    emfRoot.addVariantOfJem(jemData, 1);
                    emfRoot.setVariantStateTo(1);
                    this.setupAnimationsFromJemToModel(jemData, emfRoot, 1);
                    emfRoot.containsCustomModel = true;
                    if (hasVariantsAndCanApplyThisDirectory != null) {
                        emfRoot.discoverAndInitVariants();
                    }
                } else {
                    emfRoot.setVariant1ToVanilla0();
                    emfRoot.discoverAndInitVariants();
                }
                if (emfRoot.containsCustomModel) {
                    lastCreatedRootModelPart = emfRoot;
                    return emfRoot;
                }
            }
            if (printing) {
                System.out.println(" > Vanilla model used for: " + mobNameForFileAndMap);
            }
            ((IEMFModelNameContainer)root).emf$insertKnownMappings(mobNameForFileAndMap);
            return root;
        }
        catch (Exception e) {
            EMFUtils.logWarn("default model returned for " + layer.toString() + " due to exception: " + e.getMessage());
            ((IEMFModelNameContainer)root).emf$insertKnownMappings(mobNameForFileAndMap);
            return root;
        }
    }

    public void setupAnimationsFromJemToModel(EMFJemData jemData, EMFModelPartRoot emfRootPart, int variantNum) {
        boolean printing = EMFConfig.getConfig().logModelCreationData;
        Object2ObjectOpenHashMap allPartsBySingleAndFullHeirachicalId = new Object2ObjectOpenHashMap();
        allPartsBySingleAndFullHeirachicalId.put((Object)"EMF_root", (Object)emfRootPart);
        allPartsBySingleAndFullHeirachicalId.putAll(emfRootPart.getAllChildPartsAsAnimationMap("", variantNum, EMFOptiFinePartNameMappings.getMapOf(emfRootPart.modelName.getMapId(), null)));
        Object2ObjectLinkedOpenHashMap emfAnimationsByPartName = new Object2ObjectLinkedOpenHashMap();
        if (printing) {
            System.out.println(" > finalAnimationsForModel =");
            jemData.allTopLevelAnimationsByVanillaPartName.forEach((part, anims) -> anims.forEach((key, expression) -> System.out.println(" >> " + key + " = " + expression)));
        }
        jemData.allTopLevelAnimationsByVanillaPartName.forEach((part, anims) -> {
            Object2ObjectLinkedOpenHashMap thisPartAnims = new Object2ObjectLinkedOpenHashMap();
            anims.forEach((animKey, animationExpression) -> {
                if (EMFConfig.getConfig().logModelCreationData) {
                    EMFUtils.log("parsing animation value: [" + animKey + "]");
                }
                String modelId = animKey.split("\\.")[0];
                String modelVariable = animKey.split("\\.")[1];
                EMFModelOrRenderVariable thisVariable = EMFModelOrRenderVariable.get(modelVariable);
                if (thisVariable == null) {
                    thisVariable = EMFModelOrRenderVariable.getRenderVariable(animKey);
                }
                EMFModelPart thisPart = "render".equals(modelId) ? null : EMFManager.getModelFromHierarchichalId(modelId, (Map<String, EMFModelPart>)allPartsBySingleAndFullHeirachicalId);
                thisPartAnims.put(animKey, (Object)new EMFAnimation(thisPart, thisVariable, (String)animKey, (String)animationExpression, jemData.fileName));
            });
            emfAnimationsByPartName.put(part, (Object)thisPartAnims);
        });
        this.isAnimationValidationPhase = true;
        emfAnimationsByPartName.forEach((part, animMap) -> {
            ObjectBidirectionalIterator animMapIterate = animMap.entrySet().iterator();
            while (animMapIterate.hasNext()) {
                Map.Entry anim = (Map.Entry)animMapIterate.next();
                if (anim.getValue() != null) {
                    ((EMFAnimation)anim.getValue()).initExpression((Object2ObjectLinkedOpenHashMap<String, EMFAnimation>)animMap, (Object2ObjectOpenHashMap<String, EMFModelPart>)allPartsBySingleAndFullHeirachicalId);
                    if (((EMFAnimation)anim.getValue()).isValid()) continue;
                    EMFUtils.logWarn("animations was invalid: " + ((EMFAnimation)anim.getValue()).animKey + " = " + ((EMFAnimation)anim.getValue()).expressionString);
                    animMapIterate.remove();
                    continue;
                }
                animMapIterate.remove();
            }
        });
        this.isAnimationValidationPhase = false;
        emfRootPart.receiveAnimations(variantNum, (Object2ObjectLinkedOpenHashMap<String, Object2ObjectLinkedOpenHashMap<String, EMFAnimation>>)emfAnimationsByPartName);
    }

    public static interface CemDirectoryApplier {
        public static CemDirectoryApplier getEMF() {
            return fileName -> "emf/cem/" + fileName;
        }

        public static CemDirectoryApplier getEMF_Mob(String mobname) {
            return fileName -> "emf/cem/" + mobname + "/" + fileName;
        }

        public static CemDirectoryApplier getCEM() {
            return fileName -> "optifine/cem/" + fileName;
        }

        public static CemDirectoryApplier getCem_Mob(String mobName) {
            return fileName -> "optifine/cem/" + mobName + "/" + fileName;
        }

        public String getThisDirectoryOfFilename(String var1);
    }

    private record UUIDAndMobTypeKey(UUID uuid, String entityType) {
    }
}

