/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import snownee.jade.Jade;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.ui.Direction2D;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.ElementHelper;
import snownee.jade.overlay.DisplayHelper;

public class Tooltip
implements ITooltip {
    public final List<Line> lines = new ArrayList<Line>();
    public boolean sneakyDetails;

    public static void drawDebugBorder(class_332 guiGraphics, float x, float y, IElement element) {
        if (Jade.CONFIG.get().getGeneral().isDebug() && class_437.method_25441()) {
            class_241 translate = element.getTranslation();
            class_241 size = element.getCachedSize();
            DisplayHelper.INSTANCE.drawBorder(guiGraphics, x, y, x + size.field_1343, y + size.field_1342, 1.0f, -1996554240, true);
            if (!class_241.field_1340.method_1016(translate)) {
                DisplayHelper.INSTANCE.drawBorder(guiGraphics, x + translate.field_1343, y + translate.field_1342, x + translate.field_1343 + size.field_1343, y + translate.field_1342 + size.field_1342, 1.0f, -2013265665, true);
            }
        }
    }

    @Override
    public void clear() {
        this.lines.clear();
    }

    @Override
    public void append(int index, IElement element) {
        if (element.getTag() == null) {
            element.tag(ElementHelper.INSTANCE.currentUid());
        }
        if (this.isEmpty() || index == this.size()) {
            this.add(element);
        } else {
            this.lines.get((int)index).elements.add(element);
        }
    }

    @Override
    @Deprecated
    public IElementHelper getElementHelper() {
        return IElementHelper.get();
    }

    @Override
    public int size() {
        return this.lines.size();
    }

    @Override
    public void add(int index, IElement element) {
        if (element.getTag() == null) {
            element.tag(ElementHelper.INSTANCE.currentUid());
        }
        Line line = new Line();
        line.elements.add(element);
        this.lines.add(index, line);
    }

    @Override
    public List<IElement> get(class_2960 tag) {
        ArrayList elements = Lists.newArrayList();
        for (Line line : this.lines) {
            line.sortedElements().stream().filter(e -> com.google.common.base.Objects.equal((Object)tag, (Object)e.getTag())).forEach(elements::add);
        }
        return elements;
    }

    @Override
    public List<IElement> get(int index, IElement.Align align) {
        Line line = this.lines.get(index);
        return line.alignedElements(align);
    }

    @Override
    public void remove(class_2960 tag) {
        Iterator<Line> iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            Line line = iterator.next();
            if (!line.elements.removeIf(e -> com.google.common.base.Objects.equal((Object)tag, (Object)e.getTag()))) continue;
            line.markDirty();
            if (!line.elements.isEmpty()) continue;
            iterator.remove();
        }
    }

    @Override
    public String getMessage() {
        ArrayList msgs = Lists.newArrayList();
        for (Line line : this.lines) {
            msgs.add(Joiner.on((char)' ').join(line.sortedElements().stream().filter(e -> !Identifiers.CORE_MOD_NAME.equals((Object)e.getTag())).map(IElement::getCachedMessage).filter(Objects::nonNull).toList()));
        }
        return Joiner.on((char)'\n').join((Iterable)msgs);
    }

    @Override
    public void setLineMargin(int index, Direction2D side, int margin) {
        if (index < 0) {
            index += this.lines.size();
        }
        Line line = this.lines.get(index);
        switch (side) {
            case UP: {
                line.marginTop = margin;
                break;
            }
            case DOWN: {
                line.marginBottom = margin;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only TOP and BOTTOM are allowed.");
            }
        }
    }

    public static class Line {
        private final List<IElement> elements = Lists.newArrayList();
        private final int[] starts = new int[2];
        private final float[] widths = new float[3];
        public int marginTop = 0;
        public int marginBottom = 2;
        private class_241 size;
        private boolean sorted;

        public void sort() {
            if (this.sorted) {
                return;
            }
            this.sorted = true;
            Arrays.fill(this.starts, 0);
            Arrays.fill(this.widths, 0.0f);
            ArrayList tempList = Lists.newArrayListWithExpectedSize((int)this.elements.size());
            float width = 0.0f;
            float height = 0.0f;
            for (IElement element : this.elements) {
                int index = element.getAlignment().ordinal();
                int start = index == 2 ? tempList.size() : this.starts[index];
                tempList.add(start, element);
                int i = index;
                while (i < this.starts.length) {
                    int n = i++;
                    this.starts[n] = this.starts[n] + 1;
                }
                class_241 elementSize = element.getCachedSize();
                int n = index;
                this.widths[n] = this.widths[n] + elementSize.field_1343;
                width += elementSize.field_1343;
                height = Math.max(height, elementSize.field_1342);
            }
            this.elements.clear();
            this.elements.addAll(tempList);
            this.size = new class_241(width, height);
        }

        public void markDirty() {
            this.sorted = false;
            this.size = null;
        }

        public List<IElement> sortedElements() {
            this.sort();
            return this.elements;
        }

        public List<IElement> alignedElements(IElement.Align align) {
            this.sort();
            int index = align.ordinal();
            int start = index == 0 ? 0 : this.starts[index - 1];
            int end = index == 2 ? this.elements.size() : this.starts[index];
            return this.elements.subList(start, end);
        }

        public class_241 size() {
            this.sort();
            return this.size;
        }

        public void render(class_332 guiGraphics, float x, float y, float maxX, float maxY) {
            this.sort();
            for (IElement.Align align : IElement.Align.VALUES) {
                this.renderAligned(guiGraphics, x, y, maxX, maxY, align);
            }
        }

        private void renderAligned(class_332 guiGraphics, float x, float y, float maxX, float maxY, IElement.Align align) {
            List<IElement> alignedElements = this.alignedElements(align);
            float ox = switch (align) {
                default -> throw new IncompatibleClassChangeError();
                case IElement.Align.LEFT -> x;
                case IElement.Align.RIGHT -> maxX - this.widths[1];
                case IElement.Align.CENTER -> {
                    float left = x + this.widths[0];
                    float right = maxX - this.widths[1];
                    yield left + (right - left - this.widths[2]) / 2.0f;
                }
            };
            boolean extendable = align == IElement.Align.LEFT && alignedElements.size() == this.elements.size();
            IElement lastElement = alignedElements.isEmpty() ? null : alignedElements.get(alignedElements.size() - 1);
            for (IElement element : alignedElements) {
                class_241 translate = element.getTranslation();
                class_241 size = element.getCachedSize();
                Tooltip.drawDebugBorder(guiGraphics, ox, y, element);
                element.render(guiGraphics, ox + translate.field_1343, y + translate.field_1342, (extendable && element == lastElement ? maxX : ox + size.field_1343) + translate.field_1343, maxY + translate.field_1342);
                ox += size.field_1343;
            }
        }
    }
}

