/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.io.File;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.addon.core.CorePlugin;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.gui.config.OptionButton;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;

public class WailaConfigScreen
extends PreviewOptionsScreen {
    private OptionValue<Boolean> squareEntry;
    private OptionValue<Float> opacityEntry;

    public WailaConfigScreen(class_437 parent) {
        super(parent, (class_2561)class_2561.method_43471((String)"gui.jade.jade_settings"));
        this.saver = Jade.CONFIG::save;
        ImmutableMap.Builder keyMapBuilder = ImmutableMap.builder();
        for (class_304 keyMapping : class_310.method_1551().field_1690.field_1839) {
            if (!JadeClient.openConfig.method_1423().equals(keyMapping.method_1423())) continue;
            keyMapBuilder.put((Object)keyMapping, (Object)ClientProxy.getBoundKeyOf(keyMapping));
        }
        ImmutableMap keyMap = keyMapBuilder.build();
        this.canceller = () -> {
            Jade.CONFIG.invalidate();
            keyMap.forEach(class_304::method_1422);
            class_310.method_1551().field_1690.method_1640();
        };
    }

    public static OptionsList.Entry editBlocklist(OptionsList.Entry entry, String fileName, Runnable defaultCreator) {
        entry.getFirstWidget().method_25358(79);
        class_5250 tooltip = class_2561.method_43471((String)"config.jade.edit_blocklist");
        entry.addWidget((class_339)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2630"), b -> {
            File file = new File(CommonProxy.getConfigDirectory(), "jade/%s.json".formatted(fileName));
            if (!file.exists()) {
                defaultCreator.run();
            }
            class_156.method_668().method_672(file);
        }).method_46437(20, 20).method_46436(class_7919.method_47407((class_2561)tooltip)).method_46435($ -> tooltip).method_46431(), 80);
        return entry;
    }

    @Override
    public OptionsList createOptions() {
        Objects.requireNonNull(this.field_22787);
        OptionsList options = new OptionsList(this, this.field_22787, this.field_22789 - 120, this.field_22790, 0, this.field_22790 - 32, 26, Jade.CONFIG::save);
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        options.title("general");
        if (CommonProxy.isDevEnv()) {
            options.choices("debug_mode", general.isDebug(), general::setDebug);
        }
        options.choices("display_tooltip", general.shouldDisplayTooltip(), general::setDisplayTooltip);
        OptionValue<Boolean> entry = options.choices("display_entities", general.getDisplayEntities(), general::setDisplayEntities);
        WailaConfigScreen.editBlocklist(entry, "hide-entities", () -> CorePlugin.createBlockBlocklist().get());
        options.choices("display_bosses", general.getDisplayBosses(), general::setDisplayBosses).parent(entry);
        entry = options.choices("display_blocks", general.getDisplayBlocks(), general::setDisplayBlocks);
        WailaConfigScreen.editBlocklist(entry, "hide-blocks", () -> CorePlugin.createBlockBlocklist().get());
        options.choices("display_fluids", general.getDisplayFluids(), general::setDisplayFluids).parent(entry);
        options.choices("display_mode", general.getDisplayMode(), general::setDisplayMode, builder -> builder.method_32618(mode -> {
            String key = "display_mode_" + mode.name().toLowerCase(Locale.ENGLISH) + "_desc";
            if (mode == IWailaConfig.DisplayMode.LITE && "fabric".equals(CommonProxy.getPlatformIdentifier())) {
                key = key + ".fabric";
            }
            return class_7919.method_47407((class_2561)OptionsList.Entry.makeTitle(key));
        }));
        OptionValue<Boolean> value = options.choices("item_mod_name", general.showItemModNameTooltip(), general::setItemModNameTooltip);
        if (!WailaConfig.ConfigGeneral.itemModNameTooltipDisabledByMods.isEmpty()) {
            value.setDisabled(true);
            value.appendDescription(class_1074.method_4662((String)"gui.jade.disabled_by_mods", (Object[])new Object[0]));
            WailaConfig.ConfigGeneral.itemModNameTooltipDisabledByMods.forEach(value::appendDescription);
            if (value.getFirstWidget() != null && value.getDescription() != null) {
                value.getFirstWidget().method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)value.getDescription())));
            }
        }
        options.choices("hide_from_debug", general.shouldHideFromDebug(), general::setHideFromDebug);
        options.choices("hide_from_tab_list", general.shouldHideFromTabList(), general::setHideFromTabList);
        options.choices("boss_bar_overlap", general.getBossBarOverlapMode(), general::setBossBarOverlapMode);
        options.slider("reach_distance", general.getReachDistance(), general::setReachDistance, 0.0f, 20.0f, f -> (float)class_3532.method_15375((float)(f * 2.0f)) / 2.0f);
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        options.title("overlay");
        options.choices("overlay_theme", overlay.getTheme().id, IThemeHelper.get().getThemes().stream().filter($ -> !$.hidden).map($ -> $.id).toList(), id -> {
            if (Objects.equals(id, overlay.getTheme().id)) {
                return;
            }
            overlay.applyTheme((class_2960)id);
            Theme theme = overlay.getTheme();
            if (theme.changeRoundCorner != null) {
                this.squareEntry.setValue(theme.changeRoundCorner);
            }
            if (theme.changeOpacity != 0.0f) {
                this.opacityEntry.setValue(Float.valueOf(theme.changeOpacity));
            }
        }, id -> class_2561.method_43471((String)class_156.method_646((String)"jade.theme", (class_2960)id)));
        this.squareEntry = options.choices("overlay_square", overlay.getSquare(), overlay::setSquare);
        this.opacityEntry = options.slider("overlay_alpha", overlay.getAlpha(), overlay::setAlpha);
        options.forcePreview.add(options.slider("overlay_scale", overlay.getOverlayScale(), overlay::setOverlayScale, 0.2f, 2.0f, FloatUnaryOperator.identity()));
        class_5250 adjust = class_2561.method_43471((String)OptionsList.Entry.makeKey("overlay_pos.adjust"));
        options.add(new OptionButton((class_2561)class_2561.method_43471((String)OptionsList.Entry.makeKey("overlay_pos")), class_4185.method_46430((class_2561)adjust, w -> {
            this.adjustingPosition = true;
        }).method_46437(100, 20).method_46431()));
        options.choices("display_item", overlay.getIconMode(), overlay::setIconMode);
        options.choices("animation", overlay.getAnimation(), overlay::setAnimation);
        options.title("key_binds");
        options.keybind(JadeClient.openConfig);
        options.keybind(JadeClient.showOverlay);
        options.keybind(JadeClient.toggleLiquid);
        if (ClientProxy.shouldRegisterRecipeViewerKeys()) {
            options.keybind(JadeClient.showRecipes);
            options.keybind(JadeClient.showUses);
        }
        options.keybind(JadeClient.narrate);
        options.keybind(JadeClient.showDetails);
        options.title("accessibility");
        options.choices("flip_main_hand", overlay.getFlipMainHand(), overlay::setFlipMainHand);
        options.choices("tts_mode", general.getTTSMode(), general::setTTSMode);
        options.title("danger_zone").method_27692(class_124.field_1061);
        class_5250 reset = class_2561.method_43471((String)"controls.reset").method_27692(class_124.field_1061);
        class_5250 title = class_2561.method_43471((String)OptionsList.Entry.makeKey("reset_settings")).method_27692(class_124.field_1061);
        options.add(new OptionButton((class_2561)title, class_4185.method_46430((class_2561)reset, arg_0 -> this.lambda$createOptions$14((class_2561)title, (class_2561)reset, arg_0)).method_46437(100, 20).method_46431()));
        return options;
    }

    private /* synthetic */ void lambda$createOptions$14(class_2561 title, class_2561 reset, class_4185 w) {
        this.field_22787.method_1507((class_437)new class_410(bl -> {
            if (bl) {
                for (class_304 keyMapping : this.field_22787.field_1690.field_1839) {
                    if (!JadeClient.openConfig.method_1423().equals(keyMapping.method_1423())) continue;
                    keyMapping.method_1422(keyMapping.method_1429());
                }
                this.field_22787.field_1690.method_1640();
                try {
                    int themesHash = Jade.CONFIG.get().getOverlay().themesHash;
                    Preconditions.checkState((boolean)Jade.CONFIG.getFile().delete());
                    Preconditions.checkState((boolean)PluginConfig.INSTANCE.getFile().delete());
                    Jade.CONFIG.invalidate();
                    Jade.CONFIG.get().getOverlay().themesHash = themesHash;
                    Jade.CONFIG.save();
                    PluginConfig.INSTANCE.reload();
                    this.method_41843();
                }
                catch (Throwable e) {
                    Jade.LOGGER.catching(e);
                }
            }
            this.field_22787.method_1507((class_437)this);
            this.options.method_25307(this.options.method_25331());
        }, title, (class_2561)class_2561.method_43471((String)OptionsList.Entry.makeKey("reset_settings.confirm")), reset, (class_2561)class_2561.method_43471((String)"gui.cancel")));
    }
}

