/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import snownee.jade.gui.config.BelowOrAboveListEntryTooltipPositioner;
import snownee.jade.gui.config.NotUglyEditBox;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.gui.config.OptionsNav;
import snownee.jade.gui.config.value.OptionValue;

public abstract class BaseOptionsScreen
extends class_437 {
    private final class_437 parent;
    private final Set<class_364> entryWidgets = Sets.newIdentityHashSet();
    public class_4185 saveButton;
    protected Runnable saver;
    protected Runnable canceller;
    protected OptionsList options;
    protected OptionsNav optionsNav;
    private NotUglyEditBox searchBox;

    public BaseOptionsScreen(class_437 parent, class_2561 title) {
        super(title);
        this.parent = parent;
    }

    protected void method_25426() {
        Objects.requireNonNull(this.field_22787);
        double scroll = this.options == null ? 0.0 : this.options.method_25341();
        super.method_25426();
        this.entryWidgets.clear();
        if (this.options != null) {
            this.options.removed();
        }
        this.options = this.createOptions();
        this.options.method_25333(120);
        this.optionsNav = new OptionsNav(this.options, 120, this.field_22790, 18, this.field_22790 - 32, 18);
        this.searchBox = new NotUglyEditBox(this.field_22793, 0, 0, 120, 18, this.searchBox, (class_2561)class_2561.method_43471((String)"gui.jade.search"));
        this.searchBox.setBordered(false);
        this.searchBox.setHint((class_2561)class_2561.method_43471((String)"gui.jade.search.hint"));
        this.searchBox.responder = s -> {
            this.options.updateSearch((String)s);
            this.optionsNav.refresh();
        };
        this.searchBox.paddingLeft = 12;
        this.searchBox.paddingTop = 6;
        this.searchBox.paddingRight = 18;
        this.method_37063((class_364)this.optionsNav);
        this.method_37063((class_364)this.searchBox);
        this.method_37063((class_364)this.options);
        this.searchBox.responder.accept(this.searchBox.getValue());
        this.options.method_25307(scroll);
        this.saveButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.jade.save_and_quit").method_27694(style -> style.method_36139(-4589878)), w -> {
            this.options.save();
            this.saver.run();
            this.field_22787.method_1507(this.parent);
        }).method_46434(this.field_22789 - 100, this.field_22790 - 25, 90, 20).method_46431());
        if (this.canceller != null) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, w -> this.method_25419()).method_46434(this.saveButton.method_46426() - 95, this.field_22790 - 25, 90, 20).method_46431());
        }
        this.options.updateSaveState();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        OptionsList.Entry entry;
        this.method_25420(guiGraphics, mouseX, mouseY, partialTicks);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        OptionsList.Entry entry2 = entry = this.options.method_25405(mouseX, mouseY) ? this.options.getEntryAt(mouseX, mouseY) : null;
        if (entry != null) {
            int valueX;
            if (!Strings.isNullOrEmpty((String)entry.getDescription()) && mouseX >= (valueX = entry.getTextX(this.options.method_25322())) && mouseX < valueX + entry.getTextWidth()) {
                this.method_47412(class_7919.method_47407((class_2561)class_2561.method_43470((String)entry.getDescription())), new BelowOrAboveListEntryTooltipPositioner(this.options, entry), false);
            }
            if (entry instanceof OptionValue) {
                OptionValue optionValue = (OptionValue)entry;
                if (optionValue.serverFeature) {
                    int x = entry.getTextX(this.options.method_25322()) + entry.getTextWidth() + 1;
                    int y = this.options.method_25337(this.options.method_25396().indexOf((Object)entry)) + 7;
                    if (mouseX >= x && mouseX < x + 4 && mouseY >= y && mouseY < y + 4) {
                        this.method_47412(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.jade.server_feature")), new BelowOrAboveListEntryTooltipPositioner(this.options, entry), false);
                    }
                }
            }
        }
    }

    public abstract OptionsList createOptions();

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.optionsNav.method_25405(mouseX, mouseY)) {
            return this.optionsNav.method_25401(mouseX, mouseY, deltaX, deltaY);
        }
        return this.options.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    public void method_25419() {
        if (this.canceller != null) {
            this.canceller.run();
        }
        Objects.requireNonNull(this.field_22787).method_1507(this.parent);
    }

    public void method_25432() {
        this.options.removed();
    }

    public <T extends class_364 & class_6379> T addEntryWidget(T widget) {
        this.entryWidgets.add(widget);
        return (T)super.method_25429(widget);
    }

    public boolean method_25402(double mouseX, double mouseY, int p_94697_) {
        boolean onList = this.options.method_25405(mouseX, mouseY);
        for (class_364 guieventlistener : this.method_25396()) {
            if (!onList && this.entryWidgets.contains(guieventlistener) || !guieventlistener.method_25402(mouseX, mouseY, p_94697_)) continue;
            this.method_25395(guieventlistener);
            if (p_94697_ == 0) {
                this.method_25398(true);
            }
            return true;
        }
        return false;
    }

    public boolean method_25422() {
        return this.options.selectedKey == null;
    }

    public Optional<class_364> method_19355(double mouseX, double mouseY) {
        boolean onList = this.options != null && this.options.method_25405(mouseX, mouseY);
        for (class_364 guieventlistener : this.method_25396()) {
            if (!onList && this.entryWidgets.contains(guieventlistener) || !guieventlistener.method_25405(mouseX, mouseY)) continue;
            return Optional.of(guieventlistener);
        }
        return Optional.empty();
    }
}

