/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.menuhandler.custom;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.compatibility.MinecraftCompatibilityUtils;
import de.keksuccino.fancymenu.events.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.PlayWidgetClickSoundEvent;
import de.keksuccino.fancymenu.events.RenderListBackgroundEvent;
import de.keksuccino.fancymenu.events.RenderScreenEvent;
import de.keksuccino.fancymenu.events.RenderWidgetBackgroundEvent;
import de.keksuccino.fancymenu.events.ScreenBackgroundRenderedEvent;
import de.keksuccino.fancymenu.events.SoftMenuReloadEvent;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerBase;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationElement;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationLayer;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationLayerRegistry;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.layers.titlescreen.splash.TitleScreenSplashElement;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.layers.titlescreen.splash.TitleScreenSplashItem;
import de.keksuccino.fancymenu.mixin.client.IMixinScreen;
import de.keksuccino.konkrete.events.EventPriority;
import de.keksuccino.konkrete.events.SubscribeEvent;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1074;
import net.minecraft.class_155;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_751;
import net.minecraft.class_766;
import net.minecraft.class_8020;
import org.jetbrains.annotations.NotNull;

public class MainMenuHandler
extends MenuHandlerBase {
    private static final class_751 PANORAMA_CUBE_MAP = new class_751(new class_2960("textures/gui/title/background/panorama"));
    private static final class_2960 PANORAMA_OVERLAY = new class_2960("textures/gui/title/background/panorama_overlay.png");
    private static final class_8020 LOGO_RENDERER = new class_8020(false);
    private static final Random RANDOM = new Random();
    private class_766 panorama = new class_766(PANORAMA_CUBE_MAP);
    protected boolean showLogo = true;
    protected boolean showBranding = true;
    protected boolean showRealmsNotification = true;
    protected TitleScreenSplashItem splashItem = null;

    public MainMenuHandler() {
        super(class_442.class.getName());
    }

    @Override
    @SubscribeEvent
    public void onSoftReload(SoftMenuReloadEvent e) {
        super.onSoftReload(e);
    }

    @Override
    @SubscribeEvent
    public void onMenuReloaded(MenuReloadedEvent e) {
        super.onMenuReloaded(e);
        TitleScreenSplashItem.cachedSplashText = null;
    }

    @Override
    @SubscribeEvent
    public void onInitPre(InitOrResizeScreenEvent.Pre e) {
        if (this.shouldCustomize(e.getScreen()) && MenuCustomization.isMenuCustomizable(e.getScreen()) && e.getScreen() instanceof class_442) {
            MainMenuHandler.setShowFadeInAnimation(false, (class_442)e.getScreen());
        }
        super.onInitPre(e);
    }

    @Override
    @SubscribeEvent
    public void onButtonsCached(ButtonCachedEvent e) {
        if (this.shouldCustomize(e.getGui()) && MenuCustomization.isMenuCustomizable(e.getGui())) {
            TitleScreenSplashElement element;
            this.showLogo = true;
            this.showBranding = true;
            this.showRealmsNotification = true;
            DeepCustomizationLayer layer = DeepCustomizationLayerRegistry.getLayerByMenuIdentifier(this.getMenuIdentifier());
            if (layer != null && (element = (TitleScreenSplashElement)layer.getElementByIdentifier("title_screen_splash")) != null) {
                this.splashItem = (TitleScreenSplashItem)element.constructDefaultItemInstance();
            }
            super.onButtonsCached(e);
        }
    }

    @Override
    protected void applyLayout(PropertiesSection sec, String renderOrder, ButtonCachedEvent e) {
        DeepCustomizationItem i;
        String elementId;
        DeepCustomizationElement element;
        String action;
        super.applyLayout(sec, renderOrder, e);
        DeepCustomizationLayer layer = DeepCustomizationLayerRegistry.getLayerByMenuIdentifier(this.getMenuIdentifier());
        if (layer != null && (action = sec.getEntryValue("action")) != null && action.startsWith("deep_customization_element:") && (element = layer.getElementByIdentifier(elementId = action.split("[:]", 2)[1])) != null && (i = element.constructCustomizedItemInstance(sec)) != null) {
            if (elementId.equals("title_screen_branding") && this.showBranding) {
                boolean bl = this.showBranding = !i.hidden;
            }
            if (elementId.equals("title_screen_logo") && this.showLogo) {
                boolean bl = this.showLogo = !i.hidden;
            }
            if (elementId.equals("title_screen_splash") && (this.splashItem == null || !this.splashItem.hidden)) {
                this.splashItem = (TitleScreenSplashItem)i;
            }
            if (elementId.equals("title_screen_realms_notification") && this.showRealmsNotification) {
                this.showRealmsNotification = !i.hidden;
            }
        }
    }

    @Override
    @SubscribeEvent
    public void onRenderPost(RenderScreenEvent.Post e) {
        super.onRenderPost(e);
    }

    @SubscribeEvent
    public void onRender(RenderScreenEvent.Pre e) {
    }

    @NotNull
    private class_437 getCurrentScreen() {
        return (class_437)Objects.requireNonNullElse(class_310.method_1551().field_1755, new class_442());
    }

    @Override
    @SubscribeEvent
    public void drawToBackground(ScreenBackgroundRenderedEvent e) {
        if (this.shouldCustomize(e.getScreen())) {
            class_327 font = class_310.method_1551().field_1772;
            int width = e.getScreen().field_22789;
            int height = e.getScreen().field_22790;
            int j = width / 2 - 137;
            float minecraftLogoSpelling = RANDOM.nextFloat();
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            RenderSystem.enableBlend();
            if (!this.canRenderBackground()) {
                this.panorama.method_3317(class_310.method_1551().method_1534(), 1.0f);
                RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                e.getGuiGraphics().method_25293(PANORAMA_OVERLAY, 0, 0, e.getScreen().field_22789, e.getScreen().field_22790, 0.0f, 0.0f, 16, 128, 16, 128);
            }
            super.drawToBackground(e);
            RenderSystem.enableBlend();
            if (this.showLogo) {
                LOGO_RENDERER.method_48209(e.getGuiGraphics(), e.getScreen().field_22789, 1.0f);
            }
            RenderSystem.enableBlend();
            if (this.showBranding) {
                String string = "Minecraft " + class_155.method_16673().method_48019();
                string = class_310.method_1551().method_1530() ? string + " Demo" : string + (String)("release".equalsIgnoreCase(class_310.method_1551().method_1547()) ? "" : "/" + class_310.method_1551().method_1547());
                if (class_310.method_24289().method_39029()) {
                    string = string + class_1074.method_4662((String)"menu.modded", (Object[])new Object[0]);
                }
                e.getGuiGraphics().method_25303(font, string, 2, e.getScreen().field_22790 - 10, -1);
            }
            if (!PopupHandler.isPopupActive()) {
                this.renderButtons(e, mouseX, mouseY);
            }
            RenderSystem.enableBlend();
            if (this.showRealmsNotification) {
                this.drawRealmsNotification(e.getGuiGraphics(), e.getScreen());
            }
            RenderSystem.enableBlend();
            this.renderSplash(e.getGuiGraphics(), e.getScreen());
        }
    }

    @Override
    @SubscribeEvent
    public void onButtonClickSound(PlayWidgetClickSoundEvent.Pre e) {
        super.onButtonClickSound(e);
    }

    @Override
    @SubscribeEvent
    public void onButtonRenderBackground(RenderWidgetBackgroundEvent.Pre e) {
        super.onButtonRenderBackground(e);
    }

    @Override
    @SubscribeEvent
    public void onRenderListBackground(RenderListBackgroundEvent.Post e) {
        super.onRenderListBackground(e);
    }

    protected void renderSplash(class_332 graphics, class_437 s) {
        try {
            if (this.splashItem != null) {
                this.splashItem.render(graphics, s);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void renderButtons(ScreenBackgroundRenderedEvent e, int mouseX, int mouseY) {
        List<class_4068> buttons = this.getButtonList(e.getScreen());
        float partial = class_310.method_1551().method_1488();
        if (buttons != null) {
            for (int i = 0; i < buttons.size(); ++i) {
                RenderSystem.enableBlend();
                buttons.get(i).method_25394(e.getGuiGraphics(), mouseX, mouseY, partial);
            }
        }
    }

    private void drawRealmsNotification(class_332 graphics, class_437 gui) {
        try {
            class_437 realms;
            if (((Boolean)class_310.method_1551().field_1690.method_42440().method_41753()).booleanValue() && (realms = MinecraftCompatibilityUtils.getTitleScreenRealmsNotificationsScreen((class_442)gui)) != null) {
                class_312 mh = class_310.method_1551().field_1729;
                realms.method_25394(graphics, (int)mh.method_1603(), (int)mh.method_1604(), class_310.method_1551().method_1488());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<class_4068> getButtonList(class_437 gui) {
        return ((IMixinScreen)gui).getRenderablesFancyMenu();
    }

    protected static void setShowFadeInAnimation(boolean showFadeIn, class_442 s) {
        s.field_18222 = showFadeIn;
    }

    @Override
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderPre(RenderScreenEvent.Pre e) {
        super.onRenderPre(e);
    }
}

