/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.FMConfigScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedImageButton;
import de.keksuccino.konkrete.gui.content.ContextMenu;
import de.keksuccino.konkrete.gui.content.widget.WidgetUtils;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;

public class MenuBar
extends UIBase {
    public static final class_2960 FM_LOGO_TEXTURE = new class_2960("keksuccino", "fm_pixel_logo.png");
    public static final class_2960 SHRINK_BTN_TEXTURE = new class_2960("keksuccino", "shrink_btn.png");
    public static final class_2960 EXPAND_BTN_TEXTURE = new class_2960("keksuccino", "expand_btn.png");
    protected Map<String, AdvancedButton> leftElements = new LinkedHashMap<String, AdvancedButton>();
    protected Map<String, AdvancedButton> rightElements = new LinkedHashMap<String, AdvancedButton>();
    protected List<String> persistentElements = new ArrayList<String>();
    protected Map<String, ContextMenu> childs = new HashMap<String, ContextMenu>();
    protected int height = 20;
    protected Color barColor = new Color(247, 237, 255, 255);
    protected boolean expanded = true;
    protected boolean visible = true;
    public boolean opacityChange = true;
    public float barOpacity = 0.8f;
    public int elementSpace = -1;

    public MenuBar() {
        AdvancedImageButton fmBtn = new AdvancedImageButton(0, 0, 0, 0, FM_LOGO_TEXTURE, true, press -> class_310.method_1551().method_1507((class_437)new FMConfigScreen(class_310.method_1551().field_1755))){

            public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
                this.field_22758 = this.field_22759;
                super.method_25394(graphics, mouseX, mouseY, partialTicks);
            }
        };
        fmBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.menubar.settings", (String[])new String[0]), (String)"%n%"));
        this.addElement((AdvancedButton)fmBtn, "menubar.default.fancymenubtn", ElementAlignment.LEFT, true);
        AdvancedImageButton expandBtn = new AdvancedImageButton(0, 0, 20, 20, SHRINK_BTN_TEXTURE, true, press -> {
            this.toggleExpanded();
            if (this.expanded) {
                ((AdvancedImageButton)press).setImage(SHRINK_BTN_TEXTURE);
                ((AdvancedButton)press).setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.menubar.shrink", (String[])new String[0]), (String)"%n%"));
            } else {
                ((AdvancedImageButton)press).setImage(EXPAND_BTN_TEXTURE);
                ((AdvancedButton)press).setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.menubar.expand", (String[])new String[0]), (String)"%n%"));
            }
        }){

            public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
                this.field_22758 = this.field_22759;
                super.method_25394(graphics, mouseX, mouseY, partialTicks);
            }
        };
        expandBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.menubar.shrink", (String[])new String[0]), (String)"%n%"));
        this.addElement((AdvancedButton)expandBtn, "menubar.default.extendbtn", ElementAlignment.RIGHT, true);
    }

    public void addElement(AdvancedButton element, String key, ElementAlignment alignment, boolean persistent) {
        if (key != null && element != null) {
            this.removeElement(key);
            if (alignment == ElementAlignment.LEFT) {
                this.leftElements.put(key, element);
            } else if (alignment == ElementAlignment.RIGHT) {
                this.rightElements.put(key, element);
            } else {
                this.leftElements.put(key, element);
            }
            this.setElementPersistent(key, persistent);
        }
    }

    public void addElement(AdvancedButton element, String key) {
        this.addElement(element, key, null, false);
    }

    public AdvancedButton getElement(String key) {
        if (this.leftElements.containsKey(key)) {
            return this.leftElements.get(key);
        }
        if (this.rightElements.containsKey(key)) {
            return this.rightElements.get(key);
        }
        return null;
    }

    public void setElementPersistent(String key, boolean persistent) {
        if (persistent) {
            if (!this.persistentElements.contains(key)) {
                this.persistentElements.add(key);
            }
        } else {
            this.persistentElements.remove(key);
        }
    }

    public void removeElement(String key) {
        if (key != null && !this.persistentElements.contains(key)) {
            if (this.leftElements.containsKey(key)) {
                this.leftElements.remove(key);
            }
            if (this.rightElements.containsKey(key)) {
                this.rightElements.remove(key);
            }
        }
    }

    public void removeElement(AdvancedButton element) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, AdvancedButton> m : this.leftElements.entrySet()) {
            if (m.getValue() != element) continue;
            keys.add(m.getKey());
        }
        for (Map.Entry<String, AdvancedButton> m : this.rightElements.entrySet()) {
            if (m.getValue() != element) continue;
            keys.add(m.getKey());
        }
        for (String s : keys) {
            this.removeElement(s);
        }
    }

    public void removeAllElements() {
        for (String s : this.getElementKeys()) {
            if (this.persistentElements.contains(s)) continue;
            this.removeElement(s);
        }
    }

    public void addChild(ContextMenu child, String key, ElementAlignment alignment) {
        child.setAutoAlignment(false);
        if (alignment == ElementAlignment.LEFT) {
            child.setAlignment(false, false);
        } else if (alignment == ElementAlignment.RIGHT) {
            child.setAlignment(false, true);
        } else {
            child.setAlignment(false, false);
        }
        this.childs.put(key, child);
    }

    public ContextMenu getChild(String key) {
        return this.childs.get(key);
    }

    public List<String> getElementKeys() {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(this.leftElements.keySet());
        l.addAll(this.rightElements.keySet());
        return l;
    }

    public List<AdvancedButton> getElements() {
        ArrayList<AdvancedButton> l = new ArrayList<AdvancedButton>();
        l.addAll(this.leftElements.values());
        l.addAll(this.rightElements.values());
        return l;
    }

    public void removeChild(String key) {
        if (this.childs.containsKey(key)) {
            this.childs.remove(key);
        }
    }

    public void removeChild(ContextMenu child) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, ContextMenu> m : this.childs.entrySet()) {
            if (m.getValue() != child) continue;
            keys.add(m.getKey());
        }
        for (String s : keys) {
            this.removeChild(s);
        }
    }

    public void removeAllChilds() {
        this.childs.clear();
    }

    public boolean isChildOpen() {
        for (ContextMenu m : this.childs.values()) {
            if (!m.isOpen()) continue;
            return true;
        }
        return false;
    }

    public void render(class_332 graphics, class_437 screen) {
        if (AnimationHandler.isReady() && screen != null && this.visible) {
            if (this.isChildOpen()) {
                MouseInput.blockVanillaInput((String)"fmcustomizationhelper");
            } else {
                MouseInput.unblockVanillaInput((String)"fmcustomizationhelper");
            }
            MouseInput.setRenderScale((float)this.getScale());
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            int width = screen.field_22789;
            float partialTicks = class_310.method_1551().method_1488();
            MouseInput.resetRenderScale();
            RenderUtils.setZLevelPre((class_332)graphics, (int)400);
            graphics.method_51448().method_22905(this.getScale(), this.getScale(), this.getScale());
            RenderSystem.enableBlend();
            if (this.expanded) {
                this.renderBackground(graphics, screen);
                for (ContextMenu contextMenu : this.childs.values()) {
                    contextMenu.setButtonHeight(this.height);
                    contextMenu.render(graphics, mouseX, mouseY);
                }
                int xl = 0;
                for (AdvancedButton b : this.leftElements.values()) {
                    if (!b.field_22764) continue;
                    WidgetUtils.setHeight((class_339)b, (int)this.height);
                    if (!(b instanceof AdvancedImageButton)) {
                        int i = class_310.method_1551().field_1772.method_1727(b.getMessageString());
                        b.method_25358(i + 12);
                    }
                    b.field_22760 = xl;
                    b.field_22761 = 0;
                    MenuBar.colorizeButton(b);
                    b.method_25394(graphics, mouseX, mouseY, partialTicks);
                    xl += b.method_25368() + this.elementSpace;
                }
                int n = (int)((float)width / this.getScale());
                for (AdvancedButton b : this.rightElements.values()) {
                    if (!b.field_22764) continue;
                    WidgetUtils.setHeight((class_339)b, (int)this.height);
                    if (!(b instanceof AdvancedImageButton)) {
                        int i = class_310.method_1551().field_1772.method_1727(b.getMessageString());
                        b.method_25358(i + 12);
                    }
                    b.field_22760 = var8_13 -= b.method_25368();
                    b.field_22761 = 0;
                    MenuBar.colorizeButton(b);
                    b.method_25394(graphics, mouseX, mouseY, partialTicks);
                    var8_13 -= this.elementSpace;
                }
            } else {
                AdvancedButton right = this.rightElements.get("menubar.default.extendbtn");
                if (right != null) {
                    WidgetUtils.setHeight((class_339)right, (int)this.height);
                    right.field_22760 = (int)((float)width / this.getScale() - (float)right.method_25368());
                    right.field_22761 = 0;
                    MenuBar.colorizeButton(right);
                    right.method_25394(graphics, mouseX, mouseY, partialTicks);
                }
            }
            RenderUtils.setZLevelPost((class_332)graphics);
        }
    }

    protected void renderBackground(class_332 graphics, class_437 screen) {
        if (this.expanded && screen != null && this.barColor != null) {
            RenderUtils.fill((class_332)graphics, (float)0.0f, (float)0.0f, (float)((float)screen.field_22789 / this.getScale()), (float)this.height, (int)this.barColor.getRGB(), (float)this.barOpacity);
        }
    }

    public boolean isHovered() {
        if (class_310.method_1551().field_1755 == null) {
            return false;
        }
        MouseInput.setRenderScale((float)this.getScale());
        int width = class_310.method_1551().field_1755.field_22789;
        int mX = MouseInput.getMouseX();
        int mY = MouseInput.getMouseY();
        MouseInput.resetRenderScale();
        for (ContextMenu m : this.childs.values()) {
            if (!m.isOpen() || !m.isHovered()) continue;
            return true;
        }
        return mX <= width && mX >= 0 && mY <= this.height && mY >= 0;
    }

    public float getScale() {
        return MenuBar.getUIScale();
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setBarColor(Color color) {
        this.barColor = color;
    }

    public void setExtended(boolean extended) {
        this.expanded = extended;
    }

    public void toggleExpanded() {
        this.expanded = !this.expanded;
    }

    public boolean isExtended() {
        return this.expanded;
    }

    public static enum ElementAlignment {
        LEFT,
        RIGHT;

    }
}

