/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper;

import com.google.common.io.Files;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.TextInputScreen;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.animation.ResourcePackAnimationRenderer;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomizationProperties;
import de.keksuccino.fancymenu.menu.fancy.helper.ChooseSavedSetupPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationHelper;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMNotificationPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMTextInputPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMYesNoPopup;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class SetupSharingEngine {
    public static final File MENU_IDENTIFIERS_DATABASE_FILE = new File(class_310.method_1551().field_1697, "config/fancymenu/menu_identifiers.db");
    public static final File FM_SETUPS_DIR = new File(class_310.method_1551().field_1697, "fancymenu_setups/exported_setups");
    public static final File SETUP_BACKUP_DIR = new File(class_310.method_1551().field_1697, "fancymenu_setups/.backups");
    protected static MenuIdentifierDatabase menuIdentifierDatabase = null;

    public static void init() {
        try {
            FM_SETUPS_DIR.mkdirs();
            SETUP_BACKUP_DIR.mkdirs();
            class_2960 rl = new class_2960("fancymenu", "menu_identifiers.db");
            InputStream in = class_310.method_1551().method_1478().open(rl);
            if (in != null) {
                org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)in, (File)MENU_IDENTIFIERS_DATABASE_FILE);
            }
            if (MENU_IDENTIFIERS_DATABASE_FILE.isFile()) {
                menuIdentifierDatabase = new MenuIdentifierDatabase(MENU_IDENTIFIERS_DATABASE_FILE);
            }
            MenuCustomizationProperties.loadProperties();
            MenuCustomization.updateCustomizeableMenuCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void importSetup() {
        try {
            FMYesNoPopup importConfirmPop = new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                if (call.booleanValue()) {
                    FMTextInputPopup pop = new FMTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"fancymenu.helper.setupsharing.import.enterpath", (String[])new String[0]), null, 240, call2 -> SetupSharingEngine.importSetupWithPathRaw(call2));
                    PopupHandler.displayPopup((Popup)pop);
                }
            }, Locals.localize((String)"fancymenu.helper.setupsharing.import.confirm", (String[])new String[0]));
            PopupHandler.displayPopup((Popup)importConfirmPop);
        }
        catch (Exception e) {
            e.printStackTrace();
            SetupSharingEngine.displayImportErrorPopup();
        }
    }

    public static void importSetupFromSavedSetups() {
        try {
            FMYesNoPopup importConfirmPop = new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                if (call.booleanValue()) {
                    ChooseSavedSetupPopup pop = new ChooseSavedSetupPopup(call2 -> {
                        if (call2 != null) {
                            SetupSharingEngine.importSetupWithPathRaw(call2.getPath());
                        }
                    });
                    PopupHandler.displayPopup((Popup)pop);
                }
            }, Locals.localize((String)"fancymenu.helper.setupsharing.import.confirm", (String[])new String[0]));
            PopupHandler.displayPopup((Popup)importConfirmPop);
        }
        catch (Exception e) {
            e.printStackTrace();
            SetupSharingEngine.displayImportErrorPopup();
        }
    }

    protected static void importSetupWithPathRaw(String setupPath) {
        if (setupPath != null) {
            setupPath = CustomizationItemBase.fixBackslashPath(setupPath);
            try {
                File appData = SetupSharingEngine.getFancyMenuAppData();
                if (appData != null) {
                    File setup = new File(setupPath);
                    if (SetupSharingEngine.isValidSetup(setup.getPath())) {
                        File temp = new File(appData.getPath() + "/temp/fancymenu_setup_temp_" + UUID.randomUUID());
                        temp.mkdirs();
                        SetupSharingEngine.copyTempImportPath(setup, temp, () -> SetupSharingEngine.backupCurrentSetup(() -> {
                            try {
                                SetupImporter i = new SetupImporter(temp.getPath(), onFinished -> {
                                    if (onFinished.wasImportSuccessful()) {
                                        FMNotificationPopup pop2 = new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, () -> CustomizationHelper.reloadSystemAndMenu(), Locals.localize((String)"fancymenu.helper.setupsharing.import.success", (String[])new String[0]));
                                        PopupHandler.displayPopup((Popup)pop2);
                                    } else if (!onFinished.wasCanceledByUser()) {
                                        SetupSharingEngine.displayImportErrorPopup();
                                    }
                                    try {
                                        org.apache.commons.io.FileUtils.deleteDirectory((File)temp);
                                    }
                                    catch (Exception e3) {
                                        e3.printStackTrace();
                                    }
                                });
                                i.startImport();
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                                SetupSharingEngine.displayImportErrorPopup();
                            }
                        }));
                    } else {
                        FMNotificationPopup pop2 = new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, Locals.localize((String)"fancymenu.helper.setupsharing.import.invalidsetup", (String[])new String[0]));
                        PopupHandler.displayPopup((Popup)pop2);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                SetupSharingEngine.displayImportErrorPopup();
            }
        }
    }

    protected static void displayImportErrorPopup() {
        FMNotificationPopup pop = new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, () -> CustomizationHelper.reloadSystemAndMenu(), Locals.localize((String)"fancymenu.helper.setupsharing.import.error", (String[])new String[0]));
        PopupHandler.displayPopup((Popup)pop);
    }

    public static void exportSetup() {
        try {
            FMYesNoPopup exportConfirmPopup = new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                if (call.booleanValue()) {
                    String setupNameDefault = "exported_fm_setup_" + SetupSharingEngine.getTimestamp();
                    class_437 current = class_310.method_1551().field_1755;
                    TextInputScreen s = new TextInputScreen((class_2561)class_2561.method_43470((String)Locals.localize((String)"fancymenu.helper.setupsharing.export.entername", (String[])new String[0])), null, call2 -> {
                        class_310.method_1551().method_1507(current);
                        if (call2 != null) {
                            new Thread(() -> {
                                String setupName = call2;
                                if (setupName.replace(" ", "").equals("")) {
                                    setupName = setupNameDefault;
                                }
                                StatusPopup exportBlockerPopup = new StatusPopup(Locals.localize((String)"fancymenu.helper.setupsharing.import.exportingsetup", (String[])new String[0]));
                                PopupHandler.displayPopup((Popup)exportBlockerPopup);
                                try {
                                    FM_SETUPS_DIR.mkdirs();
                                    List<String> unableToExportList = SetupSharingEngine.exportSetupRaw(FM_SETUPS_DIR.getPath(), setupName);
                                    if (unableToExportList != null) {
                                        if (unableToExportList.isEmpty()) {
                                            SetupSharingEngine.displayExportSuccessPopup(FM_SETUPS_DIR);
                                        } else {
                                            SetupSharingEngine.displayFailedToExportSomeElementsPopup(unableToExportList, FM_SETUPS_DIR);
                                        }
                                    } else {
                                        SetupSharingEngine.displayExportErrorPopup();
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    SetupSharingEngine.displayExportErrorPopup();
                                }
                                exportBlockerPopup.setDisplayed(false);
                            }).start();
                        }
                    });
                    s.setText(setupNameDefault);
                    class_310.method_1551().method_1507((class_437)s);
                }
            }, Locals.localize((String)"fancymenu.helper.setupsharing.export.confirm", (String[])new String[0]));
            PopupHandler.displayPopup((Popup)exportConfirmPopup);
        }
        catch (Exception e) {
            e.printStackTrace();
            SetupSharingEngine.displayExportErrorPopup();
        }
    }

    protected static void copyTempImportPath(File setup, File temp, Runnable onFinish) {
        new Thread(() -> {
            try {
                StatusPopup copyBlockerPopup = new StatusPopup(Locals.localize((String)"fancymenu.helper.setupsharing.import.preparing", (String[])new String[0]));
                PopupHandler.displayPopup((Popup)copyBlockerPopup);
                org.apache.commons.io.FileUtils.copyDirectory((File)setup, (File)temp);
                copyBlockerPopup.setDisplayed(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            onFinish.run();
        }).start();
    }

    protected static void backupCurrentSetup(Runnable onFinish) {
        new Thread(() -> {
            try {
                StatusPopup backupBlockerPopup = new StatusPopup(Locals.localize((String)"fancymenu.helper.setupsharing.restore.backingup", (String[])new String[0]));
                PopupHandler.displayPopup((Popup)backupBlockerPopup);
                SETUP_BACKUP_DIR.mkdirs();
                SetupSharingEngine.deleteOldBackups();
                SetupSharingEngine.exportSetupRaw(SETUP_BACKUP_DIR.getPath(), "fm_setup_backup_" + SetupSharingEngine.getTimestamp());
                backupBlockerPopup.setDisplayed(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            onFinish.run();
        }).start();
    }

    protected static void deleteOldBackups() {
        try {
            File[] backups = SETUP_BACKUP_DIR.listFiles();
            SetupSharingEngine.sortByDateModified(backups);
            ArrayList<File> backupsList = new ArrayList<File>();
            for (File f : backups) {
                if (!SetupSharingEngine.isValidSetup(f.getPath())) continue;
                backupsList.add(f);
            }
            ArrayList<File> delete = new ArrayList<File>();
            int maxBackups = 5;
            int i = 0;
            for (int backupsCount = backupsList.size(); backupsCount > maxBackups - 1; --backupsCount) {
                delete.add((File)backupsList.get(i));
                ++i;
            }
            for (File f : delete) {
                FancyMenu.LOGGER.info("[FANCYMENU] Deleting old setup backup: " + f.getPath());
                org.apache.commons.io.FileUtils.deleteDirectory((File)f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static File[] sortByDateModified(File[] files) {
        try {
            Arrays.sort(files, Comparator.comparingLong(File::lastModified));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return files;
    }

    protected static boolean generateUnableToExportLog(List<String> list, File exportTo) {
        try {
            ArrayList<String> l = new ArrayList<String>();
            l.add("UNABLE TO EXPORT SOME SETUP ELEMENTS:");
            l.add("");
            l.addAll(list);
            File exportFailsFile = new File(exportTo.getPath() + "/export_fail_log_" + SetupSharingEngine.getTimestamp() + ".txt");
            exportFailsFile.createNewFile();
            FileUtils.writeTextToFile((File)exportFailsFile, (boolean)false, (String[])l.toArray(new String[0]));
            CustomizationHelper.openFile(exportFailsFile);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected static void displayExportErrorPopup() {
        FMNotificationPopup pop = new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, Locals.localize((String)"fancymenu.helper.setupsharing.export.error", (String[])new String[0]));
        PopupHandler.displayPopup((Popup)pop);
    }

    protected static void displayExportSuccessPopup(File exportTo) {
        FMYesNoPopup pop = new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call2 -> {
            try {
                if (call2.booleanValue()) {
                    CustomizationHelper.openFile(exportTo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                SetupSharingEngine.displayExportErrorPopup();
            }
        }, Locals.localize((String)"fancymenu.helper.setupsharing.export.success", (String[])new String[0]));
        PopupHandler.displayPopup((Popup)pop);
    }

    protected static void displayFailedToExportSomeElementsPopup(List<String> unableToExportList, File exportTo) {
        FMYesNoPopup pop = new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call2 -> {
            if (call2.booleanValue() && !SetupSharingEngine.generateUnableToExportLog(unableToExportList, exportTo)) {
                SetupSharingEngine.displayExportErrorPopup();
            }
            SetupSharingEngine.displayExportSuccessPopup(exportTo);
        }, Locals.localize((String)"fancymenu.helper.setupsharing.export.unabletoexport", (String[])new String[]{"" + unableToExportList.size()}));
        PopupHandler.displayPopup((Popup)pop);
    }

    public static List<String> exportSetupRaw(String baseDir, String setupName) {
        ArrayList<String> unableToExport = new ArrayList<String>();
        try {
            if (baseDir == null) {
                return null;
            }
            if (setupName == null) {
                return null;
            }
            File exportToTemp = new File(class_310.method_1551().field_1697, "fm_export_temp_folder_" + UUID.randomUUID());
            File exportToTempSetup = new File(exportToTemp.getPath() + "/setup");
            exportToTempSetup.mkdirs();
            ArrayList<PropertiesSet> layouts = new ArrayList<PropertiesSet>();
            layouts.addAll(MenuCustomizationProperties.getProperties());
            layouts.addAll(MenuCustomizationProperties.getDisabledProperties());
            ArrayList<String> exportedResources = new ArrayList<String>();
            ArrayList<String> failedToExportResources = new ArrayList<String>();
            for (PropertiesSet l : layouts) {
                for (String s : SetupSharingEngine.getLayoutResources(l)) {
                    try {
                        if (exportedResources.contains(s) || failedToExportResources.contains(s)) continue;
                        File oriFile = new File(s);
                        if (oriFile.isFile()) {
                            File target = new File(exportToTempSetup.getAbsolutePath().replace("\\", "/") + "/" + SetupSharingEngine.getShortPath(oriFile.getPath()));
                            File targetParent = target.getParentFile();
                            if (targetParent != null) {
                                targetParent.mkdirs();
                            }
                            org.apache.commons.io.FileUtils.copyFile((File)oriFile, (File)target);
                            exportedResources.add(s);
                        } else if (oriFile.isDirectory()) {
                            String targetDir = exportToTempSetup.getAbsolutePath().replace("\\", "/") + "/" + SetupSharingEngine.getShortPath(oriFile.getPath());
                            File target = new File(targetDir);
                            target.mkdirs();
                            org.apache.commons.io.FileUtils.copyDirectory((File)oriFile, (File)target);
                            exportedResources.add(s);
                        }
                        if (exportedResources.contains(s)) continue;
                        failedToExportResources.add(s);
                    }
                    catch (Exception e2) {
                        if (!failedToExportResources.contains(s)) {
                            failedToExportResources.add(s);
                        }
                        e2.printStackTrace();
                    }
                }
            }
            for (String s : failedToExportResources) {
                unableToExport.add("RESOURCE: " + s);
            }
            ArrayList<String> exportedAnimations = new ArrayList<String>();
            ArrayList<String> failedToExportAnimations = new ArrayList<String>();
            for (AdvancedAnimationMeta m : SetupSharingEngine.getAnimationMetas()) {
                try {
                    if (m.propertiesPath != null) {
                        File resPath;
                        File propsPath;
                        File aniPath;
                        if (exportedAnimations.contains(m.name) || failedToExportAnimations.contains(m.name)) continue;
                        if (m.type == AnimationType.LEGACY && (aniPath = new File(m.propertiesPath)).isDirectory()) {
                            exportedAnimations.add(m.name);
                        }
                        if (m.type == AnimationType.PACK) {
                            propsPath = new File(m.propertiesPath);
                            resPath = new File(m.resourcesPath);
                            File packMetaPath = null;
                            try {
                                packMetaPath = resPath.getAbsoluteFile().getParentFile();
                                if (packMetaPath != null) {
                                    packMetaPath = packMetaPath.getParentFile();
                                }
                                if (packMetaPath != null) {
                                    packMetaPath = new File(packMetaPath.getPath() + "/pack.mcmeta");
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            if (propsPath.isDirectory() && resPath.isDirectory()) {
                                File resTarget = new File(exportToTempSetup.getAbsolutePath().replace("\\", "/") + "/" + SetupSharingEngine.getShortPath(resPath.getPath()));
                                resTarget.mkdirs();
                                org.apache.commons.io.FileUtils.copyDirectory((File)resPath, (File)resTarget);
                                if (packMetaPath != null && packMetaPath.isFile()) {
                                    File packMetaTarget = new File(exportToTempSetup.getAbsolutePath().replace("\\", "/") + "/" + SetupSharingEngine.getShortPath(packMetaPath.getPath()));
                                    org.apache.commons.io.FileUtils.copyFile((File)packMetaPath, (File)packMetaTarget);
                                    exportedAnimations.add(m.name);
                                }
                            }
                        }
                        if (m.type == AnimationType.LMR) {
                            propsPath = new File(m.propertiesPath);
                            resPath = new File(m.resourcesPath);
                            if (propsPath.isDirectory() && resPath.isDirectory()) {
                                File resTarget = new File(exportToTempSetup.getAbsolutePath().replace("\\", "/") + "/" + SetupSharingEngine.getShortPath(resPath.getPath()));
                                resTarget.mkdirs();
                                org.apache.commons.io.FileUtils.copyDirectory((File)resPath, (File)resTarget);
                                exportedAnimations.add(m.name);
                            }
                        }
                        if (exportedAnimations.contains(m.name) || failedToExportAnimations.contains(m.name)) continue;
                        failedToExportAnimations.add(m.name);
                        continue;
                    }
                    if (failedToExportAnimations.contains(m.name)) continue;
                    failedToExportAnimations.add(m.name);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    if (failedToExportAnimations.contains(m.name)) continue;
                    failedToExportAnimations.add(m.name);
                }
            }
            for (String s : failedToExportAnimations) {
                unableToExport.add("ANIMATION: " + s);
            }
            try {
                String splashPath = (String)FancyMenu.config.getOrDefault("splashtextfile", (Object)"");
                if (splashPath.toLowerCase().endsWith(".txt")) {
                    File splashFile = new File(splashPath);
                    if (splashFile.isFile()) {
                        File parent = splashFile.getParentFile();
                        if (parent != null) {
                            File targetParent = new File(exportToTempSetup.getAbsolutePath().replace("\\", "/") + "/" + SetupSharingEngine.getShortPath(parent.getPath()));
                            targetParent.mkdirs();
                        }
                        File copyTo = new File(exportToTempSetup.getAbsolutePath().replace("\\", "/") + "/" + SetupSharingEngine.getShortPath(splashFile.getPath()));
                        org.apache.commons.io.FileUtils.copyFile((File)splashFile, (File)copyTo);
                    } else {
                        unableToExport.add("CONFIG: CUSTOM VANILLA SPLASH FILE: " + splashPath);
                    }
                }
            }
            catch (Exception e2) {
                unableToExport.add("CONFIG: CUSTOM VANILLA SPLASH FILE: " + (String)FancyMenu.config.getOrDefault("splashtextfile", (Object)""));
                e2.printStackTrace();
            }
            try {
                File fmDir = FancyMenu.MOD_DIR;
                File target = new File(exportToTempSetup.getAbsolutePath().replace("\\", "/") + "/config/fancymenu");
                target.mkdirs();
                org.apache.commons.io.FileUtils.copyDirectory((File)fmDir, (File)target);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return null;
            }
            SetupSharingEngine.writeSetupPropertiesFile(exportToTemp.getAbsolutePath().replace("\\", "/") + "/setup.properties");
            try {
                String uniqueSetupName = SetupSharingEngine.getUniqueSetupName(baseDir, setupName);
                File exportTo = new File(baseDir + "/" + uniqueSetupName);
                exportTo.mkdirs();
                org.apache.commons.io.FileUtils.copyDirectory((File)exportToTemp, (File)exportTo);
                org.apache.commons.io.FileUtils.deleteDirectory((File)exportToTemp);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return null;
            }
            return unableToExport;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static String getUniqueSetupName(String baseDir, String name) {
        Object s = name;
        try {
            File f = new File(baseDir + "/" + name);
            int i = 2;
            while (f.isDirectory()) {
                s = name + "_" + i;
                ++i;
                f = new File(baseDir + "/" + (String)s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    public static boolean isValidSetup(String pathToSetup) {
        try {
            File setupRoot = new File(pathToSetup);
            if (setupRoot.isDirectory()) {
                File instance = new File(setupRoot.getPath() + "/setup");
                File props = new File(setupRoot.getPath() + "/setup.properties");
                return instance.isDirectory() && props.isFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected static void writeSetupPropertiesFile(String saveToPathWithFileName) {
        try {
            PropertiesSet set = new PropertiesSet("fancymenu_setup");
            PropertiesSection meta = new PropertiesSection("setup-meta");
            meta.addEntry("modloader", "fabric");
            meta.addEntry("mcversion", class_155.method_16673().method_48019());
            meta.addEntry("fmversion", "2.14.10");
            set.addProperties(meta);
            PropertiesSection mods = new PropertiesSection("mod-list");
            int i = 1;
            for (ModContainer info : FabricLoader.getInstance().getAllMods()) {
                String id = info.getMetadata().getId();
                if (id.equals("fancymenu") || id.equals("konkrete") || id.equals("loadmyresources") || id.equals("forge") || id.equals("mcp") || id.equals("minecraft") || id.equals("fml")) continue;
                mods.addEntry("" + i, id);
            }
            set.addProperties(mods);
            PropertiesSerializer.writeProperties((PropertiesSet)set, (String)saveToPathWithFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SetupProperties deserializePropertiesFile(String propsFilePath) {
        SetupProperties sp = new SetupProperties();
        try {
            PropertiesSet set = PropertiesSerializer.getProperties((String)propsFilePath);
            if (set != null) {
                List modLists;
                List metas = set.getPropertiesOfType("setup-meta");
                if (!metas.isEmpty()) {
                    PropertiesSection meta = (PropertiesSection)metas.get(0);
                    sp.modLoader = meta.getEntryValue("modloader");
                    sp.mcVersion = meta.getEntryValue("mcversion");
                    sp.fmVersion = meta.getEntryValue("fmversion");
                }
                if (!(modLists = set.getPropertiesOfType("mod-list")).isEmpty()) {
                    PropertiesSection modList = (PropertiesSection)modLists.get(0);
                    for (Map.Entry m : modList.getEntries().entrySet()) {
                        sp.modList.add((String)m.getValue());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sp;
    }

    protected static List<String> getLayoutResources(PropertiesSet layout) {
        ArrayList<String> l = new ArrayList<String>();
        for (PropertiesSection s : layout.getPropertiesOfType("customization")) {
            String action = s.getEntryValue("action");
            if (action == null) continue;
            for (Map.Entry m : s.getEntries().entrySet()) {
                String shortPath;
                if (action.equalsIgnoreCase("addbutton") && m.getKey() != null && ((String)m.getKey()).equals("value") || (shortPath = CustomizationItemBase.fixBackslashPath(SetupSharingEngine.getShortPath(CustomizationItemBase.fixBackslashPath((String)m.getValue())))) == null) continue;
                File f = new File(shortPath);
                if (((String)m.getValue()).replace(" ", "").equals("") || !f.exists() || shortPath.endsWith("config/fancymenu") || shortPath.endsWith("config/fancymenu/")) continue;
                l.add(shortPath);
            }
        }
        return l;
    }

    public static String getShortPath(String path) {
        if (path == null) {
            return null;
        }
        File pathRaw = new File(path = CustomizationItemBase.fixBackslashPath(path));
        if (!pathRaw.exists()) {
            return null;
        }
        File home = class_310.method_1551().field_1697;
        if (pathRaw.getAbsolutePath().replace("\\", "/").startsWith(home.getAbsolutePath().replace("\\", "/")) && ((path = pathRaw.getAbsolutePath().replace("\\", "/").replace(home.getAbsolutePath().replace("\\", "/"), "")).startsWith("\\") || path.startsWith("/"))) {
            path = path.substring(1);
        }
        return CustomizationItemBase.fixBackslashPath(path);
    }

    protected static List<AdvancedAnimationMeta> getAnimationMetas() {
        ArrayList<AdvancedAnimationMeta> l = new ArrayList<AdvancedAnimationMeta>();
        for (String s : AnimationHandler.getCustomAnimationNames()) {
            AdvancedAnimationMeta tempMeta;
            AdvancedAnimationMeta meta = new AdvancedAnimationMeta();
            meta.name = s;
            if (AnimationHandler.animationExists(s) && (tempMeta = SetupSharingEngine.getAdvancedAnimationMeta(s)) != null) {
                meta.type = tempMeta.type;
                meta.propertiesPath = tempMeta.propertiesPath;
                meta.resourcesPath = tempMeta.resourcesPath;
            }
            l.add(meta);
        }
        return l;
    }

    public static AdvancedAnimationMeta getAdvancedAnimationMeta(String advancedAnimationName) {
        if (AnimationHandler.animationExists(advancedAnimationName)) {
            IAnimationRenderer a = AnimationHandler.getAnimation(advancedAnimationName);
            AdvancedAnimationMeta meta = new AdvancedAnimationMeta();
            meta.name = advancedAnimationName;
            if (a instanceof AdvancedAnimation) {
                meta.propertiesPath = ((AdvancedAnimation)a).propertiesPath;
                IAnimationRenderer mainAni = ((AdvancedAnimation)a).getMainAnimationRenderer();
                if (mainAni == null) {
                    return null;
                }
                if (mainAni instanceof ResourcePackAnimationRenderer) {
                    String namespace = ((ResourcePackAnimationRenderer)mainAni).getPath();
                    File lmrAni = new File(class_310.method_1551().field_1697, "resources/" + namespace);
                    if (lmrAni.isDirectory()) {
                        meta.type = AnimationType.LMR;
                        meta.resourcesPath = lmrAni.getPath();
                        return meta;
                    }
                    File resPackDir = new File(class_310.method_1551().field_1697, "resourcepacks");
                    if (resPackDir.isDirectory()) {
                        for (File f : resPackDir.listFiles()) {
                            File packAni = new File(f.getPath() + "/assets/" + namespace);
                            if (!packAni.isDirectory()) continue;
                            meta.type = AnimationType.PACK;
                            meta.resourcesPath = packAni.getPath();
                            return meta;
                        }
                    }
                } else {
                    meta.type = AnimationType.LEGACY;
                    return meta;
                }
            }
        }
        return null;
    }

    public static String getTimestamp() {
        Calendar c = Calendar.getInstance();
        int day = c.get(5);
        int month = c.get(2) + 1;
        int year = c.get(1);
        int hour = c.get(11);
        int min = c.get(12);
        int sec = c.get(13);
        return day + "-" + month + "-" + year + "-" + hour + "-" + min + "-" + sec;
    }

    public static File getFancyMenuAppData() {
        try {
            Object appDataDir = null;
            String osName = System.getProperty("os.name").toLowerCase();
            appDataDir = osName.contains("win") ? System.getenv("AppData") : System.getProperty("user.home");
            if (appDataDir != null) {
                appDataDir = (String)appDataDir + "/fancymenu";
                File f = new File((String)appDataDir);
                f.mkdirs();
                return f;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static MenuIdentifierDatabase getIdentifierDatabase() {
        return menuIdentifierDatabase;
    }

    public static class MenuIdentifierDatabase {
        protected List<List<String>> identifierGroups = new ArrayList<List<String>>();

        public MenuIdentifierDatabase(File dbFile) {
            try {
                PropertiesSet set = PropertiesSerializer.getProperties((String)dbFile.getPath());
                if (set != null) {
                    for (PropertiesSection s : set.getPropertiesOfType("identifier-group")) {
                        ArrayList<String> l = new ArrayList<String>();
                        for (Map.Entry m : s.getEntries().entrySet()) {
                            l.add((String)m.getValue());
                        }
                        if (l.isEmpty()) continue;
                        this.identifierGroups.add(l);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String findValidIdentifierFor(String invalidIdentifier) {
            try {
                if (invalidIdentifier != null) {
                    for (List<String> l : this.identifierGroups) {
                        if (!l.contains(invalidIdentifier)) continue;
                        for (String s : l) {
                            try {
                                Class.forName(s, false, SetupSharingEngine.class.getClassLoader());
                                return s;
                            }
                            catch (Exception exception) {
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static class AdvancedAnimationMeta {
        public String name;
        public String propertiesPath;
        public String resourcesPath;
        public AnimationType type;
    }

    public static enum AnimationType {
        LEGACY,
        LMR,
        PACK;

    }

    public static class SetupProperties {
        public String modLoader;
        public String mcVersion;
        public String fmVersion;
        public List<String> modList = new ArrayList<String>();
    }

    public static class StatusPopup
    extends FMPopup {
        String status;

        public StatusPopup(String status) {
            super(240);
            this.status = status;
        }

        public void render(class_332 graphics, int mouseX, int mouseY, class_437 renderIn) {
            super.render(graphics, mouseX, mouseY, renderIn);
            int centerX = renderIn.field_22789 / 2;
            int centerY = renderIn.field_22790 / 2;
            graphics.method_25300(class_310.method_1551().field_1772, this.status, centerX, centerY, -1);
        }
    }

    public static class SetupImporter {
        protected volatile String setupPath;
        protected volatile File setupPropertiesPath;
        protected volatile SetupProperties setupProperties;
        protected volatile File setupInstancePath;
        protected volatile Consumer<SetupImporter> onFinished = null;
        protected volatile boolean importSuccessful = false;
        protected volatile boolean canceledByUser = false;
        protected volatile boolean doStep = true;
        protected volatile int step = 1;
        protected volatile boolean isThreadRunning = true;
        protected volatile StatusPopup importBlockerPopup = null;

        public SetupImporter(String setupPath, Consumer<SetupImporter> onFinished) {
            this.onFinished = onFinished;
            this.setupPath = setupPath;
            if (this.setupPath != null) {
                this.setupInstancePath = new File(this.setupPath + "/setup");
                this.setupPropertiesPath = new File(this.setupPath + "/setup.properties");
                if (this.isValidSetup()) {
                    this.setupProperties = SetupSharingEngine.deserializePropertiesFile(this.setupPropertiesPath.getPath());
                }
            }
        }

        public void startImport() {
            if (this.isValidSetup()) {
                new Thread(() -> {
                    while (this.isThreadRunning) {
                        block25: {
                            try {
                                FMYesNoPopup pop;
                                if (!this.doStep) break block25;
                                if (this.step == 1 && this.setupProperties.modLoader != null) {
                                    if (!this.setupProperties.modLoader.equals("fabric")) {
                                        this.doStep = false;
                                        pop = new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                                            if (call.booleanValue()) {
                                                this.step = 2;
                                                this.doStep = true;
                                            } else {
                                                this.finish(true);
                                            }
                                        }, StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.setupsharing.import.differentmodloader", (String[])new String[]{this.setupProperties.modLoader, "fabric"}), (String)"%n%"));
                                        PopupHandler.displayPopup((Popup)pop);
                                    } else {
                                        this.step = 2;
                                    }
                                }
                                if (this.step == 2 && this.setupProperties.mcVersion != null) {
                                    if (!this.setupProperties.mcVersion.equals(class_155.method_16673().method_48019())) {
                                        this.doStep = false;
                                        pop = new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                                            if (call.booleanValue()) {
                                                this.step = 3;
                                                this.doStep = true;
                                            } else {
                                                this.finish(true);
                                            }
                                        }, StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.setupsharing.import.differentmcversion", (String[])new String[]{this.setupProperties.mcVersion, class_155.method_16673().method_48019()}), (String)"%n%"));
                                        PopupHandler.displayPopup((Popup)pop);
                                    } else {
                                        this.step = 3;
                                    }
                                }
                                if (this.step == 3 && this.setupProperties.fmVersion != null) {
                                    if (!this.setupProperties.fmVersion.equals("2.14.10")) {
                                        this.doStep = false;
                                        pop = new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                                            if (call.booleanValue()) {
                                                this.step = 4;
                                                this.doStep = true;
                                            } else {
                                                this.finish(true);
                                            }
                                        }, StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.setupsharing.import.differentfmversion", (String[])new String[]{this.setupProperties.fmVersion, "2.14.10"}), (String)"%n%"));
                                        PopupHandler.displayPopup((Popup)pop);
                                    } else {
                                        this.step = 4;
                                    }
                                }
                                if (this.step == 4) {
                                    this.step = 5;
                                }
                                if (this.step == 5) {
                                    if (!this.allMenuIdentifiersValid()) {
                                        this.doStep = false;
                                        pop = new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                                            if (call.booleanValue()) {
                                                this.fixMenuIdentifiers();
                                            }
                                            this.step = 6;
                                            this.doStep = true;
                                        }, StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.setupsharing.import.invalididentifiers", (String[])new String[0]), (String)"%n%"));
                                        PopupHandler.displayPopup((Popup)pop);
                                    } else {
                                        this.step = 6;
                                    }
                                }
                                if (this.step != 6) break block25;
                                try {
                                    File targetRaw;
                                    File targetDir;
                                    this.importBlockerPopup = new StatusPopup(Locals.localize((String)"fancymenu.helper.setupsharing.import.importingsetup", (String[])new String[0]));
                                    PopupHandler.displayPopup((Popup)this.importBlockerPopup);
                                    if (!this.setupInstancePath.isDirectory() || !(targetDir = new File((targetRaw = class_310.method_1551().field_1697).getAbsolutePath().replace("\\", "/"))).isDirectory()) break block25;
                                    try {
                                        File fmFolder = FancyMenu.MOD_DIR;
                                        File customizationFolder = new File(fmFolder.getPath() + "/customization");
                                        File customizableMenusFile = new File(fmFolder.getPath() + "/customizablemenus.txt");
                                        if (customizationFolder.isDirectory()) {
                                            org.apache.commons.io.FileUtils.deleteDirectory((File)customizationFolder);
                                        }
                                        if (customizableMenusFile.isFile()) {
                                            org.apache.commons.io.FileUtils.forceDelete((File)customizableMenusFile);
                                        }
                                        if (fmFolder.isDirectory()) {
                                            org.apache.commons.io.FileUtils.deleteDirectory((File)fmFolder);
                                        }
                                    }
                                    catch (Exception e2) {
                                        e2.printStackTrace();
                                    }
                                    org.apache.commons.io.FileUtils.copyDirectory((File)this.setupInstancePath, (File)targetDir);
                                    this.importSuccessful = true;
                                    this.finish(false);
                                    FancyMenu.LOGGER.info("[FANCYMENU] Setup successfully imported!");
                                }
                                catch (Exception e2) {
                                    e2.printStackTrace();
                                    this.finish(false);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.finish(false);
                            }
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.finish(false);
                        }
                    }
                }).start();
            } else {
                this.finish(false);
            }
        }

        protected void finish(boolean canceledByUser) {
            this.canceledByUser = canceledByUser;
            this.doStep = false;
            this.step = -10000;
            this.isThreadRunning = false;
            if (this.importBlockerPopup != null) {
                this.importBlockerPopup.setDisplayed(false);
            }
            if (this.onFinished != null) {
                this.onFinished.accept(this);
            }
        }

        public boolean isValidSetup() {
            if (this.setupInstancePath != null && this.setupPropertiesPath != null) {
                return this.setupPropertiesPath.isFile() && this.setupInstancePath.isDirectory();
            }
            return false;
        }

        public boolean wasImportSuccessful() {
            return this.importSuccessful;
        }

        public boolean wasCanceledByUser() {
            return this.canceledByUser;
        }

        protected boolean allMenuIdentifiersValid() {
            try {
                PropertiesSet menus;
                for (Map.Entry<String, PropertiesSet> m : this.getLayouts().entrySet()) {
                    PropertiesSection meta;
                    String identifier;
                    List metas = m.getValue().getPropertiesOfType("customization-meta");
                    if (metas.isEmpty()) {
                        metas = m.getValue().getPropertiesOfType("type-meta");
                    }
                    if (metas.isEmpty() || (identifier = (meta = (PropertiesSection)metas.get(0)).getEntryValue("identifier")) == null || this.isValidMenuIdentifier(identifier)) continue;
                    return false;
                }
                File customizableMenusFile = new File(this.setupInstancePath.getPath() + "/config/fancymenu/customizablemenus.txt");
                if (customizableMenusFile.isFile() && (menus = PropertiesSerializer.getProperties((String)customizableMenusFile.getPath())) != null) {
                    for (PropertiesSection sec : menus.getProperties()) {
                        if (this.isValidMenuIdentifier(sec.getSectionType())) continue;
                        return false;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }

        protected void fixMenuIdentifiers() {
            try {
                PropertiesSet menus;
                for (Map.Entry<String, PropertiesSet> m : this.getLayouts().entrySet()) {
                    PropertiesSection meta;
                    String identifier;
                    List metas = m.getValue().getPropertiesOfType("customization-meta");
                    if (metas.isEmpty()) {
                        metas = m.getValue().getPropertiesOfType("type-meta");
                    }
                    if (metas.isEmpty() || (identifier = (meta = (PropertiesSection)metas.get(0)).getEntryValue("identifier")) == null || this.isValidMenuIdentifier(identifier)) continue;
                    String fixedIdentifier = menuIdentifierDatabase.findValidIdentifierFor(identifier);
                    if (fixedIdentifier != null) {
                        meta.removeEntry("identifier");
                        meta.addEntry("identifier", fixedIdentifier);
                        PropertiesSerializer.writeProperties((PropertiesSet)m.getValue(), (String)m.getKey());
                        FancyMenu.LOGGER.info("[FANCYMENU] SETUP IMPORT: Identifier fixed: " + identifier + " -> " + fixedIdentifier);
                        continue;
                    }
                    FancyMenu.LOGGER.warn("[FANCYMENU] SETUP IMPORT: Unable to fix identifier: " + identifier);
                }
                File customizableMenusFile = new File(this.setupInstancePath.getPath() + "/config/fancymenu/customizablemenus.txt");
                if (customizableMenusFile.isFile() && (menus = PropertiesSerializer.getProperties((String)customizableMenusFile.getPath())) != null) {
                    int fixed = 0;
                    PropertiesSet newMenus = new PropertiesSet("customizablemenus");
                    for (PropertiesSection sec : menus.getProperties()) {
                        if (!this.isValidMenuIdentifier(sec.getSectionType())) {
                            String fixedIdentifier = menuIdentifierDatabase.findValidIdentifierFor(sec.getSectionType());
                            if (fixedIdentifier != null) {
                                PropertiesSection newSec = new PropertiesSection(fixedIdentifier);
                                newMenus.addProperties(newSec);
                                ++fixed;
                                FancyMenu.LOGGER.info("[FANCYMENU] SETUP IMPORT: CUSTOMIZABLE MENUS FILE: Identifier fixed: " + sec.getSectionType() + " -> " + fixedIdentifier);
                                continue;
                            }
                            newMenus.addProperties(sec);
                            FancyMenu.LOGGER.warn("[FANCYMENU] SETUP IMPORT: CUSTOMIZABLE MENUS FILE: Unable to fix identifier: " + sec.getSectionType());
                            continue;
                        }
                        newMenus.addProperties(sec);
                    }
                    if (fixed > 0) {
                        PropertiesSerializer.writeProperties((PropertiesSet)newMenus, (String)customizableMenusFile.getPath());
                        FancyMenu.LOGGER.warn("[FANCYMENU] SETUP IMPORT: CUSTOMIZABLE MENUS FILE: Fixed identifiers successfully written to file!");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected Map<String, PropertiesSet> getLayouts() {
            HashMap<String, PropertiesSet> m = new HashMap<String, PropertiesSet>();
            try {
                if (this.setupInstancePath != null) {
                    File cusPath = new File(this.setupInstancePath.getPath() + "/config/fancymenu/customization");
                    File disPath = new File(this.setupInstancePath.getPath() + "/config/fancymenu/customization/.disabled");
                    if (cusPath.isDirectory()) {
                        ArrayList<File> layouts = new ArrayList<File>();
                        layouts.addAll(Arrays.asList(cusPath.listFiles()));
                        if (disPath.isDirectory()) {
                            layouts.addAll(Arrays.asList(disPath.listFiles()));
                        }
                        for (File f : layouts) {
                            PropertiesSet set;
                            if (!f.isFile() || !f.getName().toLowerCase().endsWith(".txt") || (set = PropertiesSerializer.getProperties((String)f.getPath())) == null) continue;
                            m.put(f.getPath(), set);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return m;
        }

        protected boolean isValidMenuIdentifier(String identifier) {
            try {
                if (identifier.equals("%fancymenu:universal_layout%")) {
                    return true;
                }
                if (!this.isCustomGuiName(identifier)) {
                    Class.forName(identifier, false, SetupSharingEngine.class.getClassLoader());
                }
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        protected boolean isCustomGuiName(String name) {
            return this.getCustomGuiNames().contains(name);
        }

        protected List<String> getCustomGuiNames() {
            ArrayList<String> l = new ArrayList<String>();
            try {
                File guiPath;
                if (this.setupInstancePath != null && (guiPath = new File(this.setupInstancePath.getPath() + "/config/fancymenu/customguis")).isDirectory()) {
                    for (File f : guiPath.listFiles()) {
                        if (!f.isFile() || !f.getName().toLowerCase().endsWith(".txt")) continue;
                        l.add(Files.getNameWithoutExtension((String)f.getPath()));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return l;
        }
    }
}

