/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.check.RegisterMod;
import com.natamus.collective_common_neoforge.config.CollectiveConfigHandler;
import com.natamus.collective_common_neoforge.data.GlobalVariables;
import com.natamus.collective_common_neoforge.functions.BlockPosFunctions;
import com.natamus.collective_common_neoforge.functions.EntityFunctions;
import com.natamus.collective_common_neoforge.functions.SpawnEntityFunctions;
import com.natamus.collective_common_neoforge.objects.SAMObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CollectiveEvents {
    public static WeakHashMap<ServerLevel, List<Entity>> entitiesToSpawn = new WeakHashMap();
    public static WeakHashMap<ServerLevel, WeakHashMap<Entity, Entity>> entitiesToRide = new WeakHashMap();
    public static CopyOnWriteArrayList<Pair<Integer, Runnable>> scheduledRunnables = new CopyOnWriteArrayList();

    public static void onWorldTick(ServerLevel serverlevel) {
        if (entitiesToSpawn.computeIfAbsent(serverlevel, k -> new ArrayList()).size() > 0) {
            Entity tospawn = entitiesToSpawn.get(serverlevel).get(0);
            serverlevel.addFreshEntityWithPassengers(tospawn);
            if (entitiesToRide.computeIfAbsent(serverlevel, k -> new WeakHashMap()).containsKey(tospawn)) {
                Entity rider = entitiesToRide.get(serverlevel).get(tospawn);
                rider.startRiding(tospawn);
                entitiesToRide.get(serverlevel).remove(tospawn);
            }
            entitiesToSpawn.get(serverlevel).remove(0);
        }
    }

    public static void onServerTick(MinecraftServer minecraftServer) {
        int serverTickCount = minecraftServer.getTickCount();
        for (Pair<Integer, Runnable> pair : scheduledRunnables) {
            if ((Integer)pair.getFirst() > serverTickCount) continue;
            minecraftServer.tell((Runnable)new TickTask(minecraftServer.getTickCount(), (Runnable)pair.getSecond()));
            scheduledRunnables.remove(pair);
        }
    }

    public static boolean onEntityJoinLevel(Level world, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return true;
        }
        if (RegisterMod.shouldDoCheck && entity instanceof Player) {
            RegisterMod.joinWorldProcess(world, (Player)entity);
        }
        if (entity.isRemoved()) {
            return true;
        }
        if (GlobalVariables.samobjects.isEmpty()) {
            return true;
        }
        Set tags = entity.getTags();
        if (tags.contains("collective.checked")) {
            return true;
        }
        entity.addTag("collective.checked");
        EntityType entitytype = entity.getType();
        if (entitytype == null || !GlobalVariables.activesams.contains(entitytype)) {
            return true;
        }
        boolean isspawner = tags.contains("collective.fromspawner");
        ArrayList<SAMObject> possibles = new ArrayList<SAMObject>();
        for (SAMObject samobject : GlobalVariables.samobjects) {
            if (samobject == null || samobject.fromtype == null || !samobject.fromtype.equals((Object)entitytype) || samobject.spawner && !isspawner || !samobject.spawner && isspawner) continue;
            possibles.add(samobject);
        }
        int size = possibles.size();
        if (size == 0) {
            return true;
        }
        boolean ageable = entity instanceof AgeableMob;
        for (SAMObject sam : possibles) {
            LivingEntity le;
            double num = GlobalVariables.random.nextDouble();
            if (num > sam.chance) continue;
            Vec3 evec = entity.position();
            if (sam.surface && !BlockPosFunctions.isOnSurface(world, evec).booleanValue()) continue;
            Entity to = sam.totype.create(world);
            if (to == null) {
                return true;
            }
            to.setPos(evec.x, evec.y, evec.z);
            if (ageable && to instanceof AgeableMob) {
                AgeableMob am = (AgeableMob)to;
                am.setAge(((AgeableMob)entity).getAge());
                to = am;
            }
            boolean ignoremainhand = false;
            if (sam.helditem != null && to instanceof LivingEntity && !(le = (LivingEntity)to).getMainHandItem().getItem().equals(sam.helditem)) {
                le.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)sam.helditem, 1));
                ignoremainhand = true;
            }
            boolean ride = false;
            if (EntityFunctions.isHorse(to).booleanValue() && sam.rideable) {
                AbstractHorse ah = (AbstractHorse)to;
                ah.setTamed(true);
                ride = true;
            } else if (CollectiveConfigHandler.transferItemsBetweenReplacedEntities) {
                EntityFunctions.transferItemsBetweenEntities(entity, to, ignoremainhand);
            }
            if (!(world instanceof ServerLevel)) {
                return true;
            }
            ServerLevel serverworld = (ServerLevel)world;
            if (ride) {
                SpawnEntityFunctions.startRidingEntityOnNextTick(serverworld, to, entity);
            } else {
                entity.remove(Entity.RemovalReason.DISCARDED);
            }
            to.addTag("collective.checked");
            SpawnEntityFunctions.spawnEntityOnNextTick(serverworld, to);
            return ride;
        }
        return true;
    }
}

