/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.network;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.network.PlayerPreferences;
import io.github.thecsdev.tcdcommons.api.events.server.PlayerManagerEvent;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetwork;
import io.github.thecsdev.tcdcommons.api.network.packet.TCustomPayload;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.netty.buffer.Unpooled;
import java.util.WeakHashMap;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class BetterStatsNetworkHandler {
    public static final class_2561 TXT_TOGGLE_TOOLTIP = TextUtils.translatable((String)"betterstats.network.betterstatsnetworkhandler.toggle_tooltip", (Object[])new Object[0]);
    public static final class_2561 TXT_CONSENT_WARNING = TextUtils.translatable((String)"betterstats.network.betterstatsnetworkhandler.consent_warning", (Object[])new Object[0]);
    public static final int NETWORK_VERSION = 1;
    public static final class_2960 S2C_I_HAVE_BSS;
    public static final class_2960 C2S_LIVE_STATS;
    public static final WeakHashMap<class_3222, PlayerPreferences> PlayerPrefs;

    private BetterStatsNetworkHandler() {
    }

    public static void init() {
    }

    public static void s2c_iHaveBSS(class_3222 player) {
        class_2540 data = new class_2540(Unpooled.buffer());
        data.method_53003(1);
        new TCustomPayload(S2C_I_HAVE_BSS, data).sendS2C(player);
    }

    public static void s2c_liveStats(class_3222 player) {
        if (player == null) {
            return;
        }
        PlayerPreferences prefs = PlayerPrefs.get(player);
        if (prefs == null || !prefs.liveStats) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - prefs.lastLiveStatsUpdate < 300L) {
            return;
        }
        prefs.lastLiveStatsUpdate = currentTime;
        player.method_14248().method_14910(player);
    }

    static {
        String modId = BetterStats.getModID();
        S2C_I_HAVE_BSS = new class_2960(modId, "s2c_bss");
        C2S_LIVE_STATS = new class_2960(modId, "c2s_live_stats");
        PlayerPrefs = new WeakHashMap();
        PlayerManagerEvent.PLAYER_CONNECTED.register(player -> {
            PlayerPrefs.put(player, new PlayerPreferences());
            BetterStatsNetworkHandler.s2c_iHaveBSS(player);
        });
        CustomPayloadNetwork.registerReceiver((class_2598)class_2598.field_11941, (class_2960)C2S_LIVE_STATS, ctx -> {
            PlayerPreferences prefs = PlayerPrefs.get(ctx.getPlayer());
            if (prefs == null) {
                return;
            }
            prefs.liveStats = ctx.getPacketBuffer().readBoolean();
        });
    }
}

