/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.enumerations;

import io.github.thecsdev.betterstats.api.util.stats.SUGeneralStat;
import io.github.thecsdev.betterstats.api.util.stats.SUPlayerBadgeStat;
import io.github.thecsdev.betterstats.api.util.stats.SUStat;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.interfaces.ITextProvider;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2561;

public enum FilterSortCustomsBy implements ITextProvider
{
    DEFAULT((class_2561)TextUtils.translatable((String)"betterstats.api.util.enumerations.filtergroupby.default", (Object[])new Object[0])),
    ALPHABETICAL((class_2561)TextUtils.literal((String)"A-Z")),
    LACITEBAHPLA((class_2561)TextUtils.literal((String)"Z-A")),
    INCREMENTAL((class_2561)TextUtils.literal((String)"0-9")),
    DECREMENTAL((class_2561)TextUtils.literal((String)"9-0"));

    private final class_2561 text;

    private FilterSortCustomsBy(class_2561 text) {
        this.text = Objects.requireNonNull(text);
    }

    public final class_2561 getText() {
        return this.text;
    }

    public final <E extends SUStat<?>> void sortStats(List<E> stats, Function<E, Integer> valueSupplier) {
        FilterSortCustomsBy.sortStats(stats, valueSupplier, this);
    }

    public final void sortGeneralStats(List<SUGeneralStat> stats) {
        FilterSortCustomsBy.sortGeneralStats(stats, this);
    }

    public final void sortPlayerBadgeStats(Map<?, List<SUPlayerBadgeStat>> stats) {
        FilterSortCustomsBy.sortPlayerBadgeStats(stats, this);
    }

    public final void sortPlayerBadgeStats(List<SUPlayerBadgeStat> stats) {
        FilterSortCustomsBy.sortPlayerBadgeStats(stats, this);
    }

    public static final <E extends SUStat<?>> void sortStats(List<E> stats, Function<E, Integer> valueSupplier, FilterSortCustomsBy sortBy) {
        switch (sortBy) {
            case ALPHABETICAL: {
                Collections.sort(stats, Comparator.comparing(stat -> stat.getStatLabel().getString()));
                break;
            }
            case LACITEBAHPLA: {
                Collections.sort(stats, Comparator.comparing(stat -> stat.getStatLabel().getString()).reversed());
                break;
            }
            case INCREMENTAL: {
                Collections.sort(stats, (s1, s2) -> Integer.compare((Integer)valueSupplier.apply(s1), (Integer)valueSupplier.apply(s2)));
                break;
            }
            case DECREMENTAL: {
                Collections.sort(stats, (s1, s2) -> Integer.compare((Integer)valueSupplier.apply(s2), (Integer)valueSupplier.apply(s1)));
                break;
            }
        }
    }

    public static final void sortGeneralStats(List<SUGeneralStat> stats, FilterSortCustomsBy sortBy) {
        FilterSortCustomsBy.sortStats(stats, stat -> stat.value, sortBy);
    }

    public static final void sortPlayerBadgeStats(Map<?, List<SUPlayerBadgeStat>> stats, FilterSortCustomsBy sortBy) {
        for (Map.Entry<?, List<SUPlayerBadgeStat>> entry : stats.entrySet()) {
            FilterSortCustomsBy.sortPlayerBadgeStats(entry.getValue(), sortBy);
        }
    }

    public static final void sortPlayerBadgeStats(List<SUPlayerBadgeStat> stats, FilterSortCustomsBy sortBy) {
        FilterSortCustomsBy.sortStats(stats, stat -> stat.value, sortBy);
    }
}

