/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper;

import dev.tr7zw.itemswapper.accessor.ExtendedMouseHandler;
import dev.tr7zw.itemswapper.config.CacheManager;
import dev.tr7zw.itemswapper.config.ConfigManager;
import dev.tr7zw.itemswapper.config.CustomConfigScreen;
import dev.tr7zw.itemswapper.manager.ClientProviderManager;
import dev.tr7zw.itemswapper.manager.ItemGroupManager;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemGroup;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemList;
import dev.tr7zw.itemswapper.overlay.EditListScreen;
import dev.tr7zw.itemswapper.overlay.ItemListOverlay;
import dev.tr7zw.itemswapper.overlay.ItemSwapperUI;
import dev.tr7zw.itemswapper.overlay.SwitchItemOverlay;
import dev.tr7zw.itemswapper.provider.InstrumentItemNameProvider;
import dev.tr7zw.itemswapper.provider.PotionNameProvider;
import dev.tr7zw.itemswapper.provider.RecordNameProvider;
import dev.tr7zw.itemswapper.provider.ShulkerContainerProvider;
import dev.tr7zw.itemswapper.provider.SmithingTemplateItemNameProvider;
import dev.tr7zw.itemswapper.support.AmecsAPISupport;
import dev.tr7zw.itemswapper.support.ViveCraftSupport;
import dev.tr7zw.itemswapper.util.ComponentProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_642;
import net.minecraft.class_7172;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class ItemSwapperSharedMod {
    public static final Logger LOGGER = LogManager.getLogger((String)"ItemSwapper");
    public static final String MODID = "itemswapper";
    private static class_310 minecraft = class_310.method_1551();
    public static ItemSwapperSharedMod instance;
    private final ConfigManager configManager = ConfigManager.getInstance();
    private final CacheManager cacheManager = CacheManager.getInstance();
    private final ItemGroupManager itemGroupManager = new ItemGroupManager();
    private final ClientProviderManager clientProviderManager = new ClientProviderManager();
    private final List<String> enableOnIp;
    private final List<String> disableOnIp;
    protected class_304 keybind;
    protected class_304 openInventoryKeybind;
    private boolean enableShulkers;
    private boolean enableRefill;
    private boolean modDisabled;
    private boolean disabledByPlayer;
    private boolean bypassAccepted;
    private boolean pressed;
    private boolean lateInitCompleted;
    private class_1792 lastItem;
    private ItemGroupManager.Page lastPage;

    public ItemSwapperSharedMod() {
        this.enableOnIp = this.cacheManager.getCache().enableOnIp;
        this.disableOnIp = this.cacheManager.getCache().disableOnIp;
        this.keybind = new class_304("key.itemswapper.itemswitcher", 82, "ItemSwapper");
        this.openInventoryKeybind = new class_304("key.itemswapper.openInventory", class_3675.field_16237.method_1444(), "ItemSwapper");
        this.enableShulkers = false;
        this.enableRefill = false;
        this.modDisabled = false;
        this.disabledByPlayer = false;
        this.bypassAccepted = false;
        this.pressed = false;
        this.lateInitCompleted = false;
    }

    public void init() {
        instance = this;
        minecraft = class_310.method_1551();
        LOGGER.info("Loading ItemSwapper!");
        this.initModloader();
    }

    private void lateInit() {
        this.clientProviderManager.registerContainerProvider(new ShulkerContainerProvider());
        this.clientProviderManager.registerNameProvider(new PotionNameProvider());
        this.clientProviderManager.registerNameProvider(new RecordNameProvider());
        this.clientProviderManager.registerNameProvider(new InstrumentItemNameProvider());
        this.clientProviderManager.registerNameProvider(new SmithingTemplateItemNameProvider());
    }

    public void clientTick() {
        if (!this.lateInitCompleted) {
            this.lateInitCompleted = true;
            this.lateInit();
        }
        class_437 screen = ItemSwapperSharedMod.minecraft.field_1755;
        class_642 server = class_310.method_1551().method_1558();
        if (server != null && this.disableOnIp.contains(server.field_3761) && !this.disabledByPlayer) {
            this.setDisabledByPlayer(true);
            LOGGER.info("Itemswapper is deactivated for the server {}, because the player did not accept the warning!", (Object)server.field_3761);
        } else if (this.keybind.method_1434()) {
            if (this.isModDisabled()) {
                ItemSwapperSharedMod.minecraft.field_1705.method_1758((class_2561)ComponentProvider.translatable("text.itemswapper.disabled").method_27692(class_124.field_1061), false);
            } else if (screen instanceof ItemSwapperUI) {
                ItemSwapperUI ui = (ItemSwapperUI)screen;
                this.onPress(ui);
            } else if (screen == null) {
                this.onPress(null);
            }
        } else if (this.openInventoryKeybind.method_1434()) {
            if (this.isModDisabled()) {
                ItemSwapperSharedMod.minecraft.field_1705.method_1758((class_2561)ComponentProvider.translatable("text.itemswapper.disabled").method_27692(class_124.field_1061), false);
            } else if (screen == null) {
                ItemSwapperSharedMod.openInventoryScreen();
            }
        } else {
            this.pressed = false;
            if (screen instanceof ItemSwapperUI) {
                ItemSwapperUI ui = (ItemSwapperUI)screen;
                if (!this.configManager.getConfig().toggleMode && !ViveCraftSupport.getInstance().isActive()) {
                    ItemSwapperSharedMod.onPrimaryClick(ui, true);
                }
            }
        }
    }

    private void onPress(ItemSwapperUI overlay) {
        if (ItemSwapperSharedMod.minecraft.field_1724 != null && !this.itemGroupManager.isResourcepackSelected()) {
            ItemSwapperSharedMod.minecraft.field_1724.method_7353((class_2561)ComponentProvider.translatable("text.itemswapper.resourcepack.notSelected").method_27692(class_124.field_1061), true);
        }
        if (!this.pressed && this.isModDisabled()) {
            this.pressed = true;
            ItemSwapperSharedMod.minecraft.field_1705.method_1758((class_2561)ComponentProvider.translatable("text.itemswapper.disabled").method_27692(class_124.field_1061), false);
            return;
        }
        class_642 server = class_310.method_1551().method_1558();
        if (!this.pressed) {
            if (this.isDisabledByPlayer()) {
                ItemSwapperSharedMod.minecraft.field_1705.method_1758((class_2561)ComponentProvider.translatable("text.itemswapper.disabledByPlayer").method_27692(class_124.field_1061), false);
            } else if (!(server == null || this.enableOnIp.contains(server.field_3761) || this.enableShulkers || this.bypassAccepted)) {
                this.openConfirmationScreen();
            } else if (overlay == null) {
                if (!this.bypassAccepted && server != null && this.enableOnIp.contains(server.field_3761)) {
                    this.bypassAccepted = true;
                    ItemSwapperSharedMod.minecraft.field_1705.method_1758((class_2561)ComponentProvider.translatable("text.itemswapper.usedwhitelist").method_27692(class_124.field_1065), false);
                }
                if (this.couldOpenScreen()) {
                    this.pressed = true;
                    return;
                }
            } else {
                ItemSwapperSharedMod.onPrimaryClick(overlay, true);
            }
        }
        this.pressed = true;
    }

    private void openConfirmationScreen() {
        minecraft.method_1507((class_437)new class_410(this::acceptBypassCallback, (class_2561)ComponentProvider.translatable("text.itemswapper.confirm.title"), (class_2561)ComponentProvider.translatable("text.itemswapper.confirm.description")));
    }

    private boolean couldOpenScreen() {
        if (ItemSwapperSharedMod.minecraft.field_1724.method_6047().method_7960()) {
            ItemSwapperSharedMod.openInventoryScreen();
            return true;
        }
        class_1792 itemInHand = ItemSwapperSharedMod.minecraft.field_1724.method_6047().method_7909();
        ItemList entries = this.itemGroupManager.getList(itemInHand);
        if (entries != null) {
            ItemSwapperSharedMod.openScreen(new ItemListOverlay(entries));
            return true;
        }
        ItemGroup group = this.itemGroupManager.getItemPage(itemInHand);
        if (group != null) {
            this.openSquareSwitchScreen(group);
            return true;
        }
        if (this.configManager.getConfig().fallbackInventory) {
            ItemSwapperSharedMod.openInventoryScreen();
            return true;
        }
        return false;
    }

    public static void openInventoryScreen() {
        class_437 class_4372 = ItemSwapperSharedMod.minecraft.field_1755;
        if (class_4372 instanceof SwitchItemOverlay) {
            SwitchItemOverlay overlay = (SwitchItemOverlay)class_4372;
            overlay.openInventory();
            return;
        }
        ItemSwapperSharedMod.openScreen(SwitchItemOverlay.createInventoryOverlay());
    }

    public void openSquareSwitchScreen(ItemGroup group) {
        class_437 class_4372 = ItemSwapperSharedMod.minecraft.field_1755;
        if (class_4372 instanceof SwitchItemOverlay) {
            SwitchItemOverlay overlay = (SwitchItemOverlay)class_4372;
            overlay.openItemGroup(group);
            return;
        }
        SwitchItemOverlay overlay = SwitchItemOverlay.createPaletteOverlay(group);
        ItemSwapperSharedMod.openScreen(overlay);
        if (this.configManager.getConfig().startOnItem) {
            overlay.selectIcon("item|" + class_1792.method_7880((class_1792)ItemSwapperSharedMod.minecraft.field_1724.method_6047().method_7909()), 0, 0);
        }
    }

    public void openPage(ItemGroupManager.Page page) {
        class_437 class_4372 = ItemSwapperSharedMod.minecraft.field_1755;
        if (class_4372 instanceof SwitchItemOverlay) {
            SwitchItemOverlay overlay = (SwitchItemOverlay)class_4372;
            overlay.openPage(page);
            return;
        }
        ItemSwapperSharedMod.openScreen(SwitchItemOverlay.createPageOverlay(page));
    }

    private static void openScreen(class_437 screen) {
        if (!AmecsAPISupport.getInstance().isActive()) {
            ((ExtendedMouseHandler)ItemSwapperSharedMod.minecraft.field_1729).keepMouseGrabbed(true);
        }
        minecraft.method_1507(screen);
        minecraft.method_1483().method_4880();
        if (AmecsAPISupport.getInstance().isActive()) {
            ItemSwapperSharedMod.minecraft.field_1729.method_1612();
        } else {
            ((ExtendedMouseHandler)ItemSwapperSharedMod.minecraft.field_1729).keepMouseGrabbed(false);
        }
    }

    public static void onPrimaryClick(@NotNull ItemSwapperUI xtOverlay, boolean forceClose) {
        boolean keepOpen = xtOverlay.onPrimaryClick();
        if (forceClose || !keepOpen) {
            minecraft.method_1507(null);
            if (!ConfigManager.getInstance().getConfig().allowWalkingWithUI) {
                class_304.method_1424();
            }
        }
    }

    public class_437 createConfigScreen(class_437 parent) {
        return new CustomConfigScreen(parent, "text.itemswapper.title"){
            private CustomConfigScreen inst;
            {
                this.inst = this;
            }

            @Override
            public void initialize() {
                ArrayList<Object> options = new ArrayList<Object>();
                options.add(this.getOnOffOption("text.itemswapper.showTooltips", () -> ItemSwapperSharedMod.this.configManager.getConfig().showTooltips, b -> {
                    ItemSwapperSharedMod.this.configManager.getConfig().showTooltips = b;
                }));
                options.add(this.getOnOffOption("text.itemswapper.toggleMode", () -> ItemSwapperSharedMod.this.configManager.getConfig().toggleMode, b -> {
                    ItemSwapperSharedMod.this.configManager.getConfig().toggleMode = b;
                }));
                options.add(this.getOnOffOption("text.itemswapper.showCursor", () -> ItemSwapperSharedMod.this.configManager.getConfig().showCursor, b -> {
                    ItemSwapperSharedMod.this.configManager.getConfig().showCursor = b;
                }));
                options.add(this.getOnOffOption("text.itemswapper.editMode", () -> ItemSwapperSharedMod.this.configManager.getConfig().editMode, b -> {
                    ItemSwapperSharedMod.this.configManager.getConfig().editMode = b;
                }));
                options.add(this.getOnOffOption("text.itemswapper.creativeCheatMode", () -> ItemSwapperSharedMod.this.configManager.getConfig().creativeCheatMode, b -> {
                    ItemSwapperSharedMod.this.configManager.getConfig().creativeCheatMode = b;
                }));
                options.add(this.getOnOffOption("text.itemswapper.ignoreHotbar", () -> ItemSwapperSharedMod.this.configManager.getConfig().ignoreHotbar, b -> {
                    ItemSwapperSharedMod.this.configManager.getConfig().ignoreHotbar = b;
                }));
                options.add(this.getOnOffOption("text.itemswapper.unlockListMouse", () -> ItemSwapperSharedMod.this.configManager.getConfig().unlockListMouse, b -> {
                    ItemSwapperSharedMod.this.configManager.getConfig().unlockListMouse = b;
                }));
                options.add(this.getOnOffOption("text.itemswapper.disableShulkers", () -> ItemSwapperSharedMod.this.configManager.getConfig().disableShulkers, b -> {
                    ItemSwapperSharedMod.this.configManager.getConfig().disableShulkers = b;
                }));
                options.add(this.getDoubleOption("text.itemswapper.controllerSpeed", 1.0f, 16.0f, 0.1f, () -> ItemSwapperSharedMod.this.configManager.getConfig().controllerSpeed, d -> {
                    ItemSwapperSharedMod.this.configManager.getConfig().controllerSpeed = d.floatValue();
                }));
                options.add(this.getDoubleOption("text.itemswapper.mouseSpeed", 0.1f, 3.0f, 0.1f, () -> ItemSwapperSharedMod.this.configManager.getConfig().mouseSpeed, d -> {
                    ItemSwapperSharedMod.this.configManager.getConfig().mouseSpeed = d.floatValue();
                }));
                options.add(this.getOnOffOption("text.itemswapper.fallbackInventory", () -> ItemSwapperSharedMod.this.configManager.getConfig().fallbackInventory, b -> {
                    ItemSwapperSharedMod.this.configManager.getConfig().fallbackInventory = b;
                }));
                if (ViveCraftSupport.getInstance().isAvailable()) {
                    options.add(this.getOnOffOption("text.itemswapper.vivecraftCompat", () -> ItemSwapperSharedMod.this.configManager.getConfig().vivecraftCompat, b -> {
                        ItemSwapperSharedMod.this.configManager.getConfig().vivecraftCompat = b;
                    }));
                }
                options.add(this.getOnOffOption("text.itemswapper.allowWalkingWithUI", () -> ItemSwapperSharedMod.this.configManager.getConfig().allowWalkingWithUI, b -> {
                    ItemSwapperSharedMod.this.configManager.getConfig().allowWalkingWithUI = b;
                }));
                options.add(this.getOnOffOption("text.itemswapper.startOnItem", () -> ItemSwapperSharedMod.this.configManager.getConfig().startOnItem, b -> {
                    ItemSwapperSharedMod.this.configManager.getConfig().startOnItem = b;
                }));
                this.getOptions().method_20408(options.toArray(new class_7172[0]));
                this.method_37063((class_364)class_4185.method_46430((class_2561)ComponentProvider.translatable("text.itemswapper.whitelist"), (class_4185.class_4241)new class_4185.class_4241(){

                    public void onPress(class_4185 button) {
                        class_310.method_1551().method_1507((class_437)new EditListScreen(inst, class_310.method_1551().field_1690, true));
                    }
                }).method_46433(this.field_22789 / 2 - 210, this.field_22790 - 27).method_46437(50, 20).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)ComponentProvider.translatable("text.itemswapper.blacklist"), (class_4185.class_4241)new class_4185.class_4241(){

                    public void onPress(class_4185 button) {
                        class_310.method_1551().method_1507((class_437)new EditListScreen(inst, class_310.method_1551().field_1690, false));
                    }
                }).method_46433(this.field_22789 / 2 - 160, this.field_22790 - 27).method_46437(50, 20).method_46431());
            }

            @Override
            public void save() {
                ItemSwapperSharedMod.this.configManager.writeConfig();
            }

            @Override
            public void reset() {
                ItemSwapperSharedMod.this.configManager.reset();
            }
        };
    }

    public abstract void initModloader();

    public ItemGroupManager getItemGroupManager() {
        return this.itemGroupManager;
    }

    public void setEnableShulkers(boolean value) {
        this.enableShulkers = value;
    }

    public boolean areShulkersEnabled() {
        return this.enableShulkers;
    }

    public boolean isEnableRefill() {
        return this.enableRefill;
    }

    public void setEnableRefill(boolean enableRefill) {
        this.enableRefill = enableRefill;
    }

    public void setBypassExcepted(boolean bypassExcepted) {
        this.bypassAccepted = bypassExcepted;
    }

    public void setModDisabled(boolean value) {
        this.modDisabled = value;
    }

    public boolean isModDisabled() {
        return this.modDisabled;
    }

    private void acceptBypassCallback(boolean accepted) {
        class_642 server = class_310.method_1551().method_1558();
        if (server != null) {
            if (accepted) {
                this.bypassAccepted = true;
                this.cacheManager.getCache().enableOnIp.add(server.field_3761);
            } else {
                this.cacheManager.getCache().disableOnIp.add(server.field_3761);
            }
            this.cacheManager.writeConfig();
            LOGGER.info("Add {} to cached ip-addresses", (Object)server.field_3761);
        }
        minecraft.method_1507(null);
    }

    public ClientProviderManager getClientProviderManager() {
        return this.clientProviderManager;
    }

    public boolean isDisabledByPlayer() {
        return this.disabledByPlayer;
    }

    public void setDisabledByPlayer(boolean disabledByPlayer) {
        this.disabledByPlayer = disabledByPlayer;
    }

    public class_304 getKeybind() {
        return this.keybind;
    }

    public class_304 getInventoryKeybind() {
        return this.openInventoryKeybind;
    }

    public class_1792 getLastItem() {
        return this.lastItem;
    }

    public void setLastItem(class_1792 lastItem) {
        this.lastItem = lastItem;
    }

    public ItemGroupManager.Page getLastPage() {
        return this.lastPage;
    }

    public void setLastPage(ItemGroupManager.Page lastPage) {
        this.lastPage = lastPage;
    }
}

