/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_features.property_reading.properties.generic_properties;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.texture_features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.utils.entity_wrappers.ETFEntity;

public abstract class StringArrayOrRegexProperty
extends RandomProperty {
    protected static final Pattern GROUP_BY_QUOTATION_PATTERN = Pattern.compile("([^\"]\\S*|\".+?\")\\s*");
    protected final String ORIGINAL_INPUT;
    protected final ObjectOpenHashSet<String> ARRAY;
    protected final RegexAndPatternPropertyMatcher MATCHER;

    protected StringArrayOrRegexProperty(String string) throws RandomProperty.RandomPropertyException {
        this.ORIGINAL_INPUT = string;
        if (string == null || string.isBlank()) {
            throw new RandomProperty.RandomPropertyException(this.getPropertyId() + " property was broken");
        }
        if (string.startsWith("regex:") || string.startsWith("pattern:") || string.startsWith("iregex:") || string.startsWith("ipattern:")) {
            this.MATCHER = StringArrayOrRegexProperty.getStringMatcher_Regex_Pattern_List_Single(string);
            this.ARRAY = ObjectOpenHashSet.of((Object)string);
        } else {
            String[] array = string.trim().split("\\s+");
            if (array.length == 0) {
                throw new RandomProperty.RandomPropertyException(this.getPropertyId() + " property was broken");
            }
            this.ARRAY = new ObjectOpenHashSet();
            for (String str : array) {
                this.ARRAY.add((Object)(this.shouldForceLowerCaseCheck() ? str.toLowerCase() : str));
            }
            this.MATCHER = arg_0 -> this.ARRAY.contains(arg_0);
        }
    }

    @Nullable
    public static RegexAndPatternPropertyMatcher getStringMatcher_Regex_Pattern_List_Single(@Nullable String propertyLineToBeMatchedPossiblyRegex) {
        boolean invert;
        if (propertyLineToBeMatchedPossiblyRegex == null || propertyLineToBeMatchedPossiblyRegex.isBlank()) {
            return null;
        }
        Object stringToMatch = propertyLineToBeMatchedPossiblyRegex.trim();
        if (((String)stringToMatch).startsWith("!")) {
            stringToMatch = ((String)stringToMatch).replaceFirst("!", "");
            invert = true;
        } else {
            invert = false;
        }
        if (((String)stringToMatch).contains("regex:")) {
            if (((String)stringToMatch).contains("iregex:")) {
                Object finalStringToMatch = stringToMatch = ((String)stringToMatch).replaceFirst("iregex:", "");
                return arg_0 -> StringArrayOrRegexProperty.lambda$getStringMatcher_Regex_Pattern_List_Single$0(invert, (String)finalStringToMatch, arg_0);
            }
            Object finalStringToMatch = stringToMatch = ((String)stringToMatch).replaceFirst("regex:", "");
            return arg_0 -> StringArrayOrRegexProperty.lambda$getStringMatcher_Regex_Pattern_List_Single$1(invert, (String)finalStringToMatch, arg_0);
        }
        if (((String)stringToMatch).contains("pattern:")) {
            stringToMatch = "\\Q" + (String)stringToMatch;
            if (((String)(stringToMatch = ((String)stringToMatch).replace("*", "\\E.*\\Q").replace("?", "\\E.+\\Q"))).contains("ipattern:")) {
                Object finalStringToMatch = stringToMatch = ((String)stringToMatch).replace("ipattern:", "");
                return arg_0 -> StringArrayOrRegexProperty.lambda$getStringMatcher_Regex_Pattern_List_Single$2(invert, (String)finalStringToMatch, arg_0);
            }
            Object finalStringToMatch = stringToMatch = ((String)stringToMatch).replace("pattern:", "");
            return arg_0 -> StringArrayOrRegexProperty.lambda$getStringMatcher_Regex_Pattern_List_Single$3(invert, (String)finalStringToMatch, arg_0);
        }
        String finalStringToMatch1 = stringToMatch;
        boolean finalDoPattern = finalStringToMatch1.contains("\"");
        String[] finalSplitMatches = ((String)stringToMatch).split("\\s+");
        return string -> {
            boolean check = false;
            if (string.equals(finalStringToMatch1)) {
                check = true;
            } else {
                for (String singleValue : finalSplitMatches) {
                    if (!string.equals(singleValue)) continue;
                    check = true;
                    break;
                }
                if (finalDoPattern && !check) {
                    Matcher m = GROUP_BY_QUOTATION_PATTERN.matcher(finalStringToMatch1);
                    while (m.find()) {
                        String foundInBrackets = m.group(1).replace("\"", "").trim();
                        if (!string.equals(foundInBrackets)) continue;
                        check = true;
                        break;
                    }
                }
            }
            return invert != check;
        };
    }

    @Override
    public boolean testEntityInternal(ETFEntity entity) {
        String entityString = this.getValueFromEntity(entity);
        if (entityString != null) {
            return this.MATCHER.testString(this.shouldForceLowerCaseCheck() ? entityString.toLowerCase() : entityString);
        }
        return false;
    }

    protected abstract boolean shouldForceLowerCaseCheck();

    @Nullable
    protected abstract String getValueFromEntity(ETFEntity var1);

    @Override
    protected String getPrintableRuleInfo() {
        return this.ORIGINAL_INPUT;
    }

    private static /* synthetic */ boolean lambda$getStringMatcher_Regex_Pattern_List_Single$3(boolean invert, String finalStringToMatch, String string) {
        return invert != string.matches(finalStringToMatch);
    }

    private static /* synthetic */ boolean lambda$getStringMatcher_Regex_Pattern_List_Single$2(boolean invert, String finalStringToMatch, String string) {
        return invert != string.matches("(?i)" + finalStringToMatch);
    }

    private static /* synthetic */ boolean lambda$getStringMatcher_Regex_Pattern_List_Single$1(boolean invert, String finalStringToMatch, String string) {
        return invert != string.matches(finalStringToMatch);
    }

    private static /* synthetic */ boolean lambda$getStringMatcher_Regex_Pattern_List_Single$0(boolean invert, String finalStringToMatch, String string) {
        return invert != string.matches("(?i)" + finalStringToMatch);
    }

    public static interface RegexAndPatternPropertyMatcher {
        public boolean testString(String var1);
    }
}

