/*
 * Decompiled with CFR 0.152.
 */
package farsight;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2666;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_631;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_6603;
import net.minecraft.class_746;
import org.jctools.maps.NonBlockingHashMapLong;

public class FarsightClientChunkManager
extends class_631 {
    private static int EXTRA_CHUNK_DATA_LEEWAY = 10;
    private final NonBlockingHashMapLong<class_2818> chunks = new NonBlockingHashMapLong();
    private final Long2ObjectOpenHashMap<class_2666> unloadedOnServer = new Long2ObjectOpenHashMap();
    private final class_638 world;
    public class_634 packetListener = null;
    public static List<BiConsumer<class_638, class_2818>> unloadCallback = new ArrayList<BiConsumer<class_638, class_2818>>();
    public static List<BiConsumer<class_638, class_2818>> loadCallback = new ArrayList<BiConsumer<class_638, class_2818>>();
    boolean unloading = false;

    public FarsightClientChunkManager(class_638 world) {
        super(world, 5);
        this.world = world;
    }

    public class_2818 method_2857(int x, int z, class_2806 leastStatus, boolean create) {
        class_2818 chunk = (class_2818)this.chunks.get(class_1923.method_8331((int)x, (int)z));
        if (chunk != null) {
            return chunk;
        }
        if (create) {
            return this.field_3676;
        }
        return null;
    }

    public String method_12122() {
        return this.chunks.size() + ", " + this.method_14151();
    }

    public int method_14151() {
        return this.chunks.size();
    }

    public void method_20180(int loadDistance) {
    }

    public class_2818 method_16020(int x, int z, class_2540 buf, class_2487 nbt, Consumer<class_6603.class_6605> consumer) {
        class_2818 levelChunk = (class_2818)this.chunks.get(class_1923.method_8331((int)x, (int)z));
        if (levelChunk == null) {
            levelChunk = new class_2818((class_1937)this.world, new class_1923(x, z));
            levelChunk.method_12224(buf, nbt, consumer);
            this.chunks.put(class_1923.method_8331((int)x, (int)z), (Object)levelChunk);
        } else {
            this.world.method_18110(levelChunk);
            levelChunk.method_12224(buf, nbt, consumer);
        }
        for (BiConsumer<class_638, class_2818> loadCallbackEntry : loadCallback) {
            loadCallbackEntry.accept(this.world, levelChunk);
        }
        this.unloadedOnServer.remove(class_1923.method_8331((int)x, (int)z));
        this.world.method_23782(new class_1923(x, z));
        return levelChunk;
    }

    public void method_2859(class_1923 pos) {
        class_2818 chunk = (class_2818)this.chunks.remove(pos.method_8324());
        if (chunk == null) {
            return;
        }
        for (BiConsumer<class_638, class_2818> unloader : unloadCallback) {
            unloader.accept(this.world, chunk);
        }
        this.world.method_18110(chunk);
    }

    public int getChebyshevDistance(int chunkXa, int chunkZa, int chunkXb, int chunkZb) {
        return Math.max(Math.abs(chunkXa - chunkXb), Math.abs(chunkZa - chunkZb));
    }

    public boolean checkUnload(class_2666 packet) {
        if (this.unloading) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.method_31476().method_24022(packet.comp_1726()) > (Integer)class_310.method_1551().field_1690.method_42503().method_41753() + EXTRA_CHUNK_DATA_LEEWAY) {
            return false;
        }
        this.unloadedOnServer.put(packet.comp_1726().method_8324(), (Object)packet);
        if (player != null) {
            ObjectIterator iterator = this.unloadedOnServer.long2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
                long chunkLong = entry.getLongKey();
                if (this.getChebyshevDistance(player.method_31476().field_9181, player.method_31476().field_9180, class_1923.method_8325((long)chunkLong), class_1923.method_8332((long)chunkLong)) <= (Integer)class_310.method_1551().field_1690.method_42503().method_41753() + EXTRA_CHUNK_DATA_LEEWAY) continue;
                this.unloading = true;
                if (this.packetListener != null) {
                    this.packetListener.method_11107((class_2666)entry.getValue());
                }
                this.unloading = false;
                iterator.remove();
            }
        } else {
            this.unloadedOnServer.clear();
        }
        return true;
    }
}

