/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.resourcepackchecker.configbuilder;

import de.maxhenkel.resourcepackchecker.configbuilder.ConfigBuilderImpl;
import de.maxhenkel.resourcepackchecker.configbuilder.ConfigEntry;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;

public interface ConfigBuilder {
    public ConfigBuilder header(String ... var1);

    public ConfigEntry<Boolean> booleanEntry(String var1, boolean var2, String ... var3);

    public ConfigEntry<Integer> integerEntry(String var1, int var2, int var3, int var4, String ... var5);

    public ConfigEntry<Double> doubleEntry(String var1, double var2, double var4, double var6, String ... var8);

    public ConfigEntry<String> stringEntry(String var1, String var2, String ... var3);

    public ConfigEntry<List<Integer>> integerListEntry(String var1, List<Integer> var2, String ... var3);

    public <E extends Enum<E>> ConfigEntry<E> enumEntry(String var1, E var2, String ... var3);

    public static <C> C build(Path path, Function<ConfigBuilder, C> builderConsumer) {
        return ConfigBuilder.build(path, false, builderConsumer);
    }

    public static <C> C build(Path path, boolean removeUnused, Function<ConfigBuilder, C> builderConsumer) {
        ConfigBuilderImpl builder = ConfigBuilderImpl.buildInternal(path);
        C config = builderConsumer.apply(builder);
        if (removeUnused) {
            builder.removeUnused();
        }
        builder.sortEntries();
        builder.config.save();
        return config;
    }
}

