/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.commons.io.IOUtils;
import team.creative.ambientsounds.AmbientConfig;
import team.creative.ambientsounds.AmbientDimension;
import team.creative.ambientsounds.AmbientRegion;
import team.creative.ambientsounds.AmbientSound;
import team.creative.ambientsounds.AmbientSounds;
import team.creative.ambientsounds.AmbientStackType;
import team.creative.ambientsounds.env.AmbientEnvironment;
import team.creative.ambientsounds.env.feature.AmbientBlockGroup;
import team.creative.ambientsounds.env.feature.AmbientFeature;
import team.creative.ambientsounds.env.pocket.AirPocketGroup;
import team.creative.ambientsounds.sound.AmbientSoundEngine;
import team.creative.creativecore.common.util.type.list.Pair;

public class AmbientEngine {
    public static final class_2960 CONFIG_LOCATION = new class_2960("ambientsounds", "config.json");
    public static final String ENGINE_LOCATION = "engine.json";
    public static final String DIMENSIONS_LOCATION = "dimensions.json";
    public static final String REGIONS_LOCATION = "regions.json";
    public static final String SOUNDS_LOCATION = "sounds.json";
    public static final String FEATURES_LOCATION = "features.json";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new JsonDeserializer<class_2960>(){

        public class_2960 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                return new class_2960(json.getAsString());
            }
            return null;
        }
    }).create();
    private static String loadedEngine;
    protected transient LinkedHashMap<String, AmbientDimension> dimensions = new LinkedHashMap();
    protected transient LinkedHashMap<String, AmbientRegion> allRegions = new LinkedHashMap();
    protected transient LinkedHashMap<String, AmbientRegion> generalRegions = new LinkedHashMap();
    protected transient List<AmbientRegion> activeRegions = new ArrayList<AmbientRegion>();
    protected transient LinkedHashMap<String, AmbientSound> sounds = new LinkedHashMap();
    public transient HashMap<String, AmbientBlockGroup> groups = new HashMap();
    protected transient List<String> silentDimensions = new ArrayList<String>();
    protected transient AmbientSoundEngine soundEngine;
    protected transient AmbientDimension silentDim;
    public transient List<AmbientFeature> features;
    protected transient List<Double> airPocketDistanceFactor;
    public transient int maxAirPocketCount;
    public transient AmbientBlockGroup considerSolid;
    public String name;
    public String version;
    @SerializedName(value="environment-tick-time")
    public int environmentTickTime = 40;
    @SerializedName(value="sound-tick-time")
    public int soundTickTime = 4;
    @SerializedName(value="block-scan-distance")
    public int blockScanDistance = 40;
    @SerializedName(value="average-height-scan-distance")
    public int averageHeightScanDistance = 2;
    @SerializedName(value="average-height-scan-count")
    public int averageHeightScanCount = 5;
    @SerializedName(value="biome-scan-distance")
    public int biomeScanDistance = 5;
    @SerializedName(value="biome-scan-count")
    public int biomeScanCount = 3;
    @SerializedName(value="air-pocket-count")
    public int airPocketCount = 50000;
    @SerializedName(value="air-pocket-distance")
    public int airPocketDistance = 25;
    @SerializedName(value="air-pocket-groups")
    public AirPocketGroup[] airPocketGroups = new AirPocketGroup[0];
    public String[] solids = new String[0];
    @SerializedName(value="biome-types")
    public String[] biomeTypes = new String[0];
    @SerializedName(value="default-biome-type")
    public String defaultBiomeType;
    @SerializedName(value="fade-volume")
    public Double fadeVolume = 0.005;
    @SerializedName(value="fade-pitch")
    public Double fadePitch = 0.005;

    public static boolean hasLoadedAtLeastOnce() {
        return loadedEngine != null;
    }

    public static boolean hasEngineChanged(String newEngine) {
        return loadedEngine == null || !loadedEngine.equals(newEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AmbientEngine attemptToLoadEngine(AmbientSoundEngine soundEngine, class_3300 manager, String name) throws Exception {
        try (InputStream engineInput = ((class_3298)manager.method_14486(new class_2960("ambientsounds", name + "/engine.json")).orElseThrow()).method_14482();){
            InputStream input;
            AmbientEngine engine = (AmbientEngine)GSON.fromJson((JsonElement)JsonParser.parseString((String)IOUtils.toString((InputStream)engineInput, (Charset)Charsets.UTF_8)).getAsJsonObject(), AmbientEngine.class);
            if (!engine.name.equals(name)) {
                throw new Exception("Invalid engine name");
            }
            for (class_3298 resource : manager.method_14489(new class_2960("ambientsounds", name + "/dimensions.json"))) {
                input = resource.method_14482();
                try {
                    JsonArray array = JsonParser.parseString((String)IOUtils.toString((InputStream)input, (Charset)Charsets.UTF_8)).getAsJsonArray();
                    AmbientDimension[] dimensions = (AmbientDimension[])GSON.fromJson((JsonElement)array, AmbientDimension[].class);
                    for (int i = 0; i < dimensions.length; ++i) {
                        AmbientDimension dimension = dimensions[i];
                        if (dimension.name == null || dimension.name.isEmpty()) {
                            AmbientSounds.LOGGER.error("Found invalid dimensions at {}", (Object)i);
                        }
                        engine.dimensions.put(dimension.name, dimension);
                        dimension.load(engine, GSON, manager, array.get(i).getAsJsonObject());
                        for (AmbientRegion region : dimension.regions.values()) {
                            if (!engine.checkRegion(dimension, i, region)) continue;
                            engine.addRegion(region);
                        }
                    }
                }
                finally {
                    input.close();
                }
            }
            for (class_3298 resource : manager.method_14489(new class_2960("ambientsounds", name + "/regions.json"))) {
                input = resource.method_14482();
                try {
                    try {
                        AmbientRegion[] regions = (AmbientRegion[])GSON.fromJson(JsonParser.parseString((String)IOUtils.toString((InputStream)input, (Charset)Charsets.UTF_8)), AmbientRegion[].class);
                        for (int i = 0; i < regions.length; ++i) {
                            AmbientRegion original;
                            AmbientRegion region = regions[i];
                            if (!engine.checkRegion(null, i, region)) continue;
                            if (region.stack != AmbientStackType.overwrite && (original = engine.generalRegions.get(region.name)) != null) {
                                original.apply(region);
                                region = original;
                            }
                            engine.generalRegions.put(region.name, region);
                            region.load(engine, GSON, manager);
                            engine.addRegion(region);
                        }
                    }
                    catch (JsonSyntaxException e) {
                        System.out.println("Failed to load  ambientsounds:" + name + "/regions.json " + resource.method_14480());
                        e.printStackTrace();
                    }
                }
                finally {
                    input.close();
                }
            }
            engine.features = new ArrayList<AmbientFeature>();
            for (class_3298 resource : manager.method_14489(new class_2960("ambientsounds", name + "/features.json"))) {
                input = resource.method_14482();
                try {
                    AmbientFeature[] features = (AmbientFeature[])GSON.fromJson(JsonParser.parseString((String)IOUtils.toString((InputStream)input, (Charset)Charsets.UTF_8)), AmbientFeature[].class);
                    HashSet<String> groups = new HashSet<String>();
                    for (int i = 0; i < features.length; ++i) {
                        AmbientFeature feature = features[i];
                        feature.collectGroups(groups);
                        engine.features.add(feature);
                    }
                    for (String groupName : groups) {
                        AmbientBlockGroup group = new AmbientBlockGroup();
                        for (class_3298 scanResource : manager.method_14489(new class_2960("ambientsounds", name + "/blockgroups/" + groupName + ".json"))) {
                            try (InputStream input2 = scanResource.method_14482();){
                                try {
                                    group.add((String[])GSON.fromJson(JsonParser.parseString((String)IOUtils.toString((InputStream)input2, (Charset)Charsets.UTF_8)), String[].class));
                                }
                                catch (JsonSyntaxException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        engine.groups.put(groupName, group);
                    }
                }
                finally {
                    input.close();
                }
            }
            engine.silentDim = new AmbientDimension();
            engine.silentDim.name = "silent";
            engine.silentDim.volumeSetting = 0.0;
            engine.silentDim.mute = true;
            engine.init();
            engine.soundEngine = soundEngine;
            AmbientSounds.LOGGER.info("Loaded AmbientEngine '{}' v{}. {} dimension(s), {} features, {} groups, {} regions, {} sounds, {} solids and {} biome types", (Object)engine.name, (Object)engine.version, (Object)engine.dimensions.size(), (Object)engine.features.size(), (Object)engine.groups.size(), (Object)engine.allRegions.size(), (Object)engine.sounds.size(), (Object)engine.solids.length, (Object)engine.biomeTypes.length);
            AmbientEngine ambientEngine = engine;
            return ambientEngine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static AmbientEngine loadAmbientEngine(AmbientSoundEngine soundEngine) {
        try {
            class_3300 manager = class_310.method_1551().method_1478();
            InputStream input = ((class_3298)manager.method_14486(CONFIG_LOCATION).orElseThrow()).method_14482();
            AmbientConfig config = (AmbientConfig)GSON.fromJson((JsonElement)JsonParser.parseString((String)IOUtils.toString((InputStream)input, (Charset)Charsets.UTF_8)).getAsJsonObject(), AmbientConfig.class);
            AmbientSounds.CONFIG.engines.updateArray((Object[])config.engines, (Object)config.defaultEngine);
            loadedEngine = (String)AmbientSounds.CONFIG.engines.get();
            AmbientEngine ambientEngine = AmbientEngine.attemptToLoadEngine(soundEngine, manager, (String)AmbientSounds.CONFIG.engines.get());
            input.close();
            return ambientEngine;
            {
                catch (Exception e) {
                    try {
                        AmbientSounds.LOGGER.error("Sound engine {} could not be loaded", AmbientSounds.CONFIG.engines.get());
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        input.close();
                    }
                }
            }
            throw new Exception();
        }
        catch (Exception e) {
            AmbientSounds.LOGGER.error("Not sound engine could be loaded, no sounds will be played!");
            return null;
        }
    }

    public AmbientRegion getRegion(String name) {
        return this.allRegions.get(name);
    }

    protected boolean checkRegion(AmbientDimension dimension, int i, AmbientRegion region) {
        if (region.name == null || region.name.isEmpty()) {
            if (dimension == null) {
                AmbientSounds.LOGGER.error("Found invalid region at {}", (Object)i);
            } else {
                AmbientSounds.LOGGER.error("Found invalid region in '{}' at {}", (Object)dimension.name, (Object)i);
            }
            return false;
        }
        return true;
    }

    protected void addRegion(AmbientRegion region) {
        this.allRegions.put(region.name, region);
        region.volumeSetting = 1.0;
        String prefix = (String)(region.dimension != null ? region.dimension.name + "." : "") + region.name + ".";
        if (region.sounds != null) {
            for (AmbientSound sound : region.sounds.values()) {
                this.sounds.put(prefix + sound.name, sound);
                sound.fullName = prefix + sound.name;
                sound.volumeSetting = 1.0;
            }
        }
    }

    public AmbientDimension getDimension(class_1937 level) {
        String dimensionTypeName = level.method_27983().method_29177().toString();
        if (this.silentDimensions.contains(dimensionTypeName)) {
            return this.silentDim;
        }
        for (AmbientDimension dimension : this.dimensions.values()) {
            if (!dimension.is(level)) continue;
            return dimension;
        }
        return this.silentDim;
    }

    public void stopEngine() {
        if (!this.activeRegions.isEmpty()) {
            for (AmbientRegion region : this.activeRegions) {
                region.deactivate();
            }
            this.activeRegions.clear();
        }
    }

    public int airPocketVolume(int r) {
        int res = 0;
        int i = r;
        while (r > 0) {
            int f = i == r ? 1 : (i == r - 1 ? 4 : (i == r - 2 ? 7 : 8));
            res = (int)((double)res + (double)(f * r * (r + 1)) * 0.5);
            --r;
        }
        return res;
    }

    public void init() {
        this.airPocketDistanceFactor = new ArrayList<Double>();
        for (int i = 0; i < this.airPocketGroups.length; ++i) {
            for (int subDistance = 0; subDistance < this.airPocketGroups[i].distance; ++subDistance) {
                this.airPocketDistanceFactor.add(this.airPocketGroups[i].weight);
            }
        }
        this.maxAirPocketCount = this.airPocketVolume(this.airPocketDistance);
        for (AmbientDimension dimension : this.dimensions.values()) {
            dimension.init(this);
        }
        for (AmbientRegion region : this.allRegions.values()) {
            region.init(this);
        }
        this.considerSolid = new AmbientBlockGroup();
        if (this.solids != null) {
            this.considerSolid.add(this.solids);
        }
        this.onClientLoad();
    }

    public void onClientLoad() {
        this.groups.values().forEach(x -> x.onClientLoad());
        this.considerSolid.onClientLoad();
    }

    public double airWeightFactor(int distance) {
        if (distance >= this.airPocketDistanceFactor.size()) {
            return 0.0;
        }
        return this.airPocketDistanceFactor.get(distance);
    }

    public void tick(AmbientEnvironment env) {
        if (env.dimension.regions != null) {
            for (AmbientRegion region : env.dimension.regions.values()) {
                if (region.tick(env)) {
                    if (region.isActive()) continue;
                    region.activate();
                    this.activeRegions.add(region);
                    continue;
                }
                if (!region.isActive()) continue;
                region.deactivate();
                this.activeRegions.remove(region);
            }
        }
        for (AmbientRegion region : this.generalRegions.values()) {
            if (region.tick(env)) {
                if (region.isActive()) continue;
                region.activate();
                this.activeRegions.add(region);
                continue;
            }
            if (!region.isActive()) continue;
            region.deactivate();
            this.activeRegions.remove(region);
        }
    }

    public void fastTick(AmbientEnvironment env) {
        this.soundEngine.tick();
        if (!this.activeRegions.isEmpty()) {
            Iterator<AmbientRegion> iterator = this.activeRegions.iterator();
            while (iterator.hasNext()) {
                AmbientRegion region = iterator.next();
                if (region.fastTick(env)) continue;
                region.deactivate();
                iterator.remove();
            }
        }
    }

    public void changeDimension(AmbientEnvironment env, AmbientDimension newDimension) {
        if (env.dimension == null || env.dimension.regions == null) {
            return;
        }
        for (AmbientRegion region : env.dimension.regions.values()) {
            if (!region.isActive()) continue;
            region.deactivate();
            this.activeRegions.remove(region);
        }
    }

    public void collectDetails(List<Pair<String, Object>> details) {
        details.add((Pair<String, Object>)new Pair((Object)"", (Object)(this.name + " v" + this.version)));
    }
}

