/*
 * Decompiled with CFR 0.152.
 */
package net.lizistired.cavedust;

import java.nio.file.Path;
import net.lizistired.cavedust.CaveDust;
import net.lizistired.cavedust.utils.JsonFile;
import net.lizistired.cavedust.utils.MathHelper;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class CaveDustConfig
extends JsonFile {
    private final transient CaveDust CaveDust;
    private int dimensionX = 5;
    private int dimensionY = 5;
    private int dimensionZ = 5;
    private int velocityRandomness = 1;
    private boolean caveDustEnabled = true;
    private boolean seaLevelCheck = true;
    private boolean superFlatStatus = false;
    private float upperLimit = 64.0f;
    private float lowerLimit = -64.0f;
    private int particleMultiplier = 1;
    private int particleMultiplierMultiplier = 10;
    private int particleID = net.lizistired.cavedust.CaveDust.WHITE_ASH_ID;

    public CaveDustConfig(Path file, CaveDust caveDust) {
        super(file);
        this.CaveDust = caveDust;
    }

    public float setDimensionsX(float size) {
        if ((float)this.dimensionX != size) {
            this.dimensionX = (int)size;
            this.save();
        }
        return this.getDimensionsX();
    }

    public float setDimensionsY(float size) {
        if ((float)this.dimensionY != size) {
            this.dimensionY = (int)size;
            this.save();
        }
        return this.getDimensionsY();
    }

    public float setDimensionsZ(float size) {
        if ((float)this.dimensionZ != size) {
            this.dimensionZ = (int)size;
            this.save();
        }
        return this.getDimensionsZ();
    }

    public float getDimensionsX() {
        return this.dimensionX;
    }

    public float getDimensionsY() {
        return this.dimensionY;
    }

    public float getDimensionsZ() {
        return this.dimensionZ;
    }

    public float setUpperLimit(float upperLimit) {
        if (this.upperLimit - 1.0f < this.getLowerLimit()) {
            return this.getUpperLimit();
        }
        if (this.upperLimit != upperLimit) {
            this.upperLimit = (int)upperLimit;
            this.save();
        }
        return this.getUpperLimit();
    }

    public float getUpperLimit() {
        return this.upperLimit;
    }

    public float setLowerLimit(float lowerLimit) {
        if (this.lowerLimit + 1.0f > this.getUpperLimit()) {
            return this.getLowerLimit();
        }
        if (this.lowerLimit != lowerLimit) {
            this.lowerLimit = (int)lowerLimit;
            this.save();
        }
        return this.getLowerLimit();
    }

    public float getLowerLimit() {
        return this.lowerLimit;
    }

    public int getParticleMultiplier() {
        return this.particleMultiplier;
    }

    public float setParticleMultiplier(float particleMultiplier) {
        this.particleMultiplier = (int)particleMultiplier;
        this.save();
        return this.getParticleMultiplier();
    }

    public int getParticleMultiplierMultiplier() {
        return this.particleMultiplierMultiplier;
    }

    public float setParticleMultiplierMultiplier(float particleMultiplierMultiplier) {
        this.particleMultiplierMultiplier = (int)particleMultiplierMultiplier;
        this.save();
        return this.getParticleMultiplierMultiplier();
    }

    public boolean toggleCaveDust() {
        this.caveDustEnabled = !this.caveDustEnabled;
        this.save();
        return this.caveDustEnabled;
    }

    public boolean getCaveDustEnabled() {
        return this.caveDustEnabled;
    }

    public class_2394 setParticle(String particleType) {
        this.save();
        return this.getParticle();
    }

    public class_2394 getParticle() {
        try {
            return (class_2394)class_7923.field_41180.method_10223(new class_2960(((class_5321)((class_6880.class_6883)class_7923.field_41180.method_40265(this.getParticleID()).get()).method_40230().get()).method_29177().toString().toLowerCase()));
        }
        catch (ClassCastException e) {
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"Issue loading particle, defaulting to white ash particle!"), false);
            this.setParticleID(net.lizistired.cavedust.CaveDust.WHITE_ASH_ID);
            this.save();
            return class_2398.field_23956;
        }
    }

    public boolean getSeaLevelCheck() {
        return this.seaLevelCheck;
    }

    public boolean setSeaLevelCheck() {
        this.seaLevelCheck = !this.seaLevelCheck;
        this.save();
        return this.getSeaLevelCheck();
    }

    public float getVelocityRandomnessRandom() {
        if (this.velocityRandomness == 0) {
            return 0.0f;
        }
        return (float)MathHelper.generateRandomDouble(-this.velocityRandomness, this.velocityRandomness);
    }

    public float getVelocityRandomness() {
        return this.velocityRandomness;
    }

    public float setVelocityRandomness(float velocityRandomness) {
        this.velocityRandomness = (int)velocityRandomness;
        this.save();
        return this.getVelocityRandomness();
    }

    public boolean getSuperFlatStatus() {
        return this.superFlatStatus;
    }

    public boolean setSuperFlatStatus() {
        this.superFlatStatus = !this.superFlatStatus;
        this.save();
        return this.getSuperFlatStatus();
    }

    public void iterateParticle() {
        if (this.getParticleID() > class_7923.field_41180.method_10204() - 2) {
            this.particleID = 1;
            this.save();
        } else {
            this.particleID = this.getParticleID() + 1;
            this.save();
        }
    }

    public void setParticleID(int particleID) {
        this.particleID = particleID;
        this.save();
    }

    public int getParticleID() {
        if (!class_7923.field_41180.method_40265(this.particleID).isPresent()) {
            this.setParticleID(net.lizistired.cavedust.CaveDust.WHITE_ASH_ID);
        }
        return this.particleID;
    }

    public void resetConfig() {
        this.dimensionX = 5;
        this.dimensionY = 5;
        this.dimensionZ = 5;
        this.upperLimit = 64.0f;
        this.lowerLimit = -64.0f;
        this.particleMultiplier = 1;
        this.particleMultiplierMultiplier = 10;
        this.seaLevelCheck = true;
        this.caveDustEnabled = true;
        this.particleID = net.lizistired.cavedust.CaveDust.WHITE_ASH_ID;
        this.save();
    }
}

