/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.collection;

import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBox;
import team.creative.creativecore.common.gui.controls.collection.GuiListBoxBase;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.mc.ColorUtils;

public class GuiComboBoxExtension
extends GuiListBoxBase<GuiComboBoxEntry> {
    public GuiComboBox comboBox;
    public String search = "";

    public GuiComboBoxExtension(String name, GuiComboBox comboBox) {
        super(name, false, new ArrayList());
        this.comboBox = comboBox;
        this.registerEventChanged(event -> {
            if (event.control.is("searchBar")) {
                this.search = ((GuiTextfield)event.control).getText();
                this.reloadControls();
            }
        });
        this.reloadControls();
    }

    @Override
    public void looseFocus() {
        this.comboBox.extensionLostFocus = true;
    }

    public void reloadControls() {
        if (this.comboBox == null) {
            return;
        }
        GuiTextfield textfield = (GuiTextfield)this.get("searchBar");
        this.clearItems();
        if (this.search != null && this.search.isBlank()) {
            this.search = null;
        }
        if (this.comboBox.hasSearchbar()) {
            if (textfield == null) {
                textfield = new GuiTextfield("searchBar", this.search == null ? "" : this.search);
                this.addCustomControl(textfield.setExpandableX());
            }
            textfield.focus();
        }
        ArrayList<GuiComboBoxEntry> entries = new ArrayList<GuiComboBoxEntry>();
        for (int i = 0; i < this.comboBox.lines.length; ++i) {
            if (this.search != null && !this.comboBox.lines[i].contains(this.search)) continue;
            entries.add(new GuiComboBoxEntry("" + i, i, i == this.comboBox.getIndex()).set(this.comboBox.lines[i].copy()));
        }
        this.addAllItems(entries);
        if (this.hasGui()) {
            this.reflowInternal();
        }
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (super.mouseClicked(rect, x, y, button)) {
            this.comboBox.extensionLostFocus = false;
            return true;
        }
        return false;
    }

    @Override
    protected int maxHeight(int width, int availableWidth) {
        return 100;
    }

    public class GuiComboBoxEntry
    extends GuiLabel {
        public final int index;
        public final boolean selected;

        public GuiComboBoxEntry(String name, int index, boolean selected) {
            super(name);
            this.index = index;
            this.selected = selected;
            this.setExpandableX();
        }

        public GuiComboBoxEntry set(CompiledText text) {
            this.text = text;
            return this;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        protected void renderContent(class_332 graphics, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
            if (this.selected) {
                this.text.setDefaultColor(rect.inside(mouseX, mouseY) ? ColorUtils.rgba(230, 230, 0, 255) : ColorUtils.rgba(200, 200, 0, 255));
            } else if (rect.inside(mouseX, mouseY)) {
                this.text.setDefaultColor(-256);
            } else {
                this.text.setDefaultColor(-1);
            }
            super.renderContent(graphics, control, rect, mouseX, mouseY);
            this.text.setDefaultColor(-1);
        }

        @Override
        public boolean mouseClicked(Rect rect, double x, double y, int button) {
            GuiComboBoxExtension.this.comboBox.select(this.index);
            GuiComboBoxExtension.this.comboBox.closeBox();
            GuiComboBoxEntry.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
            return true;
        }
    }
}

