/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.embedded.ca.solostudios.stringsimilarity;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.Levenshtein;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.interfaces.NormalizedStringDistance;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.interfaces.NormalizedStringSimilarity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\t\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\bR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/NormalizedLevenshtein;", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/interfaces/NormalizedStringDistance;", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/interfaces/NormalizedStringSimilarity;", "", "s1", "s2", "", "distance", "(Ljava/lang/String;Ljava/lang/String;)D", "similarity", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/Levenshtein;", "levenshtein", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/Levenshtein;", "<init>", "()V", "kt-string-similarity"})
public final class NormalizedLevenshtein
implements NormalizedStringDistance,
NormalizedStringSimilarity {
    @NotNull
    private final Levenshtein levenshtein = new Levenshtein();

    @Override
    public double distance(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        if (Intrinsics.areEqual((Object)s1, (Object)s2)) {
            return 0.0;
        }
        int n = s1.length();
        int n2 = s2.length();
        boolean bl = false;
        int maxLen = Math.max(n, n2);
        return maxLen == 0 ? 0.0 : this.levenshtein.distance(s1, s2) / (double)maxLen;
    }

    @Override
    public double similarity(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        return 1.0 - this.distance(s1, s2);
    }
}

