/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.itemswapper.manager.itemgroups.Icon;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemEntry;
import dev.tr7zw.itemswapper.util.ItemUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1087;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;

public final class RenderHelper {
    private static final class_310 minecraft = class_310.method_1551();

    private RenderHelper() {
    }

    public static void renderUnavailableItem(class_332 graphics, class_1309 livingEntity, class_1799 itemStack, int i, int j, int k, SlotEffect effect) {
        if (itemStack.method_7960()) {
            return;
        }
        float blitOffset = 0.0f;
        class_1087 bakedModel = minecraft.method_1480().method_4019(itemStack, null, livingEntity, k);
        blitOffset = bakedModel.method_4712() ? blitOffset + 50.0f : blitOffset + 50.0f;
        int l = i;
        int m = j;
        int color = 0;
        if (effect == SlotEffect.RED) {
            color = 0x30FF0000;
        } else if (effect == SlotEffect.GRAY) {
            color = -1879048192;
        }
        graphics.method_25294(l - 1, m - 1, l + 17, m + 17, color);
        graphics.method_51445(itemStack, l, m);
        if (k == 0) {
            graphics.method_51431(RenderHelper.minecraft.field_1772, itemStack, l, m);
        }
        blitOffset = bakedModel.method_4712() ? blitOffset - 50.0f : blitOffset - 50.0f;
    }

    public static void renderGuiItemCount(class_327 font, String text, int i, int j, int color) {
        RenderHelper.renderGuiItemText(font, text, i + 19 - 2 - font.method_1727(text), j + 6 + 3, color);
    }

    public static void renderGuiItemName(class_327 font, String text, int i, int j, int color) {
        RenderHelper.renderGuiItemText(font, text, i - font.method_1727(text) / 2, j, color);
    }

    public static void renderGuiItemName(class_327 font, List<class_5481> text, int x, int y, int color) {
        RenderHelper.renderGuiItemText(font, text, x, y, color);
    }

    public static void renderGuiItemText(class_327 font, List<class_5481> text, int x, int y, int color) {
        class_4587 poseStack = new class_4587();
        for (int line = 0; line < text.size(); ++line) {
            poseStack.method_22904(0.0, 0.0, 400.0);
            class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            float f = x - font.method_30880(text.get(line)) / 2;
            Objects.requireNonNull(font);
            font.method_22942(text.get(line), f, (float)(y - 9 * (text.size() - line)), color, true, poseStack.method_23760().method_23761(), (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            bufferSource.method_22993();
        }
    }

    public static void renderGuiItemText(class_327 font, String text, int i, int j, int color) {
        class_4587 poseStack = new class_4587();
        String string2 = text;
        poseStack.method_22904(0.0, 0.0, 400.0);
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        font.method_27521(string2, (float)i, (float)j, color, true, poseStack.method_23760().method_23761(), (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        bufferSource.method_22993();
    }

    public static void renderSlot(class_332 graphics, int x, int y, class_1657 arg, class_1799 arg2, int k, SlotEffect effect, int count) {
        if (!arg2.method_7960()) {
            int color;
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            class_1799 copy = arg2.method_7972();
            copy.method_7939(1);
            if (effect != SlotEffect.NONE) {
                RenderHelper.renderUnavailableItem(graphics, (class_1309)arg, copy, x, y, k, effect);
                graphics.method_51448().method_22909();
                return;
            }
            graphics.method_51423((class_1309)arg, copy, x, y, k);
            RenderSystem.setShader(class_757::method_34540);
            graphics.method_51431(RenderHelper.minecraft.field_1772, copy, x, y);
            int n = color = count > 64 ? 0xFFFF00 : 0xFFFFFF;
            if (count > 1) {
                RenderHelper.renderGuiItemCount(RenderHelper.minecraft.field_1772, "" + Math.min(64, count), x, y, color);
            }
            graphics.method_51448().method_22909();
        }
    }

    public static class_2561 getName(ItemEntry entry) {
        if (entry == null) {
            return null;
        }
        if (entry.getNameOverwride() != null) {
            return entry.getNameOverwride();
        }
        return ItemUtil.getDisplayname(entry.getItem().method_7854());
    }

    public static class_2561 getName(Icon.ItemIcon entry) {
        if (entry == null) {
            return null;
        }
        if (entry.nameOverwrite() != null) {
            return entry.nameOverwrite();
        }
        return entry.item().method_7964();
    }

    public static class_2561 getName(Icon.LinkIcon entry) {
        if (entry == null) {
            return null;
        }
        if (entry.nameOverwrite() != null) {
            return entry.nameOverwrite();
        }
        return entry.item().method_7964();
    }

    public static void renderSelectedItemName(class_2561 comp, class_1799 arg2, boolean grayOut, int offsetY, int maxWidth) {
        int originX = minecraft.method_22683().method_4486() / 2;
        int originY = minecraft.method_22683().method_4502() / 2;
        class_5251 textColor = arg2.method_7964().method_10866().method_10973();
        class_124 rarityColor = arg2.method_7932().field_8908;
        int color = 0xFFFFFF;
        if (grayOut) {
            color = 0xAAAAAA;
        } else if (textColor != null) {
            color = textColor.method_27716();
        } else if (rarityColor != null && rarityColor.method_532() != null) {
            color = rarityColor.method_532();
        }
        RenderHelper.renderGuiItemName(RenderHelper.minecraft.field_1772, RenderHelper.minecraft.field_1772.method_1728((class_5348)comp, maxWidth), originX, originY - offsetY / 2 - 12, color);
    }

    public static void renderSelectedEntryName(class_2561 comp, boolean grayOut, int offsetY, int maxWidth) {
        int originX = minecraft.method_22683().method_4486() / 2;
        int originY = minecraft.method_22683().method_4502() / 2;
        int color = 0xFFFFFF;
        if (grayOut) {
            color = 0xAAAAAA;
        }
        RenderHelper.renderGuiItemName(RenderHelper.minecraft.field_1772, RenderHelper.minecraft.field_1772.method_1728((class_5348)comp, maxWidth), originX, originY - offsetY / 2 - 12, color);
    }

    public static enum SlotEffect {
        NONE,
        RED,
        GRAY;

    }
}

