/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.overlay.logic;

import dev.tr7zw.itemswapper.overlay.logic.GuiSlot;
import dev.tr7zw.itemswapper.overlay.logic.GuiWidget;
import dev.tr7zw.itemswapper.support.ViveCraftSupport;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3532;

public class GuiSelectionHandler {
    private List<GuiWidget> widgets = new ArrayList<GuiWidget>();
    private GuiWidget selectedWidget = null;
    private GuiSlot selectedSlot = null;
    private double mouseX = 0.0;
    private double mouseY = 0.0;
    private double cursorX = 0.0;
    private double cursorY = 0.0;
    private double limitX = 5.0;
    private double limitY = 5.0;
    private double deadZone = 1.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;

    public void updateSelection(double x, double y) {
        if (ViveCraftSupport.getInstance().isActive()) {
            this.cursorX = this.mouseX;
            this.cursorY = this.mouseY;
        } else {
            this.cursorX += x;
            this.cursorY += y;
            this.cursorX = class_3532.method_15350((double)this.cursorX, (double)(-this.limitX), (double)this.limitX);
            this.cursorY = class_3532.method_15350((double)this.cursorY, (double)(-this.limitY), (double)this.limitY);
        }
        this.updateSelection();
    }

    public void updateMousePosition(double x, double y) {
        this.mouseX = x;
        this.mouseY = y;
    }

    private void updateSelection() {
        double centerDist;
        if (this.selectedSlot != null) {
            this.selectedSlot.selected().set(false);
            this.selectedSlot = null;
            this.selectedWidget = null;
        }
        if ((centerDist = Math.sqrt(this.cursorX * this.cursorX + this.cursorY * this.cursorY)) < this.deadZone) {
            return;
        }
        double best = Double.MAX_VALUE;
        for (GuiWidget widget : this.widgets) {
            for (GuiSlot slot : widget.getSlots()) {
                int halfSlot = slot.size() / 2;
                double mouseDist = Math.sqrt((this.cursorX - 3.0 - (double)slot.x() - (double)widget.getWidgetArea().getX() - (double)halfSlot) * (this.cursorX - 3.0 - (double)slot.x() - (double)widget.getWidgetArea().getX() - (double)halfSlot) + (this.cursorY - 4.0 - (double)slot.y() - (double)widget.getWidgetArea().getY() - (double)halfSlot) * (this.cursorY - 4.0 - (double)slot.y() - (double)widget.getWidgetArea().getY() - (double)halfSlot));
                double maxDistance = (double)slot.size() * Math.sqrt(2.0) / 2.0;
                if (!(mouseDist < best) || !(mouseDist < maxDistance)) continue;
                best = mouseDist;
                this.selectedWidget = widget;
                this.selectedSlot = slot;
                this.offsetX = this.cursorX - 3.0 - (double)slot.x() - (double)widget.getWidgetArea().getX() - (double)halfSlot;
                this.offsetY = this.cursorY - 3.0 - (double)slot.y() - (double)widget.getWidgetArea().getY() - (double)halfSlot;
            }
        }
        if (this.selectedSlot != null) {
            this.selectedSlot.selected().set(true);
        }
    }

    public boolean select(String selector, int xOffset, int yOffset) {
        for (GuiWidget widget : this.widgets) {
            for (GuiSlot slot : widget.getSlots()) {
                if (!selector.equals(widget.getSelector(slot))) continue;
                int halfSlot = slot.size() / 2;
                this.cursorX = slot.x() + 3 + widget.getWidgetArea().getX() + halfSlot + xOffset;
                this.cursorY = slot.y() + 3 + widget.getWidgetArea().getY() + halfSlot + yOffset;
                return true;
            }
        }
        return false;
    }

    public GuiWidget getSelectedWidget() {
        return this.selectedWidget;
    }

    public GuiSlot getSelectedSlot() {
        return this.selectedSlot;
    }

    public void addWidget(GuiWidget widget) {
        this.widgets.add(widget);
        this.limitX = Math.max(this.limitX, (double)(widget.getWidgetArea().getMouseBoundsX() + widget.getWidgetArea().getX()));
        this.limitY = Math.max(this.limitY, (double)(widget.getWidgetArea().getMouseBoundsY() + widget.getWidgetArea().getY()));
    }

    public List<GuiWidget> getWidgets() {
        return this.widgets;
    }

    public void reset() {
        this.widgets.clear();
        this.selectedSlot = null;
        this.selectedWidget = null;
        this.limitX = 5.0;
        this.limitY = 5.0;
    }

    public double getCursorX() {
        return this.cursorX;
    }

    public double getCursorY() {
        return this.cursorY;
    }

    public void setLimitX(double limitX) {
        this.limitX = limitX;
    }

    public void setLimitY(double limitY) {
        this.limitY = limitY;
    }

    public void setDeadZone(double deadZone) {
        this.deadZone = deadZone;
    }

    public double getLimitX() {
        return this.limitX;
    }

    public double getLimitY() {
        return this.limitY;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }
}

