/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.items.playerentity;

import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.resources.SelfcleaningDynamicTexture;
import de.keksuccino.konkrete.resources.WebTextureResourceLocation;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SkinWebTextureResourceLocation
extends WebTextureResourceLocation {
    private static final Logger LOGGER = LogManager.getLogger();
    protected volatile boolean loaded = false;
    protected volatile int width = 0;
    protected volatile int height = 0;
    protected volatile class_2960 location = null;
    protected volatile String url;
    protected volatile class_1011 downloadedTexture = null;

    public SkinWebTextureResourceLocation(String url) {
        super(url);
        this.url = url;
    }

    @Nullable
    public class_1011 getDownloadedTexture() {
        return this.downloadedTexture;
    }

    public void downloadTexture() {
        InputStream in = null;
        try {
            URL u = new URL(this.url);
            HttpURLConnection httpcon = (HttpURLConnection)u.openConnection();
            httpcon.addRequestProperty("User-Agent", "Mozilla/4.0");
            in = httpcon.getInputStream();
            if (in == null) {
                return;
            }
            class_1011 i = class_1011.method_4309((InputStream)in);
            this.width = i.method_4307();
            this.height = i.method_4323();
            if (this.height < 64) {
                class_1011 skinNew = new class_1011(64, 64, true);
                skinNew.method_4317(i);
                int xOffsetLeg = 16;
                int yOffsetLeg = 32;
                SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 4, 16, 4, 4, xOffsetLeg, yOffsetLeg, true);
                SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 8, 16, 4, 4, xOffsetLeg, yOffsetLeg, true);
                SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 0, 20, 4, 12, xOffsetLeg + 8, yOffsetLeg, true);
                SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 4, 20, 4, 12, xOffsetLeg, yOffsetLeg, true);
                SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 8, 20, 4, 12, xOffsetLeg - 8, yOffsetLeg, true);
                SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 12, 20, 4, 12, xOffsetLeg, yOffsetLeg, true);
                int xOffsetArm = -8;
                int yOffsetArm = 32;
                SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 44, 16, 4, 4, xOffsetArm, yOffsetArm, true);
                SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 48, 16, 4, 4, xOffsetArm, yOffsetArm, true);
                SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 40, 20, 4, 12, xOffsetArm + 8, yOffsetArm, true);
                SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 44, 20, 4, 12, xOffsetArm, yOffsetArm, true);
                SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 48, 20, 4, 12, xOffsetArm - 8, yOffsetArm, true);
                SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 52, 20, 4, 12, xOffsetArm, yOffsetArm, true);
                i = skinNew;
            }
            this.downloadedTexture = i;
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Can't download texture '" + this.url + "'!");
            ex.printStackTrace();
        }
        if (in != null) {
            IOUtils.closeQuietly(in);
        }
    }

    public void loadTexture() {
        if (!this.loaded) {
            if (class_310.method_1551().method_1531() == null) {
                LOGGER.error("[FANCYMENU] Can't load texture '" + this.url + "'! Minecraft TextureManager instance not ready yet!");
                return;
            }
            if (this.downloadedTexture == null) {
                this.downloadTexture();
            }
            if (this.downloadedTexture != null) {
                try {
                    this.location = class_310.method_1551().method_1531().method_4617(this.filterUrl(this.url), (class_1043)new SelfcleaningDynamicTexture(this.downloadedTexture));
                    this.loaded = true;
                }
                catch (Exception var5) {
                    LOGGER.error("[FANCYMENU] Can't load texture '" + this.url + "'! Texture registration failed!");
                    this.loaded = false;
                    var5.printStackTrace();
                }
            } else {
                LOGGER.error("[FANCYMENU] Can't load texture'" + this.url + "'! Downloaded texture is NULL!");
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public class_2960 getResourceLocation() {
        return this.location;
    }

    public String getURL() {
        return this.url;
    }

    public boolean isReady() {
        return this.loaded;
    }

    protected String filterUrl(String url) {
        CharacterFilter c = new CharacterFilter();
        c.addAllowedCharacters(new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "."});
        return c.filterForAllowedChars(url.toLowerCase());
    }

    protected static void copyPixelArea(class_1011 in, int xFrom, int yFrom, int xTo, int yTo, int width, int height, boolean mirrorX) {
        int vertOffset = 0;
        int vertical = yTo;
        while (vertical < yTo + height) {
            int horiOffset = 0;
            if (mirrorX) {
                horiOffset = width - 1;
            }
            int horizontal = xTo;
            while (horizontal < xTo + width) {
                int pixel = in.method_4315(xFrom + horiOffset, yFrom + vertOffset);
                in.method_4305(horizontal, vertical, pixel);
                ++horizontal;
                if (mirrorX) {
                    --horiOffset;
                    continue;
                }
                ++horiOffset;
            }
            ++vertical;
            ++vertOffset;
        }
    }

    protected static void cloneSkinPart(class_1011 in, int xStart, int yStart, int width, int height, int xOffset, int yOffset, boolean mirrorX) {
        SkinWebTextureResourceLocation.copyPixelArea(in, xStart, yStart, xStart + xOffset, yStart + yOffset, width, height, mirrorX);
    }
}

