/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.button;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.events.InitOrResizeScreenCompletedEvent;
import de.keksuccino.fancymenu.events.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.button.ButtonData;
import de.keksuccino.fancymenu.menu.button.identification.ButtonIdentificator;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.mixin.client.IMixinScreen;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.events.EventBase;
import de.keksuccino.konkrete.events.SubscribeEvent;
import de.keksuccino.konkrete.localization.LocaleUtils;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_446;

public class ButtonCache {
    private static Map<Long, ButtonData> buttons = new HashMap<Long, ButtonData>();
    private static Map<Long, class_339> replaced = new HashMap<Long, class_339>();
    private static class_437 current = null;
    private static boolean cached = false;
    private static boolean caching = false;
    private static Map<String, class_339> customButtons = new HashMap<String, class_339>();

    @SubscribeEvent
    public void updateCache(InitOrResizeScreenEvent.Post e) {
        if (!caching) {
            cached = false;
            current = e.getScreen();
        }
    }

    @SubscribeEvent
    public void onInitCompleted(InitOrResizeScreenCompletedEvent e) {
        ButtonCache.cache(e.getScreen());
    }

    private static void cache(class_437 s) {
        if (!cached) {
            cached = true;
            if (s instanceof LayoutEditorScreen) {
                return;
            }
            if (!MenuCustomization.isMenuCustomizable(s)) {
                replaced.clear();
                buttons.clear();
                Konkrete.getEventHandler().callEventsFor((EventBase)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s != null && s instanceof class_446 && FancyMenu.isOptifineLoaded()) {
                replaced.clear();
                buttons.clear();
                Konkrete.getEventHandler().callEventsFor((EventBase)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s.getClass().getName().startsWith("slimeknights.")) {
                replaced.clear();
                buttons.clear();
                Konkrete.getEventHandler().callEventsFor((EventBase)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s.getClass().getName().startsWith("net.optifine")) {
                replaced.clear();
                buttons.clear();
                Konkrete.getEventHandler().callEventsFor((EventBase)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s == class_310.method_1551().field_1755) {
                ButtonCache.updateButtons(s);
            }
            Konkrete.getEventHandler().callEventsFor((EventBase)new ButtonCachedEvent(s, ButtonCache.getButtons(), true));
        }
    }

    private static void updateButtons(class_437 s) {
        replaced.clear();
        buttons.clear();
        if (!MenuCustomization.isMenuCustomizable(s)) {
            return;
        }
        if (s != null && s instanceof class_446 && FancyMenu.isOptifineLoaded()) {
            return;
        }
        if (s.getClass().getName().startsWith("slimeknights.")) {
            return;
        }
        if (s.getClass().getName().startsWith("net.optifine")) {
            return;
        }
        List<ButtonData> ids = ButtonCache.cacheButtons(s, 1000, 1000);
        List<ButtonData> btns = ButtonCache.cacheButtons(s, class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502());
        if (btns.size() == ids.size()) {
            int i = 0;
            for (ButtonData id : ids) {
                ButtonData button = btns.get(i);
                if (!buttons.containsKey(id.getId())) {
                    buttons.put(id.getId(), new ButtonData(button.getButton(), id.getId(), LocaleUtils.getKeyForString((String)button.getButton().method_25369().getString()), s));
                } else if (((Boolean)FancyMenu.config.getOrDefault("showdebugwarnings", (Object)true)).booleanValue()) {
                    System.out.println("");
                    System.out.println("## WARNING [FANCYMENU]: Overlapping buttons found! ##");
                    System.out.println("At: X=" + button.x + " Y=" + button.y);
                    System.out.println("Labels: " + button.label + ", " + ButtonCache.buttons.get((Object)Long.valueOf((long)id.getId())).label);
                    System.out.println("");
                    System.out.println("FancyMenu found overlapping buttons and wasn't able to generate working IDs for them to make them customizable!");
                    System.out.println("Please report this to the mod author of FancyMenu and give informations about what buttons caused it.");
                    System.out.println("#####################################################");
                    System.out.println("");
                }
                ++i;
            }
        }
        ArrayList<String> compIds = new ArrayList<String>();
        for (ButtonData d : buttons.values()) {
            ButtonIdentificator.setCompatibilityIdentifierToData(d);
            if (compIds.contains(d.compatibilityId)) {
                d.compatibilityId = null;
                continue;
            }
            compIds.add(d.compatibilityId);
        }
    }

    public static List<ButtonData> cacheButtons(class_437 s, int screenWidth, int screenHeight) {
        caching = true;
        ArrayList<ButtonData> buttonDataList = new ArrayList<ButtonData>();
        ArrayList<Long> ids = new ArrayList<Long>();
        try {
            ((IMixinScreen)s).setFontFancyMenu(class_310.method_1551().field_1772);
            s.method_25410(class_310.method_1551(), screenWidth, screenHeight);
            ArrayList<class_339> widgets = new ArrayList<class_339>();
            for (class_4068 r : ((IMixinScreen)s).getRenderablesFancyMenu()) {
                if (!(r instanceof class_339)) continue;
                widgets.add((class_339)r);
            }
            for (class_339 w : widgets) {
                String idRaw = "" + w.field_22760 + w.field_22761;
                long id = 0L;
                if (MathUtils.isLong((String)idRaw)) {
                    id = ButtonCache.getAvailableIdFromBaseId(Long.parseLong(idRaw), ids);
                }
                ids.add(id);
                buttonDataList.add(new ButtonData(w, id, LocaleUtils.getKeyForString((String)w.method_25369().getString()), s));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        caching = false;
        return buttonDataList;
    }

    protected static Long getAvailableIdFromBaseId(long baseId, List<Long> ids) {
        String newId;
        if (ids.contains(baseId) && MathUtils.isLong((String)(newId = baseId + "1"))) {
            return ButtonCache.getAvailableIdFromBaseId(Long.parseLong(newId), ids);
        }
        return baseId;
    }

    public static void cacheFrom(class_437 s, int screenWidth, int screenHeight) {
        ButtonCache.updateButtons(s);
    }

    public static String getKeyForButton(class_339 w) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (m.getValue().getButton() != w) continue;
            return m.getValue().getKey();
        }
        return null;
    }

    public static ButtonData getButtonForId(long id) {
        return buttons.get(id);
    }

    public static ButtonData getButtonForCompatibilityId(String id) {
        for (ButtonData d : buttons.values()) {
            if (d.getCompatibilityId() == null || !d.getCompatibilityId().equals(id)) continue;
            return d;
        }
        return null;
    }

    public static ButtonData getButtonForKey(String key) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (!m.getValue().getKey().equalsIgnoreCase(key)) continue;
            return m.getValue();
        }
        return null;
    }

    public static ButtonData getButtonForName(String name) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (!m.getValue().label.equals(name)) continue;
            return m.getValue();
        }
        return null;
    }

    public static List<ButtonData> getButtons() {
        ArrayList<ButtonData> b = new ArrayList<ButtonData>();
        b.addAll(buttons.values());
        return b;
    }

    public static boolean isCaching() {
        return caching;
    }

    public static void clearCustomButtonCache() {
        customButtons.clear();
    }

    public static void cacheCustomButton(String id, class_339 w) {
        customButtons.put(id, w);
    }

    public static class_339 getCustomButton(String id) {
        return customButtons.get(id);
    }
}

